/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.hunter.MoCEntityManticorePet;
import drzhark.mocreatures.entity.neutral.MoCEntityWyvern;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.EnumArgument;

public class CommandMoCSpawn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mocspawn").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entityType", (ArgumentType)EnumArgument.enumArgument(Type.class)).executes(context -> CommandMoCSpawn.execute((CommandSourceStack)context.getSource(), (Type)((Object)((Object)context.getArgument("entityType", Type.class))), 0))).then(Commands.m_82129_((String)"type", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CommandMoCSpawn.execute((CommandSourceStack)context.getSource(), (Type)((Object)((Object)context.getArgument("entityType", Type.class))), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"))))));
    }

    private static int execute(CommandSourceStack source, Type entityType, int type) {
        try {
            ServerPlayer player = source.m_230896_();
            Level level = player.m_9236_();
            MoCEntityTameableAnimal specialEntity = null;
            switch (entityType) {
                case horse: {
                    specialEntity = new MoCEntityHorse((EntityType<? extends MoCEntityHorse>)((EntityType)MoCEntities.WILDHORSE.get()), level);
                    specialEntity.setAdult(true);
                    break;
                }
                case manticore: {
                    specialEntity = new MoCEntityManticorePet((EntityType<? extends MoCEntityManticorePet>)((EntityType)MoCEntities.MANTICORE_PET.get()), level);
                    specialEntity.setAdult(true);
                    break;
                }
                case wyvern: {
                    specialEntity = new MoCEntityWyvern((EntityType<? extends MoCEntityWyvern>)((EntityType)MoCEntities.WYVERN.get()), level);
                    specialEntity.setAdult(false);
                    break;
                }
                case wyvernghost: {
                    specialEntity = new MoCEntityWyvern((EntityType<? extends MoCEntityWyvern>)((EntityType)MoCEntities.WYVERN.get()), level);
                    specialEntity.setAdult(false);
                    ((MoCEntityWyvern)specialEntity).setIsGhost(true);
                    break;
                }
                default: {
                    source.m_81352_((Component)Component.m_237113_((String)("ERROR: The entity spawn type " + entityType + " is not a valid type.")));
                    return 1;
                }
            }
            double dist = 3.0;
            double newPosY = player.m_20186_();
            double newPosX = player.m_20185_() - dist * Math.cos(MoCTools.realAngle(player.m_146908_() - 90.0f) / 57.29578f);
            double newPosZ = player.m_20189_() - dist * Math.sin(MoCTools.realAngle(player.m_146908_() - 90.0f) / 57.29578f);
            specialEntity.m_6034_(newPosX, newPosY, newPosZ);
            specialEntity.setTamed(true);
            specialEntity.setOwnerId(null);
            specialEntity.setPetName("Rename_Me");
            specialEntity.setTypeMoC(type);
            if (entityType == Type.horse && (type < 0 || type > 67) || entityType == Type.wyvern && (type < 0 || type > 12) || entityType == Type.manticore && (type < 0 || type > 4)) {
                source.m_81352_((Component)Component.m_237113_((String)("ERROR: The spawn type " + type + " is not a valid type.")));
                return 1;
            }
            level.m_7967_((Entity)specialEntity);
            if (!level.m_5776_()) {
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 64.0, level.m_46472_())), (Object)new MoCMessageAppear(specialEntity.m_19879_()));
            }
            MoCTools.playCustomSound((Entity)specialEntity, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private static enum Type {
        horse,
        manticore,
        wyvern,
        wyvernghost;

    }
}

