/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.ITeleporter;

public class CommandMoCTP {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"moctp").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"petId", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int petId = IntegerArgumentType.getInteger((CommandContext)context, (String)"petId");
            return CommandMoCTP.teleportPet((CommandSourceStack)context.getSource(), petId, ((CommandSourceStack)context.getSource()).m_81375_());
        })).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            int petId = IntegerArgumentType.getInteger((CommandContext)context, (String)"petId");
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            return CommandMoCTP.teleportPet((CommandSourceStack)context.getSource(), petId, player);
        }))));
    }

    private static int teleportPet(CommandSourceStack source, int petId, ServerPlayer player) {
        MoCPetData ownerPetData = MoCreatures.instance.mapData.getPetData(player.m_20148_());
        if (ownerPetData != null) {
            for (int i = 0; i < ownerPetData.getTamedList().size(); ++i) {
                CompoundTag nbt = ownerPetData.getTamedList().m_128728_(i);
                if (!nbt.m_128441_("PetId") || nbt.m_128451_("PetId") != petId) continue;
                String petName = nbt.m_128461_("Name");
                ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("Dimension")));
                ServerLevel world = source.m_81377_().m_129880_(dimensionKey);
                if (world == null) continue;
                if (!CommandMoCTP.teleportLoadedPet(world, player, petId, petName, source)) {
                    double posX = nbt.m_128437_("Pos", 6).m_128772_(0);
                    double posY = nbt.m_128437_("Pos", 6).m_128772_(1);
                    double posZ = nbt.m_128437_("Pos", 6).m_128772_(2);
                    int x = (int)Math.floor(posX);
                    int y = (int)Math.floor(posY);
                    int z = (int)Math.floor(posZ);
                    source.m_288197_(() -> Component.m_237113_((String)("Found unloaded pet " + nbt.m_128461_("id") + " with name " + petName + " at location " + x + ", " + y + ", " + z + " with Pet ID " + nbt.m_128451_("PetId"))), true);
                    boolean result = CommandMoCTP.teleportLoadedPet(world, player, petId, petName, source);
                    if (!result) {
                        source.m_81352_((Component)Component.m_237113_((String)("Unable to transfer entity ID " + petId + ". It may only be transferred to " + player.m_7755_().getString())));
                    }
                }
                return 1;
            }
        }
        source.m_81352_((Component)Component.m_237113_((String)"Tamed entity could not be located."));
        return 0;
    }

    private static boolean teleportLoadedPet(ServerLevel world, ServerPlayer player, int petId, String petName, CommandSourceStack source) {
        for (Entity entity : world.m_8583_()) {
            IMoCTameable tameable;
            if (!(entity instanceof IMoCTameable) || (tameable = (IMoCTameable)entity).getPetName().isEmpty() || tameable.getOwnerPetId() != petId) continue;
            CompoundTag compound = new CompoundTag();
            entity.m_20223_(compound);
            if (compound.m_128456_() || compound.m_128461_("Owner").isEmpty()) continue;
            String owner = compound.m_128461_("Owner");
            String name = compound.m_128461_("Name");
            if (owner.isEmpty() || !owner.equalsIgnoreCase(player.m_7755_().getString())) continue;
            if (entity.m_9236_().m_46472_() == player.m_9236_().m_46472_()) {
                entity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            } else if (!player.m_9236_().m_5776_()) {
                ServerLevel targetLevel = player.m_284548_();
                entity.changeDimension(targetLevel, (ITeleporter)new PetTeleporter(player.m_20185_(), player.m_20186_(), player.m_20189_()));
            }
            source.m_288197_(() -> Component.m_237113_((String)(name + " has been teleported to location " + Math.round(player.m_20185_()) + ", " + Math.round(player.m_20186_()) + ", " + Math.round(player.m_20189_()) + " in dimension " + player.m_9236_().m_46472_().m_135782_())), true);
            return true;
        }
        return false;
    }

    private static class PetTeleporter
    implements ITeleporter {
        private final double x;
        private final double y;
        private final double z;

        public PetTeleporter(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            Entity newEntity = repositionEntity.apply(false);
            if (newEntity != null) {
                newEntity.m_6034_(this.x, this.y, this.z);
                newEntity.m_146922_(yaw);
            }
            return newEntity;
        }
    }
}

