/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import drzhark.mocreatures.MoCreatures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class CommandMoCreatures {
    private static final List<String> commands = new ArrayList<String>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder mocCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"moc").requires(source -> source.m_6761_(2));
        for (String setting : List.of("attackhorses", "attackwolves", "debug", "destroydrops", "enablehunters", "easybreeding", "elephantbulldozer", "enableownership", "enableresetownerscroll", "golemdestroyblocks")) {
            mocCommand.then(Commands.m_82127_((String)setting).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
                boolean value = BoolArgumentType.getBool((CommandContext)context, (String)"value");
                return CommandMoCreatures.setBooleanSetting((CommandSourceStack)context.getSource(), setting, value);
            })));
        }
        mocCommand.then(Commands.m_82127_((String)"ogrestrength").then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> {
            float value = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            return CommandMoCreatures.setFloatSetting((CommandSourceStack)context.getSource(), "ogrestrength", value);
        })));
        for (String setting : List.of("ogreattackrange", "ostricheggdropchance", "rareitemdropchance", "maxtamedperop", "maxtamedperplayer", "motherwyverneggdropchance", "wyverneggdropchance")) {
            mocCommand.then(Commands.m_82127_((String)setting).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
                int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
                return CommandMoCreatures.setIntSetting((CommandSourceStack)context.getSource(), setting, value);
            })));
        }
        mocCommand.then(Commands.m_82127_((String)"help").executes(context -> CommandMoCreatures.showHelp((CommandSourceStack)context.getSource())));
        dispatcher.register(mocCommand);
    }

    private static int showHelp(CommandSourceStack source) {
        source.m_288197_(() -> Component.m_237113_((String)"MoCreatures Commands:"), false);
        for (String command : commands) {
            source.m_288197_(() -> Component.m_237113_((String)command), false);
        }
        return 1;
    }

    private static int setBooleanSetting(CommandSourceStack source, String setting, boolean value) {
        try {
            boolean result = false;
            switch (setting) {
                case "debug": {
                    MoCreatures.proxy.debug = value;
                    result = true;
                    break;
                }
                case "attackhorses": {
                    MoCreatures.proxy.attackHorses = value;
                    result = true;
                    break;
                }
                case "attackwolves": {
                    MoCreatures.proxy.attackWolves = value;
                    result = true;
                    break;
                }
                case "destroydrops": {
                    MoCreatures.proxy.destroyDrops = value;
                    result = true;
                    break;
                }
                case "enablehunters": {
                    MoCreatures.proxy.enableHunters = value;
                    result = true;
                    break;
                }
                case "easybreeding": {
                    MoCreatures.proxy.easyHorseBreeding = value;
                    result = true;
                    break;
                }
                case "elephantbulldozer": {
                    MoCreatures.proxy.elephantBulldozer = value;
                    result = true;
                    break;
                }
                case "enableownership": {
                    MoCreatures.proxy.enableOwnership = value;
                    result = true;
                    break;
                }
                case "enableresetownerscroll": {
                    MoCreatures.proxy.enableResetOwnership = value;
                    result = true;
                    break;
                }
                case "golemdestroyblocks": {
                    MoCreatures.proxy.golemDestroyBlocks = value;
                    result = true;
                    break;
                }
                default: {
                    source.m_81352_((Component)Component.m_237113_((String)("Unknown boolean setting: " + setting)));
                    return 0;
                }
            }
            if (result) {
                MoCreatures.proxy.mocSettingsConfig.save();
                source.m_288197_(() -> Component.m_237113_((String)("Successfully set " + setting + " to " + value)), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Failed to set " + setting)));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Error: " + e.getMessage())));
            return 0;
        }
    }

    private static int setFloatSetting(CommandSourceStack source, String setting, float value) {
        try {
            boolean result = false;
            switch (setting) {
                case "ogrestrength": {
                    MoCreatures.proxy.ogreStrength = value;
                    result = true;
                    break;
                }
                default: {
                    source.m_81352_((Component)Component.m_237113_((String)("Unknown float setting: " + setting)));
                    return 0;
                }
            }
            if (result) {
                MoCreatures.proxy.mocSettingsConfig.save();
                source.m_288197_(() -> Component.m_237113_((String)("Successfully set " + setting + " to " + value)), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Failed to set " + setting)));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Error: " + e.getMessage())));
            return 0;
        }
    }

    private static int setIntSetting(CommandSourceStack source, String setting, int value) {
        try {
            boolean result = false;
            switch (setting) {
                case "ogreattackrange": {
                    MoCreatures.proxy.ogreAttackRange = (short)value;
                    result = true;
                    break;
                }
                case "ostricheggdropchance": {
                    MoCreatures.proxy.ostrichEggDropChance = value;
                    result = true;
                    break;
                }
                case "rareitemdropchance": {
                    MoCreatures.proxy.rareItemDropChance = value;
                    result = true;
                    break;
                }
                case "maxtamedperop": {
                    MoCreatures.proxy.maxOPTamed = value;
                    result = true;
                    break;
                }
                case "maxtamedperplayer": {
                    MoCreatures.proxy.maxTamed = value;
                    result = true;
                    break;
                }
                case "motherwyverneggdropchance": {
                    MoCreatures.proxy.motherWyvernEggDropChance = value;
                    result = true;
                    break;
                }
                case "wyverneggdropchance": {
                    MoCreatures.proxy.wyvernEggDropChance = value;
                    result = true;
                    break;
                }
                default: {
                    source.m_81352_((Component)Component.m_237113_((String)("Unknown integer setting: " + setting)));
                    return 0;
                }
            }
            if (result) {
                MoCreatures.proxy.mocSettingsConfig.save();
                source.m_288197_(() -> Component.m_237113_((String)("Successfully set " + setting + " to " + value)), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("Failed to set " + setting)));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Error: " + e.getMessage())));
            return 0;
        }
    }

    static {
        commands.add("/moc attackhorses <boolean>");
        commands.add("/moc attackwolves <boolean>");
        commands.add("/moc debug <boolean>");
        commands.add("/moc destroydrops <boolean>");
        commands.add("/moc enablehunters <boolean>");
        commands.add("/moc easybreeding <boolean>");
        commands.add("/moc elephantbulldozer <boolean>");
        commands.add("/moc enableownership <boolean>");
        commands.add("/moc enableresetownerscroll <boolean>");
        commands.add("/moc golemdestroyblocks <boolean>");
        commands.add("/moc ogreattackrange <int>");
        commands.add("/moc ogrestrength <float>");
        commands.add("/moc ostricheggdropchance <int>");
        commands.add("/moc rareitemdropchance <int>");
        commands.add("/moc maxtamedperop <int>");
        commands.add("/moc maxtamedperplayer <int>");
        commands.add("/moc motherwyverneggdropchance <int>");
        commands.add("/moc wyverneggdropchance <int>");
        commands.add("/moc help");
    }
}

