/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command.multision;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.network.command.multision.MoCHorseType;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandSpawnMoCHorse {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mocsummon").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"horse").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(MoCHorseType.getNames(), (SuggestionsBuilder)builder)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            String typeName = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            return CommandSpawnMoCHorse.summonHorse(player, typeName, false);
        })).then(Commands.m_82127_((String)"tame").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            String typeName = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            return CommandSpawnMoCHorse.summonHorse(player, typeName, true);
        })))));
    }

    private static int summonHorse(ServerPlayer player, String typeName, boolean tame) {
        Level level = player.m_9236_();
        BlockPos pos = player.m_20183_();
        Optional<MoCHorseType> horseType = MoCHorseType.fromName(typeName);
        if (horseType.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)("Invalid horse type: " + typeName)));
            return 0;
        }
        MoCEntityHorse horse = new MoCEntityHorse((EntityType<? extends MoCEntityHorse>)((EntityType)MoCEntities.WILDHORSE.get()), level);
        horse.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        horse.setTypeMoC(horseType.get().getId());
        if (tame) {
            MoCTools.tameWithName((Player)player, horse);
        }
        level.m_7967_((Entity)horse);
        player.m_213846_((Component)Component.m_237113_((String)("Spawned MoC Horse of type " + typeName + (tame ? " (Tamed)" : ""))));
        return 1;
    }
}

