/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command.multision;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.init.MoCEntities;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class MoCDebugSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mocdebug").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").then(Commands.m_82127_((String)"info").executes(MoCDebugSpawnCommand::showSpawnInfo))).then(Commands.m_82127_((String)"test").then(Commands.m_82129_((String)"entity", (ArgumentType)StringArgumentType.word()).executes(MoCDebugSpawnCommand::testSpawn)))).then(Commands.m_82127_((String)"check").executes(MoCDebugSpawnCommand::checkSpawnConditions)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"on").executes(MoCDebugSpawnCommand::enableDebug))).then(Commands.m_82127_((String)"off").executes(MoCDebugSpawnCommand::disableDebug))));
    }

    private static int showSpawnInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        ServerLevel level = source.m_81372_();
        BlockPos pos = player.m_20183_();
        Holder biome = level.m_204166_(pos);
        ResourceLocation biomeName = (ResourceLocation)biome.m_203439_().map(resourceKey -> resourceKey.m_135782_(), biomeObj -> ResourceLocation.fromNamespaceAndPath((String)"unknown", (String)"biome"));
        source.m_288197_(() -> Component.m_237113_((String)"=== MoCreatures Spawn Debug Info ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)("Current biome: " + biomeName)), false);
        source.m_288197_(() -> Component.m_237113_((String)("Entity map size: " + MoCreatures.entityMap.size())), false);
        source.m_288197_(() -> Component.m_237113_((String)("MocEntity map size: " + MoCreatures.mocEntityMap.size())), false);
        source.m_288197_(() -> Component.m_237113_((String)("Spawn multiplier: " + MoCreatures.proxy.spawnMultiplier)), false);
        MobSpawnSettings spawnSettings = ((Biome)biome.m_203334_()).m_47518_();
        List creatures = spawnSettings.m_151798_(MobCategory.CREATURE).m_146338_();
        List monsters = spawnSettings.m_151798_(MobCategory.MONSTER).m_146338_();
        List water = spawnSettings.m_151798_(MobCategory.WATER_CREATURE).m_146338_();
        List ambient = spawnSettings.m_151798_(MobCategory.AMBIENT).m_146338_();
        source.m_288197_(() -> Component.m_237113_((String)("Biome spawn counts - Creatures: " + creatures.size() + ", Monsters: " + monsters.size() + ", Water: " + water.size() + ", Ambient: " + ambient.size())), false);
        if (!MoCreatures.mocEntityMap.isEmpty()) {
            MoCEntityData sampleData = (MoCEntityData)MoCreatures.mocEntityMap.values().iterator().next();
            source.m_288197_(() -> Component.m_237113_((String)("Sample entity: " + sampleData.getEntityName() + " (CanSpawn: " + sampleData.getCanSpawn() + ", Freq: " + sampleData.getFrequency() + ")")), false);
        }
        source.m_288197_(() -> Component.m_237113_((String)"Use '/mocdebug spawn test <entity>' to test spawning"), false);
        return 1;
    }

    private static int testSpawn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        block20: {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            ServerLevel level = source.m_81372_();
            String entityName = StringArgumentType.getString(context, (String)"entity");
            try {
                EntityType entityType = null;
                switch (entityName.toLowerCase()) {
                    case "bunny": {
                        entityType = (EntityType)MoCEntities.BUNNY.get();
                        break;
                    }
                    case "bear": 
                    case "blackbear": {
                        entityType = (EntityType)MoCEntities.BLACK_BEAR.get();
                        break;
                    }
                    case "bird": {
                        entityType = (EntityType)MoCEntities.BIRD.get();
                        break;
                    }
                    case "ant": {
                        entityType = (EntityType)MoCEntities.ANT.get();
                        break;
                    }
                    case "mouse": {
                        entityType = (EntityType)MoCEntities.MOUSE.get();
                        break;
                    }
                    default: {
                        source.m_81352_((Component)Component.m_237113_((String)("Unknown entity: " + entityName + ". Try: bunny, bear, bird, ant, mouse")));
                        return 0;
                    }
                }
                Mob entity = (Mob)entityType.m_20615_((Level)level);
                if (entity != null) {
                    BlockPos spawnPos = player.m_20183_().m_7918_(2, 1, 0);
                    entity.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                    level.m_7967_((Entity)entity);
                    source.m_288197_(() -> Component.m_237113_((String)("Spawned " + entityName + " at " + spawnPos)), false);
                    MoCEntityData data = (MoCEntityData)MoCreatures.entityMap.get((Object)entityType);
                    if (data != null) {
                        source.m_288197_(() -> Component.m_237113_((String)("Entity data - CanSpawn: " + data.getCanSpawn() + ", Frequency: " + data.getFrequency())), false);
                    } else {
                        source.m_288197_(() -> Component.m_237113_((String)("Warning: No entity data found for " + entityName)), false);
                    }
                    break block20;
                }
                source.m_81352_((Component)Component.m_237113_((String)("Failed to create entity: " + entityName)));
                return 0;
            }
            catch (Exception e) {
                source.m_81352_((Component)Component.m_237113_((String)("Error spawning entity: " + e.getMessage())));
                MoCreatures.LOGGER.error("Error in debug spawn command", (Throwable)e);
                return 0;
            }
        }
        return 1;
    }

    private static int checkSpawnConditions(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        ServerLevel level = source.m_81372_();
        BlockPos pos = player.m_20183_();
        source.m_288197_(() -> Component.m_237113_((String)"=== Spawn Conditions Check ==="), false);
        boolean doMobSpawning = level.m_46469_().m_46207_(GameRules.f_46134_);
        source.m_288197_(() -> Component.m_237113_((String)("doMobSpawning: " + doMobSpawning)), false);
        Difficulty difficulty = level.m_46791_();
        source.m_288197_(() -> Component.m_237113_((String)("Difficulty: " + difficulty)), false);
        int lightLevel = level.m_46803_(pos);
        source.m_288197_(() -> Component.m_237113_((String)("Light level: " + lightLevel)), false);
        BlockPos spawnPos = level.m_220360_();
        double distanceToSpawn = Math.sqrt(pos.m_123331_((Vec3i)spawnPos));
        source.m_288197_(() -> Component.m_237113_((String)("Distance to spawn: " + String.format("%.1f", distanceToSpawn))), false);
        Holder biome = level.m_204166_(pos);
        MobSpawnSettings spawnSettings = ((Biome)biome.m_203334_()).m_47518_();
        int[] mocCreatureCount = new int[]{0};
        for (MobCategory category : MobCategory.values()) {
            List spawners = spawnSettings.m_151798_(category).m_146338_();
            if (spawners.isEmpty()) continue;
            boolean foundMocInCategory = false;
            for (MobSpawnSettings.SpawnerData spawner : spawners) {
                String entityName = spawner.f_48404_.m_20675_();
                if (!entityName.contains("mocreatures")) continue;
                if (!foundMocInCategory) {
                    String finalCategoryName = category.m_21607_();
                    source.m_288197_(() -> Component.m_237113_((String)("=== " + finalCategoryName.toUpperCase() + " Category ===")), false);
                    foundMocInCategory = true;
                }
                mocCreatureCount[0] = mocCreatureCount[0] + 1;
                String finalEntityName = entityName;
                int finalWeight = spawner.m_142631_().m_146281_();
                source.m_288197_(() -> Component.m_237113_((String)("  " + finalEntityName + " (weight: " + finalWeight + ")")), false);
            }
        }
        source.m_288197_(() -> Component.m_237113_((String)("Total MoCreatures spawns in this biome: " + mocCreatureCount[0])), false);
        if (!doMobSpawning) {
            source.m_288197_(() -> Component.m_237113_((String)"\u26a0 Issue: Mob spawning is disabled!"), false);
        }
        if (difficulty == Difficulty.PEACEFUL) {
            source.m_288197_(() -> Component.m_237113_((String)"\u26a0 Issue: Peaceful mode prevents monster spawning!"), false);
        }
        if (mocCreatureCount[0] == 0) {
            source.m_288197_(() -> Component.m_237113_((String)"\u26a0 Issue: No MoCreatures spawns found in this biome!"), false);
        }
        return 1;
    }

    private static int enableDebug(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MoCreatures.proxy.debug = true;
        MoCreatures.setDebug(true);
        source.m_288197_(() -> Component.m_237113_((String)"Mo'Creatures debug mode enabled"), false);
        return 1;
    }

    private static int disableDebug(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MoCreatures.proxy.debug = false;
        MoCreatures.setDebug(false);
        source.m_288197_(() -> Component.m_237113_((String)"Mo'Creatures debug mode disabled"), false);
        return 1;
    }
}

