/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.message;

import drzhark.mocreatures.entity.IMoCEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MoCMessageAnimation {
    public int entityId;
    public int animationType;

    public MoCMessageAnimation(int entityId, int animationType) {
        this.entityId = entityId;
        this.animationType = animationType;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.animationType);
    }

    public MoCMessageAnimation(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.animationType = buffer.readInt();
    }

    public static void onMessage(MoCMessageAnimation message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && (entity = minecraft.f_91073_.m_6815_(message.entityId)) instanceof IMoCEntity) {
                ((IMoCEntity)entity).performAnimation(message.animationType);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return String.format("MoCMessageAnimation - entityId:%s, animationType:%s", this.entityId, this.animationType);
    }
}

