/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MoCMessageAttachedEntity {
    public int sourceEntityId;
    public int targetEntityId;

    public MoCMessageAttachedEntity(int sourceEntityId, int targetEntityId) {
        this.sourceEntityId = sourceEntityId;
        this.targetEntityId = targetEntityId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.sourceEntityId);
        buffer.writeInt(this.targetEntityId);
    }

    public MoCMessageAttachedEntity(FriendlyByteBuf buffer) {
        this.sourceEntityId = buffer.readInt();
        this.targetEntityId = buffer.readInt();
    }

    public static void onMessage(MoCMessageAttachedEntity message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                Entity sourceEntity = minecraft.f_91073_.m_6815_(message.sourceEntityId);
                Entity targetEntity = minecraft.f_91073_.m_6815_(message.targetEntityId);
                if (sourceEntity != null && targetEntity != null) {
                    sourceEntity.m_20329_(targetEntity);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return String.format("MoCMessageAttachedEntity - sourceEntityId:%s, targetEntityId:%s", this.sourceEntityId, this.targetEntityId);
    }
}

