/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.message;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MoCMessageInstaSpawn {
    public int entityId;
    public int numberToSpawn;

    public MoCMessageInstaSpawn(int entityId, int numberToSpawn) {
        this.entityId = entityId;
        this.numberToSpawn = numberToSpawn;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.numberToSpawn);
    }

    public MoCMessageInstaSpawn(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.numberToSpawn = buffer.readInt();
    }

    public static void onMessage(MoCMessageInstaSpawn message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (MoCreatures.proxy.getProxyMode() == 1 && MoCreatures.proxy.allowInstaSpawn || MoCreatures.proxy.getProxyMode() == 2) {
                MoCTools.spawnNearPlayer(((NetworkEvent.Context)ctx.get()).getSender(), message.entityId, message.numberToSpawn);
                if (MoCreatures.proxy.debug) {
                    MoCreatures.LOGGER.info("Player " + ((NetworkEvent.Context)ctx.get()).getSender().m_7755_() + " used MoC instaspawner and got " + message.numberToSpawn + " creatures spawned");
                }
            } else if (MoCreatures.proxy.debug) {
                MoCreatures.LOGGER.info("Player " + ((NetworkEvent.Context)ctx.get()).getSender().m_7755_() + " tried to use MoC instaspawner, but the allowInstaSpawn setting is set to " + MoCreatures.proxy.allowInstaSpawn);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return String.format("MoCMessageInstaSpawn - entityId:%s, numberToSpawn:%s", this.entityId, this.numberToSpawn);
    }
}

