/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.message;

import drzhark.mocreatures.entity.hostile.MoCEntityGolem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MoCMessageTwoBytes {
    public int entityId;
    public byte slot;
    public byte value;

    public MoCMessageTwoBytes() {
    }

    public MoCMessageTwoBytes(int entityId, byte slot, byte value) {
        this.entityId = entityId;
        this.slot = slot;
        this.value = value;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeByte((int)this.slot);
        buffer.writeByte((int)this.value);
    }

    public MoCMessageTwoBytes(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.slot = buffer.readByte();
        this.value = buffer.readByte();
    }

    public static void onMessage(MoCMessageTwoBytes message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity ent;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && (ent = minecraft.f_91073_.m_6815_(message.entityId)) instanceof MoCEntityGolem) {
                ((MoCEntityGolem)ent).saveGolemCube(message.slot, message.value);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return String.format("MoCMessageTwoBytes - entityId:%s, slot:%s, value:%s", this.entityId, this.slot, this.value);
    }
}

