/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.message;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MoCMessageUpdatePetName {
    public String name;
    public int entityId;

    public MoCMessageUpdatePetName(int entityId, String name) {
        this.entityId = entityId;
        this.name = name;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        buffer.writeInt(this.entityId);
    }

    public MoCMessageUpdatePetName(FriendlyByteBuf buffer) {
        this.name = buffer.readCharSequence(buffer.readInt(), StandardCharsets.UTF_8).toString();
        this.entityId = buffer.readInt();
    }

    public static void onMessage(MoCMessageUpdatePetName message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && sender.m_9236_() != null) {
                MoCPetData petData;
                Entity pet = null;
                UUID ownerUniqueId = null;
                Entity entity = sender.m_9236_().m_6815_(message.entityId);
                if (entity != null && entity.m_19879_() == message.entityId && entity instanceof IMoCTameable) {
                    ((IMoCEntity)entity).setPetName(message.name);
                    ownerUniqueId = ((IMoCEntity)entity).getOwnerId();
                    pet = entity;
                }
                if (ownerUniqueId != null && (petData = MoCreatures.instance.mapData.getPetData(ownerUniqueId)) != null && pet != null && ((IMoCTameable)pet).getOwnerPetId() != -1) {
                    int id = ((IMoCTameable)pet).getOwnerPetId();
                    ListTag tag = petData.getOwnerRootNBT().m_128437_("TamedList", 10);
                    for (int i = 0; i < tag.size(); ++i) {
                        CompoundTag nbt = tag.m_128728_(i);
                        if (nbt.m_128451_("PetId") != id) continue;
                        nbt.m_128359_("Name", message.name);
                        ((IMoCTameable)pet).setPetName(message.name);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return String.format("MoCMessageUpdatePetName - entityId:%s, name:%s", this.entityId, this.name);
    }
}

