/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.proxy;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.config.MoCConfigCategory;
import drzhark.mocreatures.config.MoCConfiguration;
import drzhark.mocreatures.config.MoCProperty;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.entity.hostile.MoCEntityGolem;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.init.MoCEntities;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.fml.loading.FMLPaths;

public class MoCProxy {
    protected static final String CATEGORY_MOC_GENERAL_SETTINGS = "global-settings";
    protected static final String CATEGORY_MOC_CREATURE_GENERAL_SETTINGS = "creature-general-settings";
    protected static final String CATEGORY_MOC_MONSTER_GENERAL_SETTINGS = "monster-general-settings";
    protected static final String CATEGORY_MOC_WATER_CREATURE_GENERAL_SETTINGS = "water-mob-general-settings";
    protected static final String CATEGORY_MOC_AMBIENT_GENERAL_SETTINGS = "ambient-general-settings";
    protected static final String CATEGORY_MOC_ID_SETTINGS = "custom-id-settings";
    private static final String CATEGORY_OWNERSHIP_SETTINGS = "ownership-settings";
    public static String ARMOR_TEXTURE = "textures/armor/";
    public static String BLOCK_TEXTURE = "textures/blocks/";
    public static String ITEM_TEXTURE = "textures/items/";
    public static String MODEL_TEXTURE = "textures/models/";
    public static String GUI_TEXTURE = "textures/gui/";
    public static String MISC_TEXTURE = "textures/misc/";
    public boolean allowInstaSpawn;
    public boolean alphaWraithEyes;
    public boolean alwaysNamePets;
    public boolean animateTextures;
    public boolean armorSetEffects;
    public boolean attackHorses;
    public boolean attackWolves;
    public boolean debug;
    public boolean destroyDrops;
    public boolean displayPetHealth;
    public boolean displayPetIcons;
    public boolean displayPetName;
    public boolean easterEggs;
    public boolean easyHorseBreeding;
    public boolean elephantBulldozer;
    public boolean enableHunters;
    public boolean enableOwnership;
    public boolean enableResetOwnership;
    public boolean foggyWyvernLair;
    public boolean golemDestroyBlocks;
    public boolean legacyBigCatModels;
    public boolean legacyBunnyTextures;
    public boolean legacyRatDeathSound;
    public boolean legacyWerehumanSounds;
    public boolean legacyWraithSounds;
    public boolean legacyWyvernLairSky;
    public boolean staticBed;
    public boolean staticLitter;
    public boolean verboseEntityNames;
    public boolean weaponEffects;
    public boolean worldInitDone;
    public double spawnMultiplier;
    public float ogreCaveStrength;
    public float ogreFireStrength;
    public float ogreStrength;
    public int filchLizardSpawnItemChance;
    public int kittyVillageChance;
    public int maxOPTamed;
    public int maxTamed;
    public int motherWyvernEggDropChance;
    public int ostrichEggDropChance;
    public int particleFX;
    public int rareItemDropChance;
    public ResourceKey<Level> wyvernDimension;
    public int wyvernEggDropChance;
    public short ogreAttackRange;
    public MoCConfiguration mocSettingsConfig;
    public MoCConfiguration mocEntityConfig;

    public void resetAllData() {
        this.readGlobalConfigValues();
    }

    public void configInit() {
        this.mocSettingsConfig = new MoCConfiguration(new File(FMLPaths.CONFIGDIR.get().toString(), "MoCreatures" + File.separator + "MoCSettings.cfg"));
        this.mocSettingsConfig.load();
        this.readGlobalConfigValues();
        if (this.debug) {
            MoCreatures.LOGGER.info("Initializing MoCreatures Config File at " + FMLPaths.CONFIGDIR.get().toString() + "MoCSettings.cfg");
        }
    }

    public void UndeadFX(Entity entity) {
    }

    public void StarFX(MoCEntityHorse moCEntityHorse) {
    }

    public void LavaFX(Entity entity) {
    }

    public void VanishFX(MoCEntityHorse entity) {
    }

    public void MaterializeFX(MoCEntityHorse entity) {
    }

    public void VacuumFX(MoCEntityGolem entity) {
    }

    public void hammerFX(Player entityplayer) {
    }

    public void teleportFX(Player entity) {
    }

    public boolean getAnimateTextures() {
        return false;
    }

    public boolean getDisplayPetName() {
        return this.displayPetName;
    }

    public boolean getDisplayPetIcons() {
        return this.displayPetIcons;
    }

    public boolean getDisplayPetHealth() {
        return this.displayPetHealth;
    }

    public int getParticleFX() {
        return 0;
    }

    public ResourceLocation getArmorTexture(String texture) {
        return null;
    }

    public ResourceLocation getBlockTexture(String texture) {
        return null;
    }

    public ResourceLocation getItemTexture(String texture) {
        return null;
    }

    public ResourceLocation getModelTexture(String texture) {
        return null;
    }

    public ResourceLocation getGuiTexture(String texture) {
        return null;
    }

    public ResourceLocation getMiscTexture(String texture) {
        return null;
    }

    public Player getPlayer() {
        return null;
    }

    public void printMessageToPlayer(String msg) {
    }

    public List<TagKey<Biome>> parseBiomeTypes(String[] biomeNames) {
        ArrayList<TagKey<Biome>> biomeTypes = new ArrayList<TagKey<Biome>>();
        for (String biomeName : biomeNames) {
            if (biomeName == null || biomeName.trim().isEmpty()) continue;
            try {
                Object cleanBiomeName = biomeName.trim();
                if (((String)cleanBiomeName).startsWith("TagKey") && !((String)cleanBiomeName).startsWith("TagKey[")) {
                    int lastSlash;
                    if (((String)cleanBiomeName).contains("/minecraft:")) {
                        int lastSlash2 = ((String)cleanBiomeName).lastIndexOf("/");
                        if (lastSlash2 != -1 && lastSlash2 < ((String)cleanBiomeName).length() - 1) {
                            cleanBiomeName = ((String)cleanBiomeName).substring(lastSlash2 + 1);
                        }
                    } else if (((String)cleanBiomeName).contains("/forge:") && (lastSlash = ((String)cleanBiomeName).lastIndexOf("/")) != -1 && lastSlash < ((String)cleanBiomeName).length() - 1) {
                        cleanBiomeName = ((String)cleanBiomeName).substring(lastSlash + 1);
                    }
                } else if (((String)cleanBiomeName).startsWith("TagKey[") && ((String)cleanBiomeName).endsWith("]")) {
                    String inner = ((String)cleanBiomeName).substring(7, ((String)cleanBiomeName).length() - 1);
                    String[] parts = inner.split(" / ");
                    cleanBiomeName = parts.length >= 2 ? parts[1] : inner;
                }
                if (!((String)cleanBiomeName).contains(":")) {
                    cleanBiomeName = "minecraft:" + (String)cleanBiomeName;
                }
                TagKey biomeTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation((String)cleanBiomeName));
                biomeTypes.add((TagKey<Biome>)biomeTag);
                if (!MoCreatures.isDebug()) continue;
                MoCreatures.LOGGER.debug("Successfully parsed biome tag: {} -> {}", (Object)biomeName, cleanBiomeName);
            }
            catch (Exception e) {
                MoCreatures.LOGGER.warn("Failed to parse biome tag '{}': {}", (Object)biomeName, (Object)e.getMessage());
                try {
                    String fallback = biomeName.replaceAll("[^a-z0-9_/:-]", "").toLowerCase();
                    if (!fallback.contains(":") || !ResourceLocation.m_135830_((String)fallback)) continue;
                    TagKey biomeTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(fallback));
                    biomeTypes.add((TagKey<Biome>)biomeTag);
                    MoCreatures.LOGGER.info("Using fallback biome tag: {} -> {}", (Object)biomeName, (Object)fallback);
                }
                catch (Exception fallbackException) {
                    MoCreatures.LOGGER.error("Complete failure parsing biome tag: {}", (Object)biomeName);
                }
            }
        }
        return biomeTypes;
    }

    private String[] parseConfigArray(String rawValue) {
        if (rawValue == null || rawValue.trim().isEmpty()) {
            return new String[0];
        }
        String trimmed = rawValue.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
        }
        ArrayList<String> result = new ArrayList<String>();
        int depth = 0;
        int start = 0;
        for (int i = 0; i < trimmed.length(); ++i) {
            char c = trimmed.charAt(i);
            if (c == '[') {
                ++depth;
                continue;
            }
            if (c == ']') {
                --depth;
                continue;
            }
            if (c != ',' || depth != 0) continue;
            result.add(trimmed.substring(start, i).trim());
            start = i + 1;
        }
        if (start < trimmed.length()) {
            result.add(trimmed.substring(start).trim());
        }
        return result.toArray(new String[0]);
    }

    public void initializeMocEntityMap() {
        if (MoCreatures.mocEntityMap == null) {
            MoCreatures.mocEntityMap = new Object2ObjectLinkedOpenHashMap();
        }
        if (MoCreatures.entityMap == null) {
            MoCreatures.entityMap = new Object2ObjectOpenHashMap();
        }
        MoCreatures.mocEntityMap.clear();
        MoCreatures.entityMap.clear();
        this.populateEntityMapWithDefaults();
        MoCreatures.LOGGER.info("Initialized {} entities in mocEntityMap", (Object)MoCreatures.mocEntityMap.size());
        MoCreatures.LOGGER.info("Initialized {} entities in entityMap", (Object)MoCreatures.entityMap.size());
        if (!MoCreatures.mocEntityMap.isEmpty()) {
            MoCEntityData sampleData = (MoCEntityData)MoCreatures.mocEntityMap.values().iterator().next();
            MoCreatures.LOGGER.info("Sample entity data - Name: {}, CanSpawn: {}, Frequency: {}, MinSpawn: {}, MaxSpawn: {}", (Object)sampleData.getEntityName(), (Object)sampleData.getCanSpawn(), (Object)sampleData.getFrequency(), (Object)sampleData.getMinSpawn(), (Object)sampleData.getMaxSpawn());
        }
    }

    private void populateEntityMapWithDefaults() {
        ResourceKey[] overworldDimensions = new ResourceKey[]{Level.f_46428_};
        ResourceKey[] netherDimensions = new ResourceKey[]{Level.f_46429_};
        ResourceKey[] wyvernDimensions = new ResourceKey[]{this.wyvernDimension};
        Function<String, TagKey> createBiomeTag = tagName -> {
            try {
                return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(tagName));
            }
            catch (Exception e) {
                MoCreatures.LOGGER.warn("Failed to create biome tag: {}", tagName);
                return null;
            }
        };
        this.addEntityData("BlackBear", (EntityType<?>)((EntityType)MoCEntities.BLACK_BEAR.get()), MobCategory.CREATURE, 8, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_coniferous")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("GrizzlyBear", (EntityType<?>)((EntityType)MoCEntities.GRIZZLY_BEAR.get()), MobCategory.CREATURE, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("PolarBear", (EntityType<?>)((EntityType)MoCEntities.POLAR_BEAR.get()), MobCategory.CREATURE, 8, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_snowy")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("PandaBear", (EntityType<?>)((EntityType)MoCEntities.PANDA_BEAR.get()), MobCategory.CREATURE, 7, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Bird", (EntityType<?>)((EntityType)MoCEntities.BIRD.get()), MobCategory.CREATURE, 16, 2, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("forge:is_steep")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Duck", (EntityType<?>)((EntityType)MoCEntities.DUCK.get()), MobCategory.CREATURE, 12, 2, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_river"), createBiomeTag.apply("forge:is_lush")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Turkey", (EntityType<?>)((EntityType)MoCEntities.TURKEY.get()), MobCategory.CREATURE, 12, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Boar", (EntityType<?>)((EntityType)MoCEntities.BOAR.get()), MobCategory.CREATURE, 12, 2, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Bunny", (EntityType<?>)((EntityType)MoCEntities.BUNNY.get()), MobCategory.CREATURE, 12, 2, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_snowy"), createBiomeTag.apply("forge:is_coniferous"), createBiomeTag.apply("forge:is_steep"), createBiomeTag.apply("mocreatures:is_wyvern_lair")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Deer", (EntityType<?>)((EntityType)MoCEntities.DEER.get()), MobCategory.CREATURE, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_coniferous")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Goat", (EntityType<?>)((EntityType)MoCEntities.GOAT.get()), MobCategory.CREATURE, 12, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_steep")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Kitty", (EntityType<?>)((EntityType)MoCEntities.KITTY.get()), MobCategory.CREATURE, 8, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_forest")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Crocodile", (EntityType<?>)((EntityType)MoCEntities.CROCODILE.get()), MobCategory.CREATURE, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Turtle", (EntityType<?>)((EntityType)MoCEntities.TURTLE.get()), MobCategory.CREATURE, 12, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_river")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Elephant", (EntityType<?>)((EntityType)MoCEntities.ELEPHANT.get()), MobCategory.CREATURE, 6, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("minecraft:is_savanna"), createBiomeTag.apply("forge:is_snowy")}, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_badlands")});
        this.addEntityData("FilchLizard", (EntityType<?>)((EntityType)MoCEntities.FILCH_LIZARD.get()), MobCategory.CREATURE, 6, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_savanna"), createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("mocreatures:is_wyvern_lair")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Ostrich", (EntityType<?>)((EntityType)MoCEntities.OSTRICH.get()), MobCategory.CREATURE, 7, 1, 1, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_savanna"), createBiomeTag.apply("forge:is_sandy")}, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_badlands")});
        this.addEntityData("Fox", (EntityType<?>)((EntityType)MoCEntities.FOX.get()), MobCategory.CREATURE, 10, 1, 1, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_snowy"), createBiomeTag.apply("forge:is_coniferous")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("KomodoDragon", (EntityType<?>)((EntityType)MoCEntities.KOMODO_DRAGON.get()), MobCategory.CREATURE, 12, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_savanna")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Snake", (EntityType<?>)((EntityType)MoCEntities.SNAKE.get()), MobCategory.CREATURE, 14, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_steep"), createBiomeTag.apply("mocreatures:is_wyvern_lair")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Leopard", (EntityType<?>)((EntityType)MoCEntities.LEOPARD.get()), MobCategory.CREATURE, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_snowy"), createBiomeTag.apply("minecraft:is_savanna")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Lion", (EntityType<?>)((EntityType)MoCEntities.LION.get()), MobCategory.CREATURE, 8, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_savanna"), createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("minecraft:is_badlands")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Panther", (EntityType<?>)((EntityType)MoCEntities.PANTHER.get()), MobCategory.CREATURE, 6, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Tiger", (EntityType<?>)((EntityType)MoCEntities.TIGER.get()), MobCategory.CREATURE, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Liger", (EntityType<?>)((EntityType)MoCEntities.LIGER.get()), MobCategory.CREATURE, 8, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("minecraft:is_savanna")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Lither", (EntityType<?>)((EntityType)MoCEntities.LITHER.get()), MobCategory.CREATURE, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Panthger", (EntityType<?>)((EntityType)MoCEntities.PANTHGER.get()), MobCategory.CREATURE, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Panthard", (EntityType<?>)((EntityType)MoCEntities.PANTHARD.get()), MobCategory.CREATURE, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Leoger", (EntityType<?>)((EntityType)MoCEntities.LEOGER.get()), MobCategory.CREATURE, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("minecraft:is_savanna")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Mouse", (EntityType<?>)((EntityType)MoCEntities.MOUSE.get()), MobCategory.CREATURE, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_steep")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Mole", (EntityType<?>)((EntityType)MoCEntities.MOLE.get()), MobCategory.CREATURE, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("forge:is_plains")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Raccoon", (EntityType<?>)((EntityType)MoCEntities.RACCOON.get()), MobCategory.CREATURE, 12, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("WildHorse", (EntityType<?>)((EntityType)MoCEntities.WILDHORSE.get()), MobCategory.CREATURE, 12, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_savanna")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Ent", (EntityType<?>)((EntityType)MoCEntities.ENT.get()), MobCategory.CREATURE, 5, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Wyvern", (EntityType<?>)((EntityType)MoCEntities.WYVERN.get()), MobCategory.CREATURE, 12, 1, 3, (ResourceKey<Level>[])wyvernDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("mocreatures:is_wyvern_lair")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("GreenOgre", (EntityType<?>)((EntityType)MoCEntities.GREEN_OGRE.get()), MobCategory.MONSTER, 8, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("CaveOgre", (EntityType<?>)((EntityType)MoCEntities.CAVE_OGRE.get()), MobCategory.MONSTER, 5, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_mountain")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("FireOgre", (EntityType<?>)((EntityType)MoCEntities.FIRE_OGRE.get()), MobCategory.MONSTER, 6, 1, 2, (ResourceKey<Level>[])netherDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_nether")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("CaveScorpion", (EntityType<?>)((EntityType)MoCEntities.CAVE_SCORPION.get()), MobCategory.MONSTER, 4, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_mountain"), createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("forge:is_snowy"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_dry"), createBiomeTag.apply("forge:is_hot"), createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("DirtScorpion", (EntityType<?>)((EntityType)MoCEntities.DIRT_SCORPION.get()), MobCategory.MONSTER, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_dry"), createBiomeTag.apply("forge:is_hot")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("FireScorpion", (EntityType<?>)((EntityType)MoCEntities.FIRE_SCORPION.get()), MobCategory.MONSTER, 6, 1, 3, (ResourceKey<Level>[])netherDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_nether")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("FrostScorpion", (EntityType<?>)((EntityType)MoCEntities.FROST_SCORPION.get()), MobCategory.MONSTER, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_snowy")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("UndeadScorpion", (EntityType<?>)((EntityType)MoCEntities.UNDEAD_SCORPION.get()), MobCategory.MONSTER, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("BigGolem", (EntityType<?>)((EntityType)MoCEntities.BIG_GOLEM.get()), MobCategory.MONSTER, 3, 1, 1, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("forge:is_hill"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_mountain"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_dead")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("MiniGolem", (EntityType<?>)((EntityType)MoCEntities.MINI_GOLEM.get()), MobCategory.MONSTER, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_mountain"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_dead")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("DarkManticore", (EntityType<?>)((EntityType)MoCEntities.DARK_MANTICORE.get()), MobCategory.MONSTER, 5, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("forge:is_mountain"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_snowy"), createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("FireManticore", (EntityType<?>)((EntityType)MoCEntities.FIRE_MANTICORE.get()), MobCategory.MONSTER, 8, 1, 3, (ResourceKey<Level>[])netherDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_nether")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("FrostManticore", (EntityType<?>)((EntityType)MoCEntities.FROST_MANTICORE.get()), MobCategory.MONSTER, 8, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_snowy")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("PlainManticore", (EntityType<?>)((EntityType)MoCEntities.PLAIN_MANTICORE.get()), MobCategory.MONSTER, 8, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("forge:is_mountain"), createBiomeTag.apply("forge:is_plains")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("ToxicManticore", (EntityType<?>)((EntityType)MoCEntities.TOXIC_MANTICORE.get()), MobCategory.MONSTER, 8, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Werewolf", (EntityType<?>)((EntityType)MoCEntities.WEREWOLF.get()), MobCategory.MONSTER, 8, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_coniferous"), createBiomeTag.apply("minecraft:is_forest")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("WWolf", (EntityType<?>)((EntityType)MoCEntities.WWOLF.get()), MobCategory.MONSTER, 8, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_snowy"), createBiomeTag.apply("forge:is_dead")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Rat", (EntityType<?>)((EntityType)MoCEntities.RAT.get()), MobCategory.MONSTER, 7, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_steep")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("HellRat", (EntityType<?>)((EntityType)MoCEntities.HELL_RAT.get()), MobCategory.MONSTER, 6, 1, 4, (ResourceKey<Level>[])netherDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_nether")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("SilverSkeleton", (EntityType<?>)((EntityType)MoCEntities.SILVER_SKELETON.get()), MobCategory.MONSTER, 6, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_sandy"), createBiomeTag.apply("forge:is_snowy"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Wraith", (EntityType<?>)((EntityType)MoCEntities.WRAITH.get()), MobCategory.MONSTER, 6, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_coniferous"), createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_dense"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("FlameWraith", (EntityType<?>)((EntityType)MoCEntities.FLAME_WRAITH.get()), MobCategory.MONSTER, 5, 1, 2, (ResourceKey<Level>[])netherDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_nether")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("HorseMob", (EntityType<?>)((EntityType)MoCEntities.HORSE_MOB.get()), MobCategory.MONSTER, 8, 1, 3, (ResourceKey<Level>[])netherDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_nether"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_savanna"), createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Dolphin", (EntityType<?>)((EntityType)MoCEntities.DOLPHIN.get()), MobCategory.WATER_CREATURE, 6, 2, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Shark", (EntityType<?>)((EntityType)MoCEntities.SHARK.get()), MobCategory.WATER_CREATURE, 6, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("MantaRay", (EntityType<?>)((EntityType)MoCEntities.MANTA_RAY.get()), MobCategory.WATER_CREATURE, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("JellyFish", (EntityType<?>)((EntityType)MoCEntities.JELLYFISH.get()), MobCategory.WATER_CREATURE, 8, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Bass", (EntityType<?>)((EntityType)MoCEntities.BASS.get()), MobCategory.WATER_CREATURE, 10, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_river"), createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("StingRay", (EntityType<?>)((EntityType)MoCEntities.STING_RAY.get()), MobCategory.WATER_CREATURE, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_river")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Anchovy", (EntityType<?>)((EntityType)MoCEntities.ANCHOVY.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("minecraft:is_ocean"), createBiomeTag.apply("minecraft:is_river")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("AngelFish", (EntityType<?>)((EntityType)MoCEntities.ANGELFISH.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_river"), createBiomeTag.apply("minecraft:is_jungle")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Angler", (EntityType<?>)((EntityType)MoCEntities.ANGLER.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("ClownFish", (EntityType<?>)((EntityType)MoCEntities.CLOWNFISH.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("GoldFish", (EntityType<?>)((EntityType)MoCEntities.GOLDFISH.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_river")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("HippoTang", (EntityType<?>)((EntityType)MoCEntities.HIPPOTANG.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Manderin", (EntityType<?>)((EntityType)MoCEntities.MANDERIN.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Cod", (EntityType<?>)((EntityType)MoCEntities.COD.get()), MobCategory.WATER_CREATURE, 10, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("minecraft:is_ocean")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Salmon", (EntityType<?>)((EntityType)MoCEntities.SALMON.get()), MobCategory.WATER_CREATURE, 10, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("forge:is_water"), createBiomeTag.apply("minecraft:is_ocean"), createBiomeTag.apply("minecraft:is_river"), createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Piranha", (EntityType<?>)((EntityType)MoCEntities.PIRANHA.get()), MobCategory.WATER_CREATURE, 4, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_lush")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Fishy", (EntityType<?>)((EntityType)MoCEntities.FISHY.get()), MobCategory.WATER_AMBIENT, 12, 1, 6, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach"), createBiomeTag.apply("forge:is_water"), createBiomeTag.apply("minecraft:is_ocean"), createBiomeTag.apply("minecraft:is_river"), createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("forge:is_plains")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Ant", (EntityType<?>)((EntityType)MoCEntities.ANT.get()), MobCategory.AMBIENT, 12, 1, 4, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("minecraft:is_badlands"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("forge:is_hot"), createBiomeTag.apply("forge:is_dry"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("forge:is_sparse"), createBiomeTag.apply("forge:is_steep")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Bee", (EntityType<?>)((EntityType)MoCEntities.BEE.get()), MobCategory.AMBIENT, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("minecraft:is_savanna")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Butterfly", (EntityType<?>)((EntityType)MoCEntities.BUTTERFLY.get()), MobCategory.AMBIENT, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("minecraft:is_savanna")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Cricket", (EntityType<?>)((EntityType)MoCEntities.CRICKET.get()), MobCategory.AMBIENT, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("forge:is_swamp")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Dragonfly", (EntityType<?>)((EntityType)MoCEntities.DRAGONFLY.get()), MobCategory.AMBIENT, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("mocreatures:is_wyvern_lair")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Firefly", (EntityType<?>)((EntityType)MoCEntities.FIREFLY.get()), MobCategory.AMBIENT, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_lush"), createBiomeTag.apply("mocreatures:is_wyvern_lair")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Fly", (EntityType<?>)((EntityType)MoCEntities.FLY.get()), MobCategory.AMBIENT, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_forest")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Grasshopper", (EntityType<?>)((EntityType)MoCEntities.GRASSHOPPER.get()), MobCategory.AMBIENT, 10, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_forest"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_plains"), createBiomeTag.apply("minecraft:is_savanna"), createBiomeTag.apply("mocreatures:is_wyvern_lair")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Maggot", (EntityType<?>)((EntityType)MoCEntities.MAGGOT.get()), MobCategory.AMBIENT, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Roach", (EntityType<?>)((EntityType)MoCEntities.ROACH.get()), MobCategory.AMBIENT, 6, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_dead"), createBiomeTag.apply("forge:is_spooky"), createBiomeTag.apply("forge:is_hot")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Crab", (EntityType<?>)((EntityType)MoCEntities.CRAB.get()), MobCategory.AMBIENT, 6, 1, 2, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("minecraft:is_beach")}, (TagKey<Biome>[])new TagKey[0]);
        this.addEntityData("Snail", (EntityType<?>)((EntityType)MoCEntities.SNAIL.get()), MobCategory.AMBIENT, 8, 1, 3, (ResourceKey<Level>[])overworldDimensions, (TagKey<Biome>[])new TagKey[]{createBiomeTag.apply("forge:is_swamp"), createBiomeTag.apply("minecraft:is_jungle"), createBiomeTag.apply("forge:is_lush")}, (TagKey<Biome>[])new TagKey[0]);
    }

    private void addEntityData(String name, EntityType<?> entityType, MobCategory category, int weight, int minCount, int maxCount, ResourceKey<Level>[] dimensions, TagKey<Biome> ... biomeTags) {
        this.addEntityData(name, entityType, category, weight, minCount, maxCount, dimensions, biomeTags, (TagKey<Biome>[])new TagKey[0]);
    }

    private void addEntityData(String name, EntityType<?> entityType, MobCategory category, int weight, int minCount, int maxCount, ResourceKey<Level>[] dimensions, TagKey<Biome>[] biomeTags, TagKey<Biome>[] blockedBiomeTags) {
        ArrayList<TagKey<Biome>> validBiomeTags = new ArrayList<TagKey<Biome>>();
        for (TagKey<Biome> tag : biomeTags) {
            if (tag == null) continue;
            validBiomeTags.add(tag);
        }
        ArrayList<TagKey<Biome>> validBlockedBiomeTags = new ArrayList<TagKey<Biome>>();
        for (TagKey<Biome> tag : blockedBiomeTags) {
            if (tag == null) continue;
            validBlockedBiomeTags.add(tag);
        }
        MobSpawnSettings.SpawnerData spawnerData = new MobSpawnSettings.SpawnerData(entityType, weight, minCount, maxCount);
        MoCEntityData entityData = new MoCEntityData(name, 4, dimensions, category, spawnerData, validBiomeTags);
        entityData.setBlockedBiomeTags(validBlockedBiomeTags);
        MoCreatures.mocEntityMap.put((Object)name, (Object)entityData);
        MoCreatures.entityMap.put(entityType, (Object)entityData);
    }

    public void readMocConfigValues() {
        if (MoCreatures.mocEntityMap == null || MoCreatures.mocEntityMap.isEmpty()) {
            this.initializeMocEntityMap();
        }
        if (MoCreatures.mocEntityMap != null && !MoCreatures.mocEntityMap.isEmpty()) {
            for (MoCEntityData entityData : MoCreatures.mocEntityMap.values()) {
                String[] biomeStrings;
                String rawValue;
                MoCConfigCategory cat = this.mocEntityConfig.getCategory(entityData.getEntityName().toLowerCase());
                if (!cat.containsKey("biomeTypes")) {
                    cat.put("biomeTypes", new MoCProperty("biomeTypes", Arrays.toString(entityData.getBiomeTags().toArray()), MoCProperty.Type.STRING));
                } else {
                    rawValue = cat.get((String)"biomeTypes").value;
                    biomeStrings = this.parseConfigArray(rawValue);
                    entityData.setBiomeTags(this.parseBiomeTypes(biomeStrings));
                }
                if (!cat.containsKey("blockedBiomeTypes")) {
                    cat.put("blockedBiomeTypes", new MoCProperty("blockedBiomeTypes", Arrays.toString(entityData.getBlockedBiomeTags().toArray()), MoCProperty.Type.STRING));
                } else {
                    rawValue = cat.get((String)"blockedBiomeTypes").value;
                    biomeStrings = this.parseConfigArray(rawValue);
                    entityData.setBlockedBiomeTags(this.parseBiomeTypes(biomeStrings));
                }
                if (!cat.containsKey("canSpawn")) {
                    cat.put("canSpawn", new MoCProperty("canSpawn", Boolean.toString(entityData.getCanSpawn()), MoCProperty.Type.STRING));
                } else {
                    entityData.setCanSpawn(Boolean.parseBoolean(cat.get((String)"canSpawn").value));
                }
                if (!cat.containsKey("frequency")) {
                    cat.put("frequency", new MoCProperty("frequency", Integer.toString(entityData.getFrequency()), MoCProperty.Type.INTEGER));
                } else {
                    entityData.setFrequency(Integer.parseInt(cat.get((String)"frequency").value));
                }
                if (!cat.containsKey("maxSpawn")) {
                    cat.put("maxSpawn", new MoCProperty("maxSpawn", Integer.toString(entityData.getMaxSpawn()), MoCProperty.Type.INTEGER));
                } else {
                    entityData.setMaxSpawn(Integer.parseInt(cat.get((String)"maxSpawn").value));
                }
                if (!cat.containsKey("minSpawn")) {
                    cat.put("minSpawn", new MoCProperty("minSpawn", Integer.toString(entityData.getMinSpawn()), MoCProperty.Type.INTEGER));
                    continue;
                }
                entityData.setMinSpawn(Integer.parseInt(cat.get((String)"minSpawn").value));
            }
        }
        this.mocEntityConfig.save();
    }

    public void readGlobalConfigValues() {
        this.animateTextures = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "AnimateTextures", true, "Enables animated textures.").getBoolean(true);
        this.displayPetHealth = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "DisplayPetHealth", true, "Shows the health of pets.").getBoolean(true);
        this.displayPetIcons = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "DisplayPetIcons", true, "Shows the emotes of pets.").getBoolean(true);
        this.displayPetName = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "DisplayPetName", true, "Shows the name of pets.").getBoolean(true);
        this.alphaWraithEyes = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "AlphaWraithEyes", false, "Enables different eye colors for wraiths and flame wraiths like in alpha versions.").getBoolean(false);
        this.alwaysNamePets = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "AlwaysNamePets", true, "Displays a GUI to name a pet when taming.").getBoolean(true);
        this.armorSetEffects = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "ArmorSetEffects", true, "Applies potion effects when wearing full scorpion armor sets.").getBoolean(true);
        this.attackHorses = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "AttackHorses", false, "When enabled, tamed horses can be attacked.").getBoolean(false);
        this.attackWolves = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "AttackWolves", false, "When enabled, tamed wolves can be attacked.").getBoolean(false);
        this.debug = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "DebugMode", false, "When enabled, enables debugging logs.").getBoolean(false);
        this.destroyDrops = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "DestroyDrops", true, "When enabled, if tamed entities find drops, they will destroy them.").getBoolean(true);
        this.easterEggs = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "EasterEggs", false, "Spawns certain entities on Easter.").getBoolean(false);
        this.easyHorseBreeding = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "EasyHorseBreeding", false, "Makes breeding horses easier with one click.").getBoolean(false);
        this.elephantBulldozer = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "ElephantBulldozer", true, "When enabled, elephants will destroy all non-solid blocks.").getBoolean(true);
        this.enableHunters = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "EnableHunters", true, "When disabled, hunters will not attack your pets.").getBoolean(true);
        this.enableOwnership = this.mocSettingsConfig.get(CATEGORY_OWNERSHIP_SETTINGS, "EnableOwnership", true, "Enables ownership for other players.").getBoolean(true);
        this.enableResetOwnership = this.mocSettingsConfig.get(CATEGORY_OWNERSHIP_SETTINGS, "EnableResetOwnership", true, "Reset ownership when loading animal from chunk.").getBoolean(true);
        this.filchLizardSpawnItemChance = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "FilchLizardSpawnItemChance", 50, "Percentage chance of a filch lizard to steal a dropped item.").getInt(50);
        this.foggyWyvernLair = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "FoggyWyvernLair", true, "Enables fog in the Wyvern Lair dimension.").getBoolean(true);
        this.golemDestroyBlocks = this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "GolemDestroyBlocks", true, "When enabled, golems will destroy blocks.").getBoolean(true);
        this.kittyVillageChance = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "KittyVillageChance", 25, "Percentage chance of a kitty to spawn in a village.").getInt(25);
        this.legacyBigCatModels = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "LegacyBigCatModels", false, "Use the old big cat model when true.").getBoolean(false);
        this.legacyBunnyTextures = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "LegacyBunnyTextures", false, "Use the old bunny textures when true.").getBoolean(false);
        this.legacyRatDeathSound = this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "LegacyRatDeathSound", false, "Use the old rat death sound when true.").getBoolean(false);
        this.legacyWerehumanSounds = this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "LegacyWerehumanSounds", false, "Use the old werehuman sounds when true.").getBoolean(false);
        this.legacyWraithSounds = this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "LegacyWraithSounds", false, "Use the old wraith sounds when true.").getBoolean(false);
        this.legacyWyvernLairSky = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "LegacyWyvernLairSky", false, "Use the old wyvern lair sky when true.").getBoolean(false);
        this.maxOPTamed = this.mocSettingsConfig.get(CATEGORY_OWNERSHIP_SETTINGS, "MaxOPTamed", 15, "Max amount of pets an OP player can own.").getInt(15);
        this.maxTamed = this.mocSettingsConfig.get(CATEGORY_OWNERSHIP_SETTINGS, "MaxTamed", 10, "Max amount of pets a player can own.").getInt(10);
        this.motherWyvernEggDropChance = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "MotherWyvernEggDropChance", 10, "Percentage chance of a mother wyvern to drop an egg when killed.").getInt(10);
        this.ogreAttackRange = (short)this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "OgreAttackRange", 12, "Maximum block distance for ogres to destroy.").getInt(12);
        this.ogreCaveStrength = (float)this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "OgreCaveStrength", 2.5, "Strength value for cave ogres.").getDouble(2.5);
        this.ogreFireStrength = (float)this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "OgreFireStrength", 3.0, "Strength value for fire ogres.").getDouble(3.0);
        this.ogreStrength = (float)this.mocSettingsConfig.get(CATEGORY_MOC_MONSTER_GENERAL_SETTINGS, "OgreStrength", 2.0, "Strength value for ogres.").getDouble(2.0);
        this.ostrichEggDropChance = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "OstrichEggDropChance", 10, "Percentage chance of a ostrich to drop an egg when killed.").getInt(10);
        this.particleFX = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "ParticleFX", 3, "Particle FX. 0 = off, 1 = minimal, 2 = normal, 3 = maximal.").getInt(3);
        this.rareItemDropChance = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "RareItemDropChance", 25, "Percentage chance of dropping a rare item.").getInt(25);
        this.spawnMultiplier = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "SpawnMultiplier", 1.0, "Multiplier for spawn frequency.").getDouble(1.0);
        MoCreatures.LOGGER.info("Spawn multiplier set to: {}", (Object)this.spawnMultiplier);
        this.staticBed = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "StaticBed", false, "When enabled, kitty beds cannot be pushed.").getBoolean(false);
        this.staticLitter = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "StaticLitter", false, "When enabled, litter boxes cannot be pushed.").getBoolean(false);
        this.verboseEntityNames = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "VerboseEntityNames", false, "Enables displaying a verbose name of type on pets.").getBoolean(false);
        this.weaponEffects = this.mocSettingsConfig.get(CATEGORY_MOC_GENERAL_SETTINGS, "WeaponEffects", true, "Applies weapon effects when attacking with silver weapons.").getBoolean(true);
        this.wyvernEggDropChance = this.mocSettingsConfig.get(CATEGORY_MOC_CREATURE_GENERAL_SETTINGS, "WyvernEggDropChance", 5, "Percentage chance of a wyvern to drop an egg when killed.").getInt(5);
        this.wyvernDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("mocreatures:wyvernlair"));
        this.allowInstaSpawn = this.mocSettingsConfig.get(CATEGORY_MOC_ID_SETTINGS, "AllowInstaSpawn", false, "Used for debugging purposes.").getBoolean(false);
        if (this.debug) {
            MoCreatures.LOGGER.info("Settings loaded.");
        }
        this.mocSettingsConfig.save();
    }

    public void registerRenderers() {
    }

    public void registerRenderInformation() {
    }

    public int getProxyMode() {
        return 0;
    }

    public void setName(Player player, IMoCEntity mocanimal) {
    }
}

