/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.proxy;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.client.gui.MoCGUIEntityNamer;
import drzhark.mocreatures.client.renderer.fx.MoCParticles;
import drzhark.mocreatures.client.renderer.fx.data.StarParticleData;
import drzhark.mocreatures.client.renderer.fx.data.VacuumParticleData;
import drzhark.mocreatures.client.renderer.fx.data.VanishParticleData;
import drzhark.mocreatures.client.renderer.texture.MoCTextures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.hostile.MoCEntityGolem;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.proxy.MoCProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="mocreatures", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MoCProxyClient
extends MoCProxy {
    public static Minecraft mc = Minecraft.m_91087_();
    public static MoCProxyClient instance;
    public static MoCTextures mocTextures;

    public MoCProxyClient() {
        instance = this;
    }

    @Override
    public void registerRenderers() {
        super.registerRenderers();
    }

    @Override
    public ResourceLocation getArmorTexture(String texture) {
        return mocTextures.getArmorTexture(texture);
    }

    @Override
    public ResourceLocation getBlockTexture(String texture) {
        return mocTextures.getBlockTexture(texture);
    }

    @Override
    public ResourceLocation getItemTexture(String texture) {
        return mocTextures.getItemTexture(texture);
    }

    @Override
    public ResourceLocation getModelTexture(String texture) {
        return mocTextures.getModelTexture(texture);
    }

    @Override
    public ResourceLocation getGuiTexture(String texture) {
        return mocTextures.getGuiTexture(texture);
    }

    @Override
    public ResourceLocation getMiscTexture(String texture) {
        return mocTextures.getMiscTexture(texture);
    }

    @Override
    public void registerRenderInformation() {
        MoCreatures.LOGGER.info("MoCreatures client setup initialized");
    }

    public void registerEntityRenderers() {
    }

    @Override
    public Player getPlayer() {
        return MoCProxyClient.mc.f_91074_;
    }

    @Override
    public void setName(Player player, IMoCEntity mocanimal) {
        mc.m_91152_((Screen)new MoCGUIEntityNamer(mocanimal, mocanimal.getPetName()));
    }

    @Override
    public void UndeadFX(Entity entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0 || !(entity.m_9236_() instanceof ClientLevel)) {
            return;
        }
        int i = densityInt / 2 * (entity.m_9236_().m_213780_().m_188503_(2) + 1);
        if (i == 0) {
            i = 1;
        }
        if (i > 10) {
            i = 10;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        for (int x = 0; x < i; ++x) {
            level.m_7106_((ParticleOptions)MoCParticles.UNDEAD_FX.get(), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() * entity.m_9236_().m_213780_().m_188501_()), entity.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void StarFX(MoCEntityHorse entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0 || !(entity.m_9236_() instanceof ClientLevel)) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        float r = entity.colorFX(1, entity.getTypeMoC());
        float g = entity.colorFX(2, entity.getTypeMoC());
        float b = entity.colorFX(3, entity.getTypeMoC());
        int count = densityInt * (level.m_213780_().m_188503_(2) + 1);
        for (int i = 0; i < count; ++i) {
            double x = entity.m_20185_();
            double y = entity.m_20186_() + (double)(level.m_213780_().m_188501_() * entity.m_20206_());
            double z = entity.m_20189_();
            level.m_7106_((ParticleOptions)new StarParticleData(r, g, b), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void LavaFX(Entity entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0) {
            return;
        }
        double var2 = entity.m_9236_().m_213780_().m_188583_() * 0.02;
        double var4 = entity.m_9236_().m_213780_().m_188583_() * 0.02;
        double var6 = entity.m_9236_().m_213780_().m_188583_() * 0.02;
        MoCProxyClient.mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, entity.m_20185_() + (double)(entity.m_9236_().m_213780_().m_188501_() * entity.m_20205_()) - (double)entity.m_20205_(), entity.m_20186_() + 0.5 + (double)(entity.m_9236_().m_213780_().m_188501_() * entity.m_20206_()), entity.m_20189_() + (double)(entity.m_9236_().m_213780_().m_188501_() * entity.m_20205_()) - (double)entity.m_20205_(), var2, var4, var6);
    }

    @Override
    public void VanishFX(MoCEntityHorse entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0 || !(entity.m_9236_() instanceof ClientLevel)) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        float r = entity.colorFX(1, entity.getTypeMoC());
        float g = entity.colorFX(2, entity.getTypeMoC());
        float b = entity.colorFX(3, entity.getTypeMoC());
        for (int i = 0; i < densityInt * 8; ++i) {
            double newPosX = entity.m_20185_() + (double)level.m_213780_().m_188501_();
            double newPosY = entity.m_20186_() + 0.7 + (double)level.m_213780_().m_188501_();
            double newPosZ = entity.m_20189_() + (double)level.m_213780_().m_188501_();
            int sign = level.m_213780_().m_188503_(2) * 2 - 1;
            double speedX = level.m_213780_().m_188501_() * 2.0f * (float)sign;
            double speedY = ((double)level.m_213780_().m_188501_() - 0.5) * 0.5;
            double speedZ = level.m_213780_().m_188501_() * 2.0f * (float)sign;
            level.m_7106_((ParticleOptions)new VanishParticleData(r, g, b, false), newPosX, newPosY, newPosZ, speedX, speedY, speedZ);
        }
    }

    @Override
    public void MaterializeFX(MoCEntityHorse entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0 || !(entity.m_9236_() instanceof ClientLevel)) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        float r = entity.colorFX(1, entity.getTypeMoC());
        float g = entity.colorFX(2, entity.getTypeMoC());
        float b = entity.colorFX(3, entity.getTypeMoC());
        for (int i = 0; i < densityInt * 50; ++i) {
            double newPosX = entity.m_20185_() + (double)level.m_213780_().m_188501_();
            double newPosY = entity.m_20186_() + 0.7 + (double)level.m_213780_().m_188501_();
            double newPosZ = entity.m_20189_() + (double)level.m_213780_().m_188501_();
            int sign = level.m_213780_().m_188503_(2) * 2 - 1;
            double speedX = level.m_213780_().m_188501_() * 2.0f * (float)sign;
            double speedY = ((double)level.m_213780_().m_188501_() - 0.5) * 0.5;
            double speedZ = level.m_213780_().m_188501_() * 2.0f * (float)sign;
            level.m_7106_((ParticleOptions)new VanishParticleData(r, g, b, false), newPosX, newPosY, newPosZ, speedX, speedY, speedZ);
        }
    }

    @Override
    public void VacuumFX(MoCEntityGolem entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0 || !(entity.m_9236_() instanceof ClientLevel)) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        float r = entity.colorFX(1);
        float g = entity.colorFX(2);
        float b = entity.colorFX(3);
        for (int i = 0; i < 2; ++i) {
            double yawRad = Math.toRadians(entity.m_146908_() - 90.0f);
            double newPosX = entity.m_20185_() - 1.5 * Math.cos(yawRad);
            double newPosZ = entity.m_20189_() - 1.5 * Math.sin(yawRad);
            double newPosY = entity.m_20186_() + ((double)entity.m_20206_() - 0.8 - (double)entity.getAdjustedYOffset() * 1.8);
            double speedX = (level.m_213780_().m_188500_() - 0.5) * 4.0;
            double speedY = -level.m_213780_().m_188500_();
            double speedZ = (level.m_213780_().m_188500_() - 0.5) * 4.0;
            level.m_7106_((ParticleOptions)new VacuumParticleData(r, g, b), newPosX, newPosY, newPosZ, speedX, speedY, speedZ);
        }
    }

    @Override
    public void hammerFX(Player entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0 || !(entity.m_9236_() instanceof ClientLevel)) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        for (int var6 = 0; var6 < densityInt * 10; ++var6) {
            double newPosX = (float)entity.m_20185_() + level.m_213780_().m_188501_();
            double newPosY = 0.3 + (double)((float)entity.m_20186_() + level.m_213780_().m_188501_());
            double newPosZ = (float)entity.m_20189_() + level.m_213780_().m_188501_();
            int var19 = level.m_213780_().m_188503_(2) * 2 - 1;
            double speedY = ((double)level.m_213780_().m_188501_() - 0.5) * 0.5;
            double speedX = level.m_213780_().m_188501_() * 2.0f * (float)var19;
            double speedZ = level.m_213780_().m_188501_() * 2.0f * (float)var19;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, newPosX, newPosY, newPosZ, speedX, speedY, speedZ);
        }
    }

    @Override
    public void teleportFX(Player entity) {
        int densityInt = MoCreatures.proxy.getParticleFX();
        if (densityInt == 0 || !(entity.m_9236_() instanceof ClientLevel)) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        for (int var6 = 0; var6 < densityInt * 50; ++var6) {
            double newPosX = (float)entity.m_20185_() + level.m_213780_().m_188501_();
            double newPosY = 0.7 + (double)((float)entity.m_20186_() + level.m_213780_().m_188501_());
            double newPosZ = (float)entity.m_20189_() + level.m_213780_().m_188501_();
            int var19 = level.m_213780_().m_188503_(2) * 2 - 1;
            double speedY = ((double)level.m_213780_().m_188501_() - 0.5) * 0.5;
            double speedX = level.m_213780_().m_188501_() * 2.0f * (float)var19;
            double speedZ = level.m_213780_().m_188501_() * 2.0f * (float)var19;
            level.m_7106_((ParticleOptions)new VanishParticleData(1.0f, 1.0f, 1.0f, false), newPosX, newPosY, newPosZ, speedX, speedY, speedZ);
        }
    }

    @Override
    public int getProxyMode() {
        return 2;
    }

    @Override
    public void resetAllData() {
        super.resetAllData();
    }

    @Override
    public int getParticleFX() {
        return this.particleFX;
    }

    @Override
    public boolean getDisplayPetName() {
        return this.displayPetName;
    }

    @Override
    public boolean getDisplayPetIcons() {
        return this.displayPetIcons;
    }

    @Override
    public boolean getDisplayPetHealth() {
        return this.displayPetHealth;
    }

    @Override
    public boolean getAnimateTextures() {
        return this.animateTextures;
    }

    @Override
    public void printMessageToPlayer(String msg) {
        if (MoCProxyClient.mc.f_91074_ != null) {
            MutableComponent chatText = Component.m_237113_((String)msg);
            MoCProxyClient.mc.f_91074_.m_213846_((Component)chatText);
        }
    }

    static {
        mocTextures = new MoCTextures();
    }
}

