/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.util;

import drzhark.mocreatures.init.MoCItems;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum MoCArmorMaterial implements ArmorMaterial
{
    CROC("croc", 10, MoCArmorMaterial.baseStats(1, 3, 4, 1), 17, SoundEvents.f_11678_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.REPTILE_HIDE.get()})),
    FUR("fur", 4, MoCArmorMaterial.baseStats(1, 2, 2, 1), 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.FUR.get()})),
    HIDE("hide", 8, MoCArmorMaterial.baseStats(1, 3, 3, 1), 18, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.ANIMALHIDE.get()})),
    SCORPD("scorpd", 18, MoCArmorMaterial.baseStats(2, 6, 7, 2), 16, SoundEvents.f_11676_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.CHITIN.get()})),
    SCORPF("scorpf", 18, MoCArmorMaterial.baseStats(2, 6, 7, 2), 16, SoundEvents.f_11676_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.CHITINFROST.get()})),
    SCORPN("scorpn", 18, MoCArmorMaterial.baseStats(2, 6, 7, 2), 16, SoundEvents.f_11676_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.CHITINNETHER.get()})),
    SCORPC("scorpc", 18, MoCArmorMaterial.baseStats(2, 6, 7, 2), 16, SoundEvents.f_11676_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.CHITINCAVE.get()})),
    SCORPU("scorpu", 18, MoCArmorMaterial.baseStats(2, 6, 7, 2), 16, SoundEvents.f_11676_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.CHITINUNDEAD.get()})),
    SILVER("silver", 15, MoCArmorMaterial.baseStats(2, 6, 5, 2), 22, SoundEvents.f_11676_, 1.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MoCItems.ANCIENTSILVERINGOT.get()}));

    private static final int[] BASE_DURABILITIES;
    private final String name;
    private final int durabilityMultiplier;
    private final Map<ArmorItem.Type, Integer> protection;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private MoCArmorMaterial(String name, int durabilityMultiplier, Map<ArmorItem.Type, Integer> protection, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protection = protection;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyLoadedValue(repairIngredient);
    }

    public int m_266425_(ArmorItem.Type type) {
        return BASE_DURABILITIES[type.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protection.getOrDefault(type, 0);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return "mocreatures:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    private static Map<ArmorItem.Type, Integer> baseStats(int boots, int leggings, int chestplate, int helmet) {
        EnumMap<ArmorItem.Type, Integer> map = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        map.put(ArmorItem.Type.BOOTS, boots);
        map.put(ArmorItem.Type.LEGGINGS, leggings);
        map.put(ArmorItem.Type.CHESTPLATE, chestplate);
        map.put(ArmorItem.Type.HELMET, helmet);
        return map;
    }

    static {
        BASE_DURABILITIES = new int[]{13, 15, 16, 11};
    }
}

