/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.world;

import com.mojang.serialization.Codec;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.world.MoCWorldRegistry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class MoCSpawnBiomeModifier
implements BiomeModifier {
    private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)new ResourceLocation("mocreatures", "moc_spawns"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"mocreatures");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            String biomeName = (String)biome.m_203439_().map(key -> key.m_135782_().toString(), obj -> "unknown");
            MoCreatures.LOGGER.debug("MoCSpawnBiomeModifier: Processing biome {} in phase {}", (Object)biomeName, (Object)phase);
            MoCWorldRegistry.addBiomeSpawns(biome, builder);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<MoCSpawnBiomeModifier> makeCodec() {
        MoCreatures.LOGGER.info("Making MoCSpawnBiomeModifier codec");
        return Codec.unit(MoCSpawnBiomeModifier::new);
    }
}

