/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.world;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.config.biome.BiomeConfig;
import drzhark.mocreatures.config.biome.BiomeSpawnConfig;
import drzhark.mocreatures.config.biome.MoCConfig;
import drzhark.mocreatures.config.biome.SpawnBiomeData;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.world.MoCSpawnRegistryCache;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="mocreatures", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoCWorldRegistry {
    public static void modifyStructure(Holder<Structure> structure, ModifiableStructureInfo.StructureInfo.Builder builder) {
        MoCEntityData kittyData;
        EntityType<?> kitty;
        if ((structure.m_203565_(BuiltinStructures.f_209865_) || structure.m_203565_(BuiltinStructures.f_209864_) || structure.m_203565_(BuiltinStructures.f_209866_) || structure.m_203565_(BuiltinStructures.f_209867_) || structure.m_203565_(BuiltinStructures.f_209868_)) && (kitty = MoCSpawnRegistryCache.ENTITIES.get("kitty")) != null && (kittyData = MoCWorldRegistry.getEntityData(kitty)) != null && kittyData.getCanSpawn() && kittyData.getFrequency() > 0) {
            int spawnWeight = Math.max(1, kittyData.getFrequency() / 4);
            builder.getStructureSettings().getOrAddSpawnOverrides(MobCategory.CREATURE).addSpawn(new MobSpawnSettings.SpawnerData(kitty, spawnWeight, 1, 3));
        }
    }

    private static MoCEntityData getEntityData(EntityType<?> entityType) {
        if (MoCreatures.entityMap == null) {
            MoCreatures.LOGGER.warn("MoCWorldRegistry: entityMap is null! Spawn system not initialized.");
            return null;
        }
        return (MoCEntityData)MoCreatures.entityMap.get(entityType);
    }

    private static ResourceLocation getBiomeName(Holder<Biome> biome) {
        return (ResourceLocation)biome.m_203439_().map(resourceKey -> resourceKey.m_135782_(), noKey -> null);
    }

    public static boolean testBiome(Pair<String, SpawnBiomeData> entry, Holder<Biome> biome) {
        boolean result = false;
        try {
            result = BiomeConfig.test(entry, biome, MoCWorldRegistry.getBiomeName(biome));
        }
        catch (Exception e) {
            MoCreatures.LOGGER.warn("could not test biome config for " + (String)entry.getLeft() + ", defaulting to no spawns for mob");
            result = false;
        }
        return result;
    }

    public static void addBiomeSpawns(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (MoCSpawnRegistryCache.ENTITIES == null || MoCSpawnRegistryCache.ENTITIES.isEmpty()) {
            return;
        }
        ResourceLocation biomeRL = MoCWorldRegistry.getBiomeName(biome);
        if (biomeRL == null) {
            return;
        }
        String biomeName = biomeRL.toString();
        int spawnsAdded = 0;
        boolean isWyvernLair = biomeName.contains("wyvernlair");
        if (isWyvernLair && MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Processing Wyvern Lair biome: {}", (Object)biomeName);
        }
        int maxSpawnChecks = 150;
        int spawnChecks = 0;
        for (Map.Entry<String, EntityType<?>> entry : MoCSpawnRegistryCache.ENTITIES.entrySet()) {
            boolean isWyvernEntity;
            BiomeSpawnConfig.CreatureSpawnData spawnData;
            String creatureName = entry.getKey();
            EntityType<?> entityType = entry.getValue();
            if (entityType == null || (spawnData = BiomeSpawnConfig.getSpawnData(creatureName)) == null || !spawnData.enabled || spawnData.weight <= 0) continue;
            if (++spawnChecks > maxSpawnChecks) {
                MoCreatures.LOGGER.warn("Reached maximum spawn checks ({}) for biome {}, stopping to prevent server freeze", (Object)maxSpawnChecks, (Object)biomeName);
                break;
            }
            boolean bl = isWyvernEntity = creatureName.equals("bunny") || creatureName.equals("snake") || creatureName.equals("filch_lizard") || creatureName.equals("wyvern") || creatureName.equals("firefly") || creatureName.equals("dragonfly") || creatureName.equals("grasshopper");
            if (isWyvernLair && isWyvernEntity && MoCreatures.proxy.debug) {
                MoCreatures.LOGGER.info("  Checking entity: {}", (Object)creatureName);
            }
            try {
                MobCategory category;
                if (!BiomeSpawnConfig.testBiome(creatureName, biome, biomeRL)) {
                    if (!isWyvernLair || !isWyvernEntity || !MoCreatures.proxy.debug) continue;
                    MoCreatures.LOGGER.info("    Biome test failed for entity: {}", (Object)creatureName);
                    continue;
                }
                if (isWyvernLair && isWyvernEntity && MoCreatures.proxy.debug) {
                    MoCreatures.LOGGER.info("    SUCCESS: Adding {} to spawn list with weight {}, category {}", (Object)creatureName, (Object)spawnData.weight, (Object)spawnData.category);
                }
                try {
                    category = MobCategory.valueOf((String)spawnData.category);
                }
                catch (IllegalArgumentException e) {
                    category = MobCategory.CREATURE;
                }
                builder.getMobSpawnSettings().getSpawner(category).add(new MobSpawnSettings.SpawnerData(entityType, spawnData.weight, spawnData.minCount, spawnData.maxCount));
                ++spawnsAdded;
            }
            catch (Exception e) {
                if (isWyvernLair && isWyvernEntity && MoCreatures.proxy.debug) {
                    MoCreatures.LOGGER.error("    Exception processing entity {}: {}", (Object)creatureName, (Object)e.getMessage());
                }
                MoCreatures.LOGGER.debug("Error processing entity {} for biome {}: {}", (Object)creatureName, (Object)biomeName, (Object)e.getMessage());
            }
        }
        if (isWyvernLair && MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Finished processing Wyvern Lair biome: {} - Added {} spawns total", (Object)biomeName, (Object)spawnsAdded);
        }
        if (spawnsAdded > 0) {
            return;
        }
    }

    public static void addBiomeSpawnsOld(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        String biomeName = MoCWorldRegistry.getBiomeName(biome) != null ? MoCWorldRegistry.getBiomeName(biome).toString() : "unknown";
        MoCreatures.LOGGER.debug("MoCWorldRegistry: Adding spawns for biome {}", (Object)biomeName);
        if (MoCWorldRegistry.testBiome(BiomeConfig.blackBear, biome) && MoCConfig.blackBearSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BLACK_BEAR.get(), MoCConfig.blackBearSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.grizzlyBear, biome) && MoCConfig.grizzlyBearSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.GRIZZLY_BEAR.get(), MoCConfig.grizzlyBearSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.polarBear, biome) && MoCConfig.polarBearSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.POLAR_BEAR.get(), MoCConfig.polarBearSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.pandaBear, biome) && MoCConfig.pandaBearSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.PANDA_BEAR.get(), MoCConfig.pandaBearSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.bird, biome) && MoCConfig.birdSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BIRD.get(), MoCConfig.birdSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.duck, biome) && MoCConfig.duckSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.DUCK.get(), MoCConfig.duckSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.turkey, biome) && MoCConfig.turkeySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.TURKEY.get(), MoCConfig.turkeySpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.boar, biome) && MoCConfig.boarSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BOAR.get(), MoCConfig.boarSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.bunny, biome) && MoCConfig.bunnySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BUNNY.get(), MoCConfig.bunnySpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.deer, biome) && MoCConfig.deerSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.DEER.get(), MoCConfig.deerSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.goat, biome) && MoCConfig.goatSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.GOAT.get(), MoCConfig.goatSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.kitty, biome) && MoCConfig.kittySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.KITTY.get(), MoCConfig.kittySpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.crocodile, biome) && MoCConfig.crocodileSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.CROCODILE.get(), MoCConfig.crocodileSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.turtle, biome) && MoCConfig.turtleSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.TURTLE.get(), MoCConfig.turtleSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.elephant, biome) && MoCConfig.elephantSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.ELEPHANT.get(), MoCConfig.elephantSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.filchLizard, biome) && MoCConfig.filchLizardSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FILCH_LIZARD.get(), MoCConfig.filchLizardSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.ostrich, biome) && MoCConfig.ostrichSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.OSTRICH.get(), MoCConfig.ostrichSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.fox, biome) && MoCConfig.foxSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FOX.get(), MoCConfig.foxSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.komodoDragon, biome) && MoCConfig.komodoDragonSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.KOMODO_DRAGON.get(), MoCConfig.komodoDragonSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.snake, biome) && MoCConfig.snakeSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.SNAKE.get(), MoCConfig.snakeSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.leopard, biome) && MoCConfig.leopardSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.LEOPARD.get(), MoCConfig.leopardSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.lion, biome) && MoCConfig.lionSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.LION.get(), MoCConfig.lionSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.panther, biome) && MoCConfig.pantherSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.PANTHER.get(), MoCConfig.pantherSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.tiger, biome) && MoCConfig.tigerSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.TIGER.get(), MoCConfig.tigerSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.liger, biome) && MoCConfig.ligerSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.LIGER.get(), MoCConfig.ligerSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.lither, biome) && MoCConfig.litherSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.LITHER.get(), MoCConfig.litherSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.panthger, biome) && MoCConfig.panthgerSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.PANTHGER.get(), MoCConfig.panthgerSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.panthard, biome) && MoCConfig.panthardSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.PANTHARD.get(), MoCConfig.panthardSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.leoger, biome) && MoCConfig.leogerSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.LEOGER.get(), MoCConfig.leogerSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.mouse, biome) && MoCConfig.mouseSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.MOUSE.get(), MoCConfig.mouseSpawnWeight, 2, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.mole, biome) && MoCConfig.moleSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.MOLE.get(), MoCConfig.moleSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.raccoon, biome) && MoCConfig.raccoonSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.RACCOON.get(), MoCConfig.raccoonSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.wildHorse, biome) && MoCConfig.wildHorseSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.WILDHORSE.get(), MoCConfig.wildHorseSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.ent, biome) && MoCConfig.entSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.ENT.get(), MoCConfig.entSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.wyvern, biome) && MoCConfig.wyvernSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.WYVERN.get(), MoCConfig.wyvernSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.greenOgre, biome) && MoCConfig.greenOgreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.GREEN_OGRE.get(), MoCConfig.greenOgreSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.caveOgre, biome) && MoCConfig.caveOgreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.CAVE_OGRE.get(), MoCConfig.caveOgreSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.fireOgre, biome) && MoCConfig.fireOgreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FIRE_OGRE.get(), MoCConfig.fireOgreSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.caveScorpion, biome) && MoCConfig.caveScorpionSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.CAVE_SCORPION.get(), MoCConfig.caveScorpionSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.dirtScorpion, biome) && MoCConfig.dirtScorpionSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.DIRT_SCORPION.get(), MoCConfig.dirtScorpionSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.fireScorpion, biome) && MoCConfig.fireScorpionSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FIRE_SCORPION.get(), MoCConfig.fireScorpionSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.frostScorpion, biome) && MoCConfig.frostScorpionSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FROST_SCORPION.get(), MoCConfig.frostScorpionSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.undeadScorpion, biome) && MoCConfig.undeadScorpionSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.UNDEAD_SCORPION.get(), MoCConfig.undeadScorpionSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.bigGolem, biome) && MoCConfig.bigGolemSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BIG_GOLEM.get(), MoCConfig.bigGolemSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.miniGolem, biome) && MoCConfig.miniGolemSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.MINI_GOLEM.get(), MoCConfig.miniGolemSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.darkManticore, biome) && MoCConfig.darkManticoreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.DARK_MANTICORE.get(), MoCConfig.darkManticoreSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.fireManticore, biome) && MoCConfig.fireManticoreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FIRE_MANTICORE.get(), MoCConfig.fireManticoreSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.frostManticore, biome) && MoCConfig.frostManticoreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FROST_MANTICORE.get(), MoCConfig.frostManticoreSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.plainManticore, biome) && MoCConfig.plainManticoreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.PLAIN_MANTICORE.get(), MoCConfig.plainManticoreSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.toxicManticore, biome) && MoCConfig.toxicManticoreSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.TOXIC_MANTICORE.get(), MoCConfig.toxicManticoreSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.werewolf, biome) && MoCConfig.werewolfSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.WEREWOLF.get(), MoCConfig.werewolfSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.wwolf, biome) && MoCConfig.wwolfSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.WWOLF.get(), MoCConfig.wwolfSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.rat, biome) && MoCConfig.ratSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.RAT.get(), MoCConfig.ratSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.hellRat, biome) && MoCConfig.hellRatSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.HELL_RAT.get(), MoCConfig.hellRatSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.silverSkeleton, biome) && MoCConfig.silverSkeletonSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.SILVER_SKELETON.get(), MoCConfig.silverSkeletonSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.wraith, biome) && MoCConfig.wraithSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.WRAITH.get(), MoCConfig.wraithSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.flameWraith, biome) && MoCConfig.flameWraithSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FLAME_WRAITH.get(), MoCConfig.flameWraithSpawnWeight, 1, 1));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.horseMob, biome) && MoCConfig.horseMobSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.HORSE_MOB.get(), MoCConfig.horseMobSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.dolphin, biome) && MoCConfig.dolphinSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.DOLPHIN.get(), MoCConfig.dolphinSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.shark, biome) && MoCConfig.sharkSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.SHARK.get(), MoCConfig.sharkSpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.mantaRay, biome) && MoCConfig.mantaRaySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.MANTA_RAY.get(), MoCConfig.mantaRaySpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.jellyfish, biome) && MoCConfig.jellyfishSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.JELLYFISH.get(), MoCConfig.jellyfishSpawnWeight, 1, 3));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.bass, biome) && MoCConfig.bassSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BASS.get(), MoCConfig.bassSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.stingRay, biome) && MoCConfig.stingRaySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.STING_RAY.get(), MoCConfig.stingRaySpawnWeight, 1, 2));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.anchovy, biome) && MoCConfig.anchovySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.ANCHOVY.get(), MoCConfig.anchovySpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.angelfish, biome) && MoCConfig.angelfishSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.ANGELFISH.get(), MoCConfig.angelfishSpawnWeight, 3, 5));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.angler, biome) && MoCConfig.anglerSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.ANGLER.get(), MoCConfig.anglerSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.clownfish, biome) && MoCConfig.clownfishSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.CLOWNFISH.get(), MoCConfig.clownfishSpawnWeight, 3, 5));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.goldfish, biome) && MoCConfig.goldfishSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.GOLDFISH.get(), MoCConfig.goldfishSpawnWeight, 3, 5));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.hippotang, biome) && MoCConfig.hippotangSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.HIPPOTANG.get(), MoCConfig.hippotangSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.manderin, biome) && MoCConfig.manderinSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.MANDERIN.get(), MoCConfig.manderinSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.cod, biome) && MoCConfig.codSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.COD.get(), MoCConfig.codSpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.salmon, biome) && MoCConfig.salmonSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.SALMON.get(), MoCConfig.salmonSpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.piranha, biome) && MoCConfig.piranhaSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.PIRANHA.get(), MoCConfig.piranhaSpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.fishy, biome) && MoCConfig.fishySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FISHY.get(), MoCConfig.fishySpawnWeight, 4, 8));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.ant, biome) && MoCConfig.antSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.ANT.get(), MoCConfig.antSpawnWeight, 4, 8));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.bee, biome) && MoCConfig.beeSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BEE.get(), MoCConfig.beeSpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.butterfly, biome) && MoCConfig.butterflySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.BUTTERFLY.get(), MoCConfig.butterflySpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.cricket, biome) && MoCConfig.cricketSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.CRICKET.get(), MoCConfig.cricketSpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.dragonfly, biome) && MoCConfig.dragonflySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.DRAGONFLY.get(), MoCConfig.dragonflySpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.firefly, biome) && MoCConfig.fireflySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FIREFLY.get(), MoCConfig.fireflySpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.fly, biome) && MoCConfig.flySpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.FLY.get(), MoCConfig.flySpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.grasshopper, biome) && MoCConfig.grasshopperSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.GRASSHOPPER.get(), MoCConfig.grasshopperSpawnWeight, 3, 6));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.maggot, biome) && MoCConfig.maggotSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.MAGGOT.get(), MoCConfig.maggotSpawnWeight, 2, 5));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.roach, biome) && MoCConfig.roachSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.ROACH.get(), MoCConfig.roachSpawnWeight, 2, 5));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.crab, biome) && MoCConfig.crabSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.CRAB.get(), MoCConfig.crabSpawnWeight, 2, 4));
        }
        if (MoCWorldRegistry.testBiome(BiomeConfig.snail, biome) && MoCConfig.snailSpawnWeight > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)MoCEntities.SNAIL.get(), MoCConfig.snailSpawnWeight, 2, 4));
        }
    }
}

