/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.worldgen.feature;

import com.mojang.serialization.Codec;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.init.MoCBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FirestoneClusterFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public FirestoneClusterFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        boolean success = false;
        if (MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Attempting to generate firestone cluster at " + origin);
        }
        block0: for (int attempt = 0; attempt < 5; ++attempt) {
            BlockPos base = origin.m_7918_(random.m_188503_(16), random.m_188503_(50) + 20, random.m_188503_(16));
            if (MoCreatures.proxy.debug) {
                MoCreatures.LOGGER.debug("Firestone attempt " + attempt + " at " + base);
            }
            for (int offsetY = 0; offsetY < 20; ++offsetY) {
                BlockPos below;
                int i;
                int isGoodCeiling;
                BlockState blockAbove;
                BlockPos check = base.m_6625_(offsetY);
                if (this.isTooCloseToSurface(level, check)) continue;
                boolean canPlace = false;
                Direction attachDirection = null;
                if (level.m_46859_(check) && (blockAbove = level.m_8055_(check.m_7494_())).m_60783_((BlockGetter)level, check.m_7494_(), Direction.DOWN)) {
                    if (this.isWyvwoodBlock(blockAbove.m_60734_())) continue;
                    isGoodCeiling = 1;
                    for (i = 1; i <= 3 && isGoodCeiling != 0; ++i) {
                        if (level.m_46859_(check.m_6625_(i))) continue;
                        isGoodCeiling = 0;
                    }
                    if (isGoodCeiling != 0) {
                        canPlace = true;
                        attachDirection = Direction.DOWN;
                    }
                }
                if (!canPlace) {
                    blockAbove = HORIZONTAL_DIRECTIONS;
                    isGoodCeiling = ((BlockState)blockAbove).length;
                    for (i = 0; i < isGoodCeiling; ++i) {
                        BlockState blockSide;
                        BlockState dir = blockAbove[i];
                        if (!level.m_46859_(check) || level.m_46859_(check.m_121945_((Direction)dir)) || this.isWyvwoodBlock((blockSide = level.m_8055_(check.m_121945_((Direction)dir))).m_60734_()) || !blockSide.m_60783_((BlockGetter)level, check.m_121945_((Direction)dir), dir.m_122424_())) continue;
                        boolean isGoodWall = true;
                        for (int i2 = 1; i2 <= 3 && isGoodWall; ++i2) {
                            if (level.m_46859_(check.m_5484_(dir.m_122424_(), i2))) continue;
                            isGoodWall = false;
                        }
                        if (!isGoodWall) continue;
                        canPlace = true;
                        attachDirection = dir.m_122424_();
                        break;
                    }
                }
                if (canPlace && !level.m_46859_(below = check.m_7495_()) && level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP)) {
                    canPlace = false;
                }
                if (!canPlace || attachDirection == null) continue;
                BlockState firestoneState = ((Block)MoCBlocks.firestone.get()).m_49966_();
                level.m_7731_(check, firestoneState, 2);
                success = true;
                if (MoCreatures.proxy.debug) {
                    MoCreatures.LOGGER.info("Placed firestone cluster at " + check + " on " + attachDirection);
                }
                for (int i3 = 0; i3 < 12 + random.m_188503_(8); ++i3) {
                    int xOffset = random.m_188503_(5) - 2;
                    int yOffset = random.m_188503_(3) - 1;
                    int zOffset = random.m_188503_(5) - 2;
                    if (attachDirection == Direction.DOWN) {
                        yOffset = -Math.abs(yOffset);
                    } else if (attachDirection == Direction.NORTH) {
                        zOffset = -Math.abs(zOffset);
                    } else if (attachDirection == Direction.SOUTH) {
                        zOffset = Math.abs(zOffset);
                    } else if (attachDirection == Direction.WEST) {
                        xOffset = -Math.abs(xOffset);
                    } else if (attachDirection == Direction.EAST) {
                        xOffset = Math.abs(xOffset);
                    }
                    BlockPos nearby = check.m_7918_(xOffset, yOffset, zOffset);
                    if (!level.m_46859_(nearby)) continue;
                    level.m_7731_(nearby, firestoneState, 2);
                }
                continue block0;
            }
        }
        return success;
    }

    private boolean isTooCloseToSurface(WorldGenLevel level, BlockPos pos) {
        BlockPos checkPos;
        if (pos.m_123342_() > level.m_141928_() - 20) {
            return true;
        }
        int airBlocksAbove = 0;
        for (int y = 1; y <= 10 && level.m_46859_(checkPos = pos.m_6630_(y)); ++y) {
            ++airBlocksAbove;
        }
        return airBlocksAbove >= 8;
    }

    private boolean isWyvwoodBlock(Block block) {
        return block == MoCBlocks.wyvwoodLog.get() || block == MoCBlocks.wyvwoodPlanks.get() || block == MoCBlocks.wyvwoodLeaves.get();
    }
}

