/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.worldgen.feature;

import com.mojang.serialization.Codec;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.init.MoCBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WyvernNestFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceKey<Level> WYVERN_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("mocreatures", "wyvernlairworld"));

    public WyvernNestFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        if (MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Attempting to generate wyvern nest at " + origin);
        }
        if (random.m_188503_(3) != 0) {
            if (MoCreatures.proxy.debug) {
                MoCreatures.LOGGER.info("Wyvern nest generation skipped by additional rarity check");
            }
            return false;
        }
        ResourceKey dimensionType = level.m_6018_().m_46472_();
        boolean isWyvernDimension = dimensionType.m_135782_().toString().contains("wyvernlair");
        if (MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Dimension check: " + dimensionType.m_135782_() + ", isWyvernDimension: " + isWyvernDimension);
        }
        int x = origin.m_123341_();
        int z = origin.m_123343_();
        int y = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        BlockPos base = new BlockPos(x, y - 1, z);
        if (MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Wyvern nest base position: " + base);
        }
        boolean validGround = true;
        int validBlocks = 0;
        int totalBlocks = 0;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockState state;
                BlockPos check = base.m_7918_(dx, 0, dz);
                ++totalBlocks;
                if (level.m_46859_(check.m_7495_()) || (state = level.m_8055_(check)).m_60734_() != MoCBlocks.wyvgrass.get() && state.m_60734_() != MoCBlocks.silverSand.get() && state.m_60734_() != Blocks.f_49992_ && state.m_60734_() != Blocks.f_49993_ && state.m_60734_() != Blocks.f_50069_ && state.m_60734_() != Blocks.f_152550_ && state.m_60734_() != Blocks.f_50440_ && state.m_60734_() != Blocks.f_50493_) continue;
                ++validBlocks;
            }
        }
        boolean bl = validGround = (double)validBlocks >= (double)totalBlocks * 0.75;
        if (MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Wyvern nest ground check: " + validBlocks + "/" + totalBlocks + " blocks valid, result: " + validGround);
        }
        if (!validGround) {
            return false;
        }
        return this.buildNest(level, base, random);
    }

    private boolean buildNest(WorldGenLevel level, BlockPos base, RandomSource random) {
        int distSq;
        int dz;
        int dx;
        BlockState log = random.m_188499_() ? ((Block)MoCBlocks.wyvwoodLog.get()).m_49966_() : Blocks.f_50453_.m_49966_();
        for (int i = 0; i < 8; ++i) {
            level.m_7731_(base.m_6630_(i), log, 2);
        }
        BlockState nest = ((Block)MoCBlocks.wyvernNestBlock.get()).m_49966_();
        BlockPos top = base.m_6630_(8);
        for (dx = -3; dx <= 3; ++dx) {
            for (dz = -3; dz <= 3; ++dz) {
                distSq = dx * dx + dz * dz;
                if (distSq > 9) continue;
                BlockPos nestPos = top.m_7918_(dx, 0, dz);
                level.m_7731_(nestPos, nest, 2);
            }
        }
        for (dx = -4; dx <= 4; ++dx) {
            for (dz = -4; dz <= 4; ++dz) {
                distSq = dx * dx + dz * dz;
                if (distSq < 10 || distSq > 13) continue;
                BlockPos wallPos = top.m_7918_(dx, 1, dz);
                level.m_7731_(wallPos, nest, 2);
            }
        }
        BlockPos chestPos = top.m_7494_();
        level.m_7731_(chestPos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.NORTH), 2);
        BlockEntity tile = level.m_7702_(chestPos);
        if (tile instanceof ChestBlockEntity) {
            ((ChestBlockEntity)tile).m_59626_(new ResourceLocation("mocreatures:chests/wyvern_nest"), random.m_188505_());
        }
        if (MoCreatures.proxy.debug) {
            MoCreatures.LOGGER.info("Successfully generated wyvern nest at " + base);
        }
        return true;
    }

    public static boolean forceSpawnNest(Level level, BlockPos pos) {
        WyvernNestFeature feature = new WyvernNestFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
        return feature.buildNest((WorldGenLevel)level, pos, level.m_213780_());
    }
}

