/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.worldgen.structure;

import com.mojang.serialization.Codec;
import drzhark.mocreatures.MoCreatures;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WyvernIslandFeature
extends Feature<NoneFeatureConfiguration> {
    private static final String[] STRUCTURE_NAMES = new String[]{"wyvernisland1", "wyvernisland2", "wyvernisland3", "wyvernisland4"};
    private static final boolean DEBUG = false;

    public WyvernIslandFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        ResourceKey dimensionType = context.m_159774_().m_6018_().m_46472_();
        if (!dimensionType.m_135782_().toString().contains("wyvernlair")) {
            return false;
        }
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int ci = origin.m_123341_() >> 4 << 4;
        int ck = origin.m_123343_() >> 4 << 4;
        int count = random.m_188503_(2) + 1;
        boolean success = false;
        for (int a = 0; a < count; ++a) {
            StructureTemplate template;
            BlockPos spawnPos;
            Mirror mirror;
            Rotation rotation;
            String structureName;
            block9: {
                int i = ci + random.m_188503_(16);
                int k = ck + random.m_188503_(16);
                int j = context.m_159774_().m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, i, k);
                structureName = STRUCTURE_NAMES[random.m_188503_(STRUCTURE_NAMES.length)];
                rotation = Rotation.values()[random.m_188503_(Rotation.values().length)];
                mirror = Mirror.values()[random.m_188503_(Mirror.values().length)];
                spawnPos = new BlockPos(i, j += random.m_188503_(84) + 16, k);
                StructureTemplateManager templateManager = context.m_159774_().m_6018_().m_215082_();
                ResourceLocation location = new ResourceLocation("mocreatures", structureName);
                template = null;
                try {
                    Optional optionalTemplate = templateManager.m_230407_(location);
                    if (!optionalTemplate.isPresent()) {
                        MoCreatures.LOGGER.error("Failed to load structure template: {}", (Object)location);
                        MoCreatures.LOGGER.error("Make sure the structure file exists at data/mocreatures/structures/{}.nbt", (Object)structureName);
                        continue;
                    }
                    template = (StructureTemplate)optionalTemplate.get();
                    Vec3i size = template.m_163801_();
                    if (size.m_123341_() == 0 || size.m_123342_() == 0 || size.m_123343_() == 0) {
                        MoCreatures.LOGGER.error("Structure template {} has invalid size {}. The NBT file may be corrupted.", (Object)location, (Object)size);
                    }
                    break block9;
                }
                catch (Exception e) {
                    MoCreatures.LOGGER.error("Exception while loading structure template: {}", (Object)location);
                    MoCreatures.LOGGER.error("Error: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
                continue;
            }
            StructurePlaceSettings placementSettings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror).m_230324_(random).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74392_(false).m_163782_(false).m_74402_(false);
            try {
                boolean result = template.m_230328_((ServerLevelAccessor)context.m_159774_(), spawnPos, spawnPos, placementSettings, random, 2);
                if (result) {
                    MoCreatures.LOGGER.info("Successfully generated wyvern island {} at {}", (Object)structureName, (Object)spawnPos);
                    success = true;
                    continue;
                }
                MoCreatures.LOGGER.error("Failed to place wyvern island {} at {}", (Object)structureName, (Object)spawnPos);
                MoCreatures.LOGGER.error("This could be due to terrain interference or other structures in the area");
                continue;
            }
            catch (Exception e) {
                MoCreatures.LOGGER.error("Exception while placing wyvern island: {}", (Object)e.getMessage());
                MoCreatures.LOGGER.error("Stack trace:");
                e.printStackTrace();
            }
        }
        return true;
    }
}

