/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges.blocks;

import com.mars.laserbridges.LasersConfig;
import com.mars.laserbridges.blocks.BridgeSourceBlock;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FenceSourceBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final IntegerProperty COLOR = BridgeSourceBlock.COLOR;
    protected static final VoxelShape CEILING_X_SHAPE = Block.m_49796_((double)0.0, (double)14.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.m_49796_((double)5.0, (double)14.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CEILING_X_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)CEILING_X_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)14.0, (double)8.00001));
    protected static final VoxelShape CEILING_Z_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)CEILING_Z_SHAPE, (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)8.00001, (double)14.0, (double)16.0));
    protected static final VoxelShape FLOOR_X_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)11.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)2.0, (double)16.0);
    protected static final VoxelShape FLOOR_X_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)FLOOR_X_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)8.00001));
    protected static final VoxelShape FLOOR_Z_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)FLOOR_Z_SHAPE, (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)8.00001, (double)16.0, (double)16.0));
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)14.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)11.0);
    protected static final VoxelShape NORTH_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)NORTH_SHAPE, (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)8.00001, (double)16.0, (double)16.0));
    protected static final VoxelShape SOUTH_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)SOUTH_SHAPE, (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)8.00001, (double)16.0, (double)16.0));
    protected static final VoxelShape WEST_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)WEST_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)8.00001));
    protected static final VoxelShape EAST_POWERED_SHAPE = Shapes.m_83110_((VoxelShape)EAST_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)8.00001));

    public FenceSourceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(0)));
    }

    public void generateBridge(LevelAccessor world, int power, BlockPos pos, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        int col = (Integer)state.m_61143_((Property)COLOR);
        boolean bridgeEnded = false;
        float min_length = (float)LasersConfig.max_length / 15.0f;
        int length = (int)(min_length * (float)power);
        world.m_5594_((Player)null, pos, (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("laserbridges", length == 0 ? "off" : "on")), SoundSource.BLOCKS, 0.3f, 0.5f);
        for (int i = 1; i < LasersConfig.max_length; ++i) {
            BlockPos addPos = new BlockPos(0, 0, 0);
            BlockState bs = (BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("laserbridges", "laser_fence_powered"))).m_49966_().m_61124_((Property)COLOR, (Comparable)Integer.valueOf(col))).m_61124_((Property)FACING, (Comparable)dir)).m_61124_(FACE, (Comparable)face);
            switch (face) {
                case FLOOR: {
                    addPos = new BlockPos(0, i, 0);
                    break;
                }
                case WALL: {
                    switch (dir) {
                        case EAST: {
                            addPos = new BlockPos(i, 0, 0);
                            break;
                        }
                        case WEST: {
                            addPos = new BlockPos(-i, 0, 0);
                            break;
                        }
                        case SOUTH: {
                            addPos = new BlockPos(0, 0, i);
                            break;
                        }
                        case NORTH: {
                            addPos = new BlockPos(0, 0, -i);
                        }
                    }
                    break;
                }
                case CEILING: {
                    addPos = new BlockPos(0, -i, 0);
                }
            }
            BlockPos nextPos = pos.m_121955_((Vec3i)addPos);
            BlockState nextState = world.m_8055_(nextPos);
            String nextBlockName = BuiltInRegistries.f_256975_.m_7981_((Object)nextState.m_60734_()).toString();
            boolean isDestroyable = LasersConfig.blocks_cut_through_by_lasers.contains(nextBlockName);
            if (!nextState.equals(bs) && !isDestroyable) {
                return;
            }
            if (isDestroyable) {
                world.m_46961_(nextPos, true);
            }
            if (!bridgeEnded && i < length) {
                world.m_7731_(nextPos, bs, 3);
                continue;
            }
            bridgeEnded = true;
            world.m_7731_(nextPos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level lvl, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            int col = ((DyeItem)item).m_41089_().m_41060_();
            if (player == null || !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)COLOR, (Comparable)Integer.valueOf(col)), 2);
            return InteractionResult.m_19078_((boolean)lvl.f_46443_);
        }
        return super.m_6227_(state, lvl, pos, player, hand, hit);
    }

    public void m_6861_(BlockState state, Level lvl, BlockPos pos, Block p_55669_, BlockPos p_55670_, boolean p_55671_) {
        if (lvl.f_46443_) {
            return;
        }
        int redstonePower = lvl.m_277086_(pos);
        boolean flag = (Boolean)state.m_61143_((Property)POWERED);
        if (flag != lvl.m_276867_(pos)) {
            if (flag) {
                lvl.m_186460_(pos, (Block)this, 0);
            } else {
                lvl.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
                this.generateBridge((LevelAccessor)lvl, redstonePower, pos, state);
            }
        } else if (flag) {
            lvl.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel lvl, BlockPos pos, RandomSource p_221940_) {
        if (lvl.f_46443_) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            if (!lvl.m_276867_(pos)) {
                lvl.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
                this.generateBridge((LevelAccessor)lvl, 0, pos, state);
            } else {
                int redstonePower = lvl.m_277086_(pos);
                this.generateBridge((LevelAccessor)lvl, redstonePower, pos, state);
            }
        }
    }

    public void m_6807_(BlockState state, Level lvl, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        if (lvl.f_46443_) {
            return;
        }
        boolean bl = (Boolean)state.m_61143_((Property)POWERED);
        if (bl != lvl.m_276867_(pos)) {
            if (bl) {
                lvl.m_186460_(pos, (Block)this, 0);
            } else {
                lvl.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
                int redstone = lvl.m_277086_(pos);
                this.generateBridge((LevelAccessor)lvl, redstone, pos, state);
            }
        }
    }

    public void m_6810_(BlockState state, Level lvl, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        if (!lvl.f_46443_) {
            lvl.m_5594_((Player)null, pos, SoundEvents.f_12062_, SoundSource.BLOCKS, 0.3f, 0.5f);
            this.generateBridge((LevelAccessor)lvl, 0, pos, state);
        }
    }

    public BlockState m_7417_(BlockState state, Direction p_53191_, BlockState statea, LevelAccessor lvl, BlockPos pos, BlockPos p_53195_) {
        if (!state.m_60710_((LevelReader)lvl, pos)) {
            this.generateBridge(lvl, 0, pos, state);
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        switch ((AttachFace)state.m_61143_(FACE)) {
            case FLOOR: {
                if (dir.m_122434_() == Direction.Axis.X) {
                    return powered ? FLOOR_X_POWERED_SHAPE : FLOOR_X_SHAPE;
                }
                return powered ? FLOOR_Z_POWERED_SHAPE : FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch (dir) {
                    case EAST: {
                        return powered ? EAST_POWERED_SHAPE : EAST_SHAPE;
                    }
                    case WEST: {
                        return powered ? WEST_POWERED_SHAPE : WEST_SHAPE;
                    }
                    case SOUTH: {
                        return powered ? SOUTH_POWERED_SHAPE : SOUTH_SHAPE;
                    }
                }
                return powered ? NORTH_POWERED_SHAPE : NORTH_SHAPE;
            }
        }
        if (dir.m_122434_() == Direction.Axis.X) {
            return powered ? CEILING_X_POWERED_SHAPE : CEILING_X_SHAPE;
        }
        return powered ? CEILING_Z_POWERED_SHAPE : CEILING_Z_SHAPE;
    }

    public boolean m_7357_(BlockState $$0, BlockGetter $$1, BlockPos $$2, PathComputationType $$3) {
        return false;
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> m_304657_() {
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{FACE});
        builder.m_61104_(new Property[]{COLOR});
    }
}

