/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges.blocks;

import com.mars.laserbridges.blocks.BridgeSourceBlock;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaserBridgeBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    public static final IntegerProperty COLOR = BridgeSourceBlock.COLOR;
    public static final MapCodec<LaserBridgeBlock> CODEC = LaserBridgeBlock.simpleCodec(LaserBridgeBlock::new);
    public static final VoxelShape CEILING_X_SHAPE = Block.box((double)7.99999, (double)0.0, (double)0.0, (double)8.0, (double)14.0, (double)16.0);
    public static final VoxelShape CEILING_Z_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.99999, (double)16.0, (double)14.0, (double)8.0);
    public static final VoxelShape FLOOR_X_SHAPE = Block.box((double)7.99999, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape FLOOR_Z_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.99999, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)7.99999, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)7.99999, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)7.99999, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)7.99999, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public LaserBridgeBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue(FACING);
        switch ((AttachFace)state.getValue(FACE)) {
            case FLOOR: {
                if (dir.getAxis() == Direction.Axis.X) {
                    return FLOOR_X_SHAPE;
                }
                return FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch (dir) {
                    case EAST: {
                        return EAST_SHAPE;
                    }
                    case WEST: {
                        return WEST_SHAPE;
                    }
                    case SOUTH: {
                        return SOUTH_SHAPE;
                    }
                }
                return NORTH_SHAPE;
            }
        }
        if (dir.getAxis() == Direction.Axis.X) {
            return CEILING_X_SHAPE;
        }
        return CEILING_Z_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{FACE});
        builder.add(new Property[]{COLOR});
    }

    protected boolean isPathfindable(BlockState p_57535_, PathComputationType p_57538_) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

