/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges;

import com.mars.laserbridges.CommonClass;
import com.mars.laserbridges.Constants;
import com.mars.laserbridges.blocks.BridgeSourceBlock;
import com.mars.laserbridges.blocks.FenceSourceBlock;
import com.mars.laserbridges.blocks.LaserBridgeBlock;
import com.mars.laserbridges.blocks.LaserFenceBlock;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="laserbridges")
public class Laserbridges {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"laserbridges");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"laserbridges");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"laserbridges");
    static ResourceLocation laser_source_block_id = ResourceLocation.fromNamespaceAndPath((String)"laserbridges", (String)"laser_source_block");
    static ResourceLocation laser_block_id = ResourceLocation.fromNamespaceAndPath((String)"laserbridges", (String)"laser_block_powered");
    static ResourceLocation laser_fence_source_block_id = ResourceLocation.fromNamespaceAndPath((String)"laserbridges", (String)"laser_fence_source_block");
    static ResourceLocation laser_fence_block_id = ResourceLocation.fromNamespaceAndPath((String)"laserbridges", (String)"laser_fence_powered");
    public static final RegistryObject<Block> BRIDGE_SOURCE_BLOCK = BLOCKS.register("laser_source_block", () -> new BridgeSourceBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)laser_source_block_id)).strength(0.8f).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? Constants.LIGHT : 0)));
    public static final RegistryObject<BlockItem> BRIDGE_SOURCE_BLOCK_ITEM = ITEMS.register("laser_source_block", () -> new BlockItem((Block)BRIDGE_SOURCE_BLOCK.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ITEMS.key(laser_source_block_id))));
    public static final RegistryObject<Block> LASER_BLOCK = BLOCKS.register("laser_block_powered", () -> new LaserBridgeBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)laser_block_id)).strength(-1.0f, 3600000.0f).noOcclusion().lightLevel(p_220871_ -> Constants.LIGHT)));
    public static final RegistryObject<Block> LASER_FENCE_SOURCE_BLOCK = BLOCKS.register("laser_fence_source_block", () -> new FenceSourceBlock(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)laser_fence_source_block_id)).strength(0.8f).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? Constants.LIGHT : 0)));
    public static final RegistryObject<BlockItem> LASER_FENCE_SOURCE_BLOCK_ITEM = ITEMS.register("laser_fence_source_block", () -> new BlockItem((Block)LASER_FENCE_SOURCE_BLOCK.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ITEMS.key(laser_fence_source_block_id))));
    public static final RegistryObject<Block> LASER_FENCE_BLOCK = BLOCKS.register("laser_fence_powered", () -> new LaserFenceBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)laser_fence_block_id)).noOcclusion().lightLevel(p_220871_ -> Constants.LIGHT)));
    public static final RegistryObject<SoundEvent> ON = Laserbridges.registerSoundEvent("on");
    public static final RegistryObject<SoundEvent> OFF = Laserbridges.registerSoundEvent("off");

    public Laserbridges() {
        CommonClass.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_BLOCK.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BRIDGE_SOURCE_BLOCK.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_FENCE_SOURCE_BLOCK.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_FENCE_BLOCK.get()), (RenderType)RenderType.translucent());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept(BRIDGE_SOURCE_BLOCK_ITEM);
            event.accept(LASER_FENCE_SOURCE_BLOCK_ITEM);
        }
    }

    private static RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createFixedRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"laserbridges", (String)name), (float)75.0f));
    }

    @Mod.EventBusSubscriber(modid="laserbridges", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
            event.register((state, level, pos, tintIndex) -> DyeColor.byId((int)((Integer)state.getValue((Property)BridgeSourceBlock.COLOR))).getTextureDiffuseColor(), new Block[]{(Block)BRIDGE_SOURCE_BLOCK.get(), (Block)LASER_FENCE_SOURCE_BLOCK.get(), (Block)LASER_BLOCK.get(), (Block)LASER_FENCE_BLOCK.get()});
        }
    }
}

