/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges;

import com.mars.laserbridges.CommonClass;
import com.mars.laserbridges.Constants;
import com.mars.laserbridges.blocks.BridgeSourceBlock;
import com.mars.laserbridges.blocks.FenceSourceBlock;
import com.mars.laserbridges.blocks.LaserBridgeBlock;
import com.mars.laserbridges.blocks.LaserFenceBlock;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="laserbridges")
public class Laserbridges {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"laserbridges");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"laserbridges");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"laserbridges");
    public static final DeferredBlock<Block> BRIDGE_SOURCE_BLOCK = BLOCKS.register("laser_source_block", () -> new BridgeSourceBlock(BlockBehaviour.Properties.of().strength(0.8f).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? Constants.LIGHT : 0)));
    public static final DeferredItem<BlockItem> BRIDGE_SOURCE_BLOCK_ITEM = ITEMS.registerSimpleBlockItem("laser_source_block", BRIDGE_SOURCE_BLOCK);
    public static final DeferredBlock<Block> LASER_BLOCK = BLOCKS.register("laser_block_powered", () -> new LaserBridgeBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).noOcclusion().lightLevel(p_220871_ -> Constants.LIGHT)));
    public static final DeferredBlock<Block> LASER_FENCE_SOURCE_BLOCK = BLOCKS.register("laser_fence_source_block", () -> new FenceSourceBlock(BlockBehaviour.Properties.of().strength(0.8f).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? Constants.LIGHT : 0)));
    public static final DeferredItem<BlockItem> LASER_FENCE_SOURCE_BLOCK_ITEM = ITEMS.registerSimpleBlockItem("laser_fence_source_block", LASER_FENCE_SOURCE_BLOCK);
    public static final DeferredBlock<Block> LASER_FENCE_BLOCK = BLOCKS.register("laser_fence_powered", () -> new LaserFenceBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).noOcclusion().lightLevel(p_220871_ -> Constants.LIGHT)));
    public static final DeferredHolder<SoundEvent, SoundEvent> ON = Laserbridges.registerSoundEvent("on");
    public static final DeferredHolder<SoundEvent, SoundEvent> OFF = Laserbridges.registerSoundEvent("off");

    public Laserbridges(IEventBus modEventBus) {
        CommonClass.init();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept(BRIDGE_SOURCE_BLOCK_ITEM);
            event.accept(LASER_FENCE_SOURCE_BLOCK_ITEM);
        }
    }

    public static DeferredHolder<SoundEvent, SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createFixedRangeEvent((ResourceLocation)new ResourceLocation("laserbridges", name), (float)75.0f));
    }

    @EventBusSubscriber(modid="laserbridges", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
            event.register((state, level, pos, tintIndex) -> (int)(DyeColor.byId((int)((Integer)state.getValue((Property)BridgeSourceBlock.COLOR))).getTextureDiffuseColors()[0] * 255.0f) << 16 | (int)(DyeColor.byId((int)((Integer)state.getValue((Property)BridgeSourceBlock.COLOR))).getTextureDiffuseColors()[1] * 255.0f) << 8 | (int)(DyeColor.byId((int)((Integer)state.getValue((Property)BridgeSourceBlock.COLOR))).getTextureDiffuseColors()[2] * 255.0f), new Block[]{(Block)BRIDGE_SOURCE_BLOCK.value(), (Block)LASER_FENCE_SOURCE_BLOCK.value(), (Block)LASER_BLOCK.value(), (Block)LASER_FENCE_BLOCK.value()});
        }
    }
}

