/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges.blocks;

import com.mars.laserbridges.LasersConfig;
import com.mars.laserbridges.blocks.LaserBridgeBlock;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BridgeSourceBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    public static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)0, (int)15);
    protected static final VoxelShape CEILING_X_SHAPE = Block.box((double)5.0, (double)14.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.box((double)0.0, (double)14.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape CEILING_X_POWERED_SHAPE = Shapes.or((VoxelShape)CEILING_X_SHAPE, (VoxelShape)LaserBridgeBlock.CEILING_X_SHAPE);
    protected static final VoxelShape CEILING_Z_POWERED_SHAPE = Shapes.or((VoxelShape)CEILING_Z_SHAPE, (VoxelShape)LaserBridgeBlock.CEILING_Z_SHAPE);
    protected static final VoxelShape FLOOR_X_SHAPE = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)2.0, (double)16.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)11.0);
    protected static final VoxelShape FLOOR_X_POWERED_SHAPE = Shapes.or((VoxelShape)FLOOR_X_SHAPE, (VoxelShape)LaserBridgeBlock.FLOOR_X_SHAPE);
    protected static final VoxelShape FLOOR_Z_POWERED_SHAPE = Shapes.or((VoxelShape)FLOOR_Z_SHAPE, (VoxelShape)LaserBridgeBlock.FLOOR_Z_SHAPE);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)2.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)14.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)16.0);
    protected static final VoxelShape NORTH_POWERED_SHAPE = Shapes.or((VoxelShape)NORTH_SHAPE, (VoxelShape)LaserBridgeBlock.NORTH_SHAPE);
    protected static final VoxelShape SOUTH_POWERED_SHAPE = Shapes.or((VoxelShape)SOUTH_SHAPE, (VoxelShape)LaserBridgeBlock.SOUTH_SHAPE);
    protected static final VoxelShape WEST_POWERED_SHAPE = Shapes.or((VoxelShape)WEST_SHAPE, (VoxelShape)LaserBridgeBlock.WEST_SHAPE);
    protected static final VoxelShape EAST_POWERED_SHAPE = Shapes.or((VoxelShape)EAST_SHAPE, (VoxelShape)LaserBridgeBlock.EAST_SHAPE);

    public BridgeSourceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)COLOR, (Comparable)Integer.valueOf(0)));
    }

    public void generateBridge(LevelAccessor world, int power, BlockPos pos, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        AttachFace face = (AttachFace)state.getValue(FACE);
        int col = (Integer)state.getValue((Property)COLOR);
        boolean bridgeEnded = false;
        float min_length = (float)LasersConfig.max_length / 15.0f;
        int length = (int)(min_length * (float)power);
        world.playSound((Player)null, pos, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("laserbridges", length == 0 ? "off" : "on")), SoundSource.BLOCKS, 0.3f, 0.5f);
        for (int i = 1; i < LasersConfig.max_length; ++i) {
            BlockPos addPos = new BlockPos(0, 0, 0);
            BlockState bs = (BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(new ResourceLocation("laserbridges", "laser_block_powered"))).defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(col))).setValue((Property)FACING, (Comparable)dir)).setValue(FACE, (Comparable)face);
            switch (face) {
                case FLOOR: {
                    addPos = new BlockPos(0, i, 0);
                    break;
                }
                case WALL: {
                    switch (dir) {
                        case EAST: {
                            addPos = new BlockPos(i, 0, 0);
                            break;
                        }
                        case WEST: {
                            addPos = new BlockPos(-i, 0, 0);
                            break;
                        }
                        case SOUTH: {
                            addPos = new BlockPos(0, 0, i);
                            break;
                        }
                        case NORTH: {
                            addPos = new BlockPos(0, 0, -i);
                        }
                    }
                    break;
                }
                case CEILING: {
                    addPos = new BlockPos(0, -i, 0);
                }
            }
            BlockPos nextPos = pos.offset((Vec3i)addPos);
            BlockState nextState = world.getBlockState(nextPos);
            String nextBlockName = BuiltInRegistries.BLOCK.getKey((Object)nextState.getBlock()).toString();
            boolean isDestroyable = LasersConfig.blocks_cut_through_by_lasers.contains(nextBlockName);
            if (!(nextState.equals(bs) || isDestroyable || this.isSameExceptCol(bs, nextState))) {
                return;
            }
            if (isDestroyable) {
                world.destroyBlock(nextPos, true);
            }
            if (!bridgeEnded && i < length) {
                world.setBlock(nextPos, bs, 3);
                continue;
            }
            bridgeEnded = true;
            world.setBlock(nextPos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public boolean isSameExceptCol(BlockState oldBs, BlockState newBs) {
        if (!oldBs.getBlock().equals(newBs.getBlock())) {
            return false;
        }
        if (!((Direction)oldBs.getValue((Property)FACING)).equals((Object)newBs.getValue((Property)FACING))) {
            return false;
        }
        return ((AttachFace)oldBs.getValue(FACE)).equals((Object)newBs.getValue(FACE));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level lvl, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            int col = ((DyeItem)item).getDyeColor().getId();
            stack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            BlockState newBS = (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(col));
            lvl.setBlock(pos, newBS, 3);
            int redstonePower = lvl.getBestNeighborSignal(pos);
            this.generateBridge((LevelAccessor)lvl, redstonePower, pos, newBS);
            return ItemInteractionResult.sidedSuccess((boolean)lvl.isClientSide);
        }
        return super.useItemOn(stack, state, lvl, pos, player, hand, hit);
    }

    public void neighborChanged(BlockState state, Level lvl, BlockPos pos, Block p_55669_, BlockPos p_55670_, boolean p_55671_) {
        if (lvl.isClientSide) {
            return;
        }
        int redstonePower = lvl.getBestNeighborSignal(pos);
        boolean flag = (Boolean)state.getValue((Property)POWERED);
        if (flag != lvl.hasNeighborSignal(pos)) {
            if (flag) {
                lvl.scheduleTick(pos, (Block)this, 0);
            } else {
                lvl.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                this.generateBridge((LevelAccessor)lvl, redstonePower, pos, state);
            }
        } else if (flag) {
            lvl.scheduleTick(pos, (Block)this, 0);
        }
    }

    public void tick(BlockState state, ServerLevel lvl, BlockPos pos, RandomSource p_221940_) {
        if (lvl.isClientSide) {
            return;
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (!lvl.hasNeighborSignal(pos)) {
                lvl.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                this.generateBridge((LevelAccessor)lvl, 0, pos, state);
            } else {
                int redstonePower = lvl.getBestNeighborSignal(pos);
                this.generateBridge((LevelAccessor)lvl, redstonePower, pos, state);
            }
        }
    }

    public void onPlace(BlockState state, Level lvl, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        if (lvl.isClientSide) {
            return;
        }
        boolean bl = (Boolean)state.getValue((Property)POWERED);
        if (bl != lvl.hasNeighborSignal(pos)) {
            if (bl) {
                lvl.scheduleTick(pos, (Block)this, 0);
            } else {
                lvl.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                int redstone = lvl.getBestNeighborSignal(pos);
                this.generateBridge((LevelAccessor)lvl, redstone, pos, state);
            }
        }
    }

    public void onRemove(BlockState state, Level lvl, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        if (!lvl.isClientSide) {
            lvl.playSound((Player)null, pos, SoundEvents.METAL_BREAK, SoundSource.BLOCKS, 0.3f, 0.5f);
            this.generateBridge((LevelAccessor)lvl, 0, pos, state);
        }
    }

    public BlockState updateShape(BlockState state, Direction p_53191_, BlockState statea, LevelAccessor lvl, BlockPos pos, BlockPos p_53195_) {
        if (!state.canSurvive((LevelReader)lvl, pos)) {
            this.generateBridge(lvl, 0, pos, state);
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        switch ((AttachFace)state.getValue(FACE)) {
            case FLOOR: {
                if (dir.getAxis() == Direction.Axis.X) {
                    return powered ? FLOOR_X_POWERED_SHAPE : FLOOR_X_SHAPE;
                }
                return powered ? FLOOR_Z_POWERED_SHAPE : FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch (dir) {
                    case EAST: {
                        return powered ? EAST_POWERED_SHAPE : EAST_SHAPE;
                    }
                    case WEST: {
                        return powered ? WEST_POWERED_SHAPE : WEST_SHAPE;
                    }
                    case SOUTH: {
                        return powered ? SOUTH_POWERED_SHAPE : SOUTH_SHAPE;
                    }
                }
                return powered ? NORTH_POWERED_SHAPE : NORTH_SHAPE;
            }
        }
        if (dir.getAxis() == Direction.Axis.X) {
            return powered ? CEILING_X_POWERED_SHAPE : CEILING_X_SHAPE;
        }
        return powered ? CEILING_Z_POWERED_SHAPE : CEILING_Z_SHAPE;
    }

    protected boolean isPathfindable(BlockState p_57535_, PathComputationType p_57538_) {
        return false;
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{FACE});
        builder.add(new Property[]{COLOR});
    }
}

