/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges.blocks;

import com.mars.laserbridges.LasersConfig;
import com.mars.laserbridges.blocks.LaserBridgeBlock;
import com.mars.laserbridges.platform.Services;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class BridgeSourceBlock
extends class_2341 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<class_2738> FACE = class_2741.field_12555;
    public static final class_2758 COLOR = class_2758.method_11867((String)"color", (int)0, (int)15);
    protected static final class_265 CEILING_X_SHAPE = class_2248.method_9541((double)5.0, (double)14.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final class_265 CEILING_Z_SHAPE = class_2248.method_9541((double)0.0, (double)14.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final class_265 CEILING_X_POWERED_SHAPE = class_259.method_1084((class_265)CEILING_X_SHAPE, (class_265)LaserBridgeBlock.CEILING_X_SHAPE);
    protected static final class_265 CEILING_Z_POWERED_SHAPE = class_259.method_1084((class_265)CEILING_Z_SHAPE, (class_265)LaserBridgeBlock.CEILING_Z_SHAPE);
    protected static final class_265 FLOOR_X_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)2.0, (double)16.0);
    protected static final class_265 FLOOR_Z_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)11.0);
    protected static final class_265 FLOOR_X_POWERED_SHAPE = class_259.method_1084((class_265)FLOOR_X_SHAPE, (class_265)LaserBridgeBlock.FLOOR_X_SHAPE);
    protected static final class_265 FLOOR_Z_POWERED_SHAPE = class_259.method_1084((class_265)FLOOR_Z_SHAPE, (class_265)LaserBridgeBlock.FLOOR_Z_SHAPE);
    protected static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)2.0);
    protected static final class_265 WEST_SHAPE = class_2248.method_9541((double)14.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)16.0);
    protected static final class_265 NORTH_POWERED_SHAPE = class_259.method_1084((class_265)NORTH_SHAPE, (class_265)LaserBridgeBlock.NORTH_SHAPE);
    protected static final class_265 SOUTH_POWERED_SHAPE = class_259.method_1084((class_265)SOUTH_SHAPE, (class_265)LaserBridgeBlock.SOUTH_SHAPE);
    protected static final class_265 WEST_POWERED_SHAPE = class_259.method_1084((class_265)WEST_SHAPE, (class_265)LaserBridgeBlock.WEST_SHAPE);
    protected static final class_265 EAST_POWERED_SHAPE = class_259.method_1084((class_265)EAST_SHAPE, (class_265)LaserBridgeBlock.EAST_SHAPE);

    public BridgeSourceBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(0)));
    }

    public void generateBridge(class_1936 world, int power, class_2338 pos, class_2680 state) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        class_2738 face = (class_2738)state.method_11654(FACE);
        int col = (Integer)state.method_11654((class_2769)COLOR);
        boolean bridgeEnded = false;
        float min_length = (float)LasersConfig.max_length / 15.0f;
        int length = (int)(min_length * (float)power);
        world.method_8396((class_1657)null, pos, Services.PLATFORM.getSoundEvent(power), class_3419.field_15245, 0.3f, 0.5f);
        for (int i = 1; i < LasersConfig.max_length; ++i) {
            class_2338 addPos = new class_2338(0, 0, 0);
            class_2680 bs = (class_2680)((class_2680)((class_2680)((class_2248)class_2378.field_11146.method_10223(new class_2960("laserbridges", "laser_block_powered"))).method_9564().method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(col))).method_11657((class_2769)FACING, (Comparable)dir)).method_11657(FACE, (Comparable)face);
            switch (face) {
                case field_12475: {
                    addPos = new class_2338(0, i, 0);
                    break;
                }
                case field_12471: {
                    switch (dir) {
                        case field_11034: {
                            addPos = new class_2338(i, 0, 0);
                            break;
                        }
                        case field_11039: {
                            addPos = new class_2338(-i, 0, 0);
                            break;
                        }
                        case field_11035: {
                            addPos = new class_2338(0, 0, i);
                            break;
                        }
                        case field_11043: {
                            addPos = new class_2338(0, 0, -i);
                        }
                    }
                    break;
                }
                case field_12473: {
                    addPos = new class_2338(0, -i, 0);
                }
            }
            class_2338 nextPos = pos.method_10081((class_2382)addPos);
            class_2680 nextState = world.method_8320(nextPos);
            String nextBlockName = class_2378.field_11146.method_10221((Object)nextState.method_26204()).toString();
            boolean isDestroyable = LasersConfig.blocks_cut_through_by_lasers.contains(nextBlockName);
            if (!nextState.equals(bs) && !isDestroyable) {
                return;
            }
            if (isDestroyable) {
                world.method_22352(nextPos, true);
            }
            if (!bridgeEnded && i < length) {
                world.method_8652(nextPos, bs, 3);
                continue;
            }
            bridgeEnded = true;
            world.method_8652(nextPos, class_2246.field_10124.method_9564(), 3);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 lvl, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (item instanceof class_1769) {
            int col = ((class_1769)item).method_7802().method_7789();
            if (player == null || !player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            lvl.method_8652(pos, (class_2680)state.method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(col)), 2);
            return class_1269.method_29236((boolean)lvl.field_9236);
        }
        return super.method_9534(state, lvl, pos, player, hand, hit);
    }

    public void method_9612(class_2680 state, class_1937 lvl, class_2338 pos, class_2248 p_55669_, class_2338 p_55670_, boolean p_55671_) {
        if (lvl.field_9236) {
            return;
        }
        int redstonePower = lvl.method_8482(pos);
        boolean flag = (Boolean)state.method_11654((class_2769)POWERED);
        if (flag != lvl.method_8479(pos)) {
            if (flag) {
                lvl.method_39279(pos, (class_2248)this, 0);
            } else {
                lvl.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
                this.generateBridge((class_1936)lvl, redstonePower, pos, state);
            }
        } else if (flag) {
            lvl.method_39279(pos, (class_2248)this, 0);
        }
    }

    public void method_9588(class_2680 state, class_3218 lvl, class_2338 pos, class_5819 p_221940_) {
        if (lvl.field_9236) {
            return;
        }
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            if (!lvl.method_8479(pos)) {
                lvl.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
                this.generateBridge((class_1936)lvl, 0, pos, state);
            } else {
                int redstonePower = lvl.method_8482(pos);
                this.generateBridge((class_1936)lvl, redstonePower, pos, state);
            }
        }
    }

    public void method_9615(class_2680 state, class_1937 lvl, class_2338 pos, class_2680 p_60569_, boolean p_60570_) {
        if (lvl.field_9236) {
            return;
        }
        boolean bl = (Boolean)state.method_11654((class_2769)POWERED);
        if (bl != lvl.method_8479(pos)) {
            if (bl) {
                lvl.method_39279(pos, (class_2248)this, 0);
            } else {
                lvl.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
                int redstone = lvl.method_8482(pos);
                this.generateBridge((class_1936)lvl, redstone, pos, state);
            }
        }
    }

    public void method_9536(class_2680 state, class_1937 lvl, class_2338 pos, class_2680 p_60518_, boolean p_60519_) {
        if (!lvl.field_9236) {
            lvl.method_8396((class_1657)null, pos, class_3417.field_15044, class_3419.field_15245, 0.3f, 0.5f);
            this.generateBridge((class_1936)lvl, 0, pos, state);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 p_53191_, class_2680 statea, class_1936 lvl, class_2338 pos, class_2338 p_53195_) {
        if (!state.method_26184((class_4538)lvl, pos)) {
            this.generateBridge(lvl, 0, pos, state);
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public class_265 method_9530(class_2680 state, class_1922 p_60556_, class_2338 pos, class_3726 context) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        boolean powered = (Boolean)state.method_11654((class_2769)POWERED);
        switch ((class_2738)state.method_11654(FACE)) {
            case field_12475: {
                if (dir.method_10166() == class_2350.class_2351.field_11048) {
                    return powered ? FLOOR_X_POWERED_SHAPE : FLOOR_X_SHAPE;
                }
                return powered ? FLOOR_Z_POWERED_SHAPE : FLOOR_Z_SHAPE;
            }
            case field_12471: {
                switch (dir) {
                    case field_11034: {
                        return powered ? EAST_POWERED_SHAPE : EAST_SHAPE;
                    }
                    case field_11039: {
                        return powered ? WEST_POWERED_SHAPE : WEST_SHAPE;
                    }
                    case field_11035: {
                        return powered ? SOUTH_POWERED_SHAPE : SOUTH_SHAPE;
                    }
                }
                return powered ? NORTH_POWERED_SHAPE : NORTH_SHAPE;
            }
        }
        if (dir.method_10166() == class_2350.class_2351.field_11048) {
            return powered ? CEILING_X_POWERED_SHAPE : CEILING_X_SHAPE;
        }
        return powered ? CEILING_Z_POWERED_SHAPE : CEILING_Z_SHAPE;
    }

    public boolean method_9516(class_2680 $$0, class_1922 $$1, class_2338 $$2, class_10 $$3) {
        return false;
    }

    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{POWERED});
        builder.method_11667(new class_2769[]{FACE});
        builder.method_11667(new class_2769[]{COLOR});
    }
}

