/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.defaulthp;

import com.yourname.defaulthp.DefaultHPCommand;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DefaultHP
extends JavaPlugin
implements Listener {
    private double defaultHealth;
    private boolean affectMaxHealth;
    private boolean setHealthOnRespawn;
    private boolean healToFullOnJoin;
    private String joinMessage;
    private boolean showJoinMessage;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("defaulthp").setExecutor(new DefaultHPCommand(this));
        this.getLogger().info("DefaultHP has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("DefaultHP has been disabled!");
    }

    public void loadConfig() {
        this.reloadConfig();
        this.defaultHealth = this.getConfig().getDouble("default-health", 18.0);
        this.affectMaxHealth = this.getConfig().getBoolean("affect-max-health", true);
        this.setHealthOnRespawn = this.getConfig().getBoolean("set-health-on-respawn", true);
        this.healToFullOnJoin = this.getConfig().getBoolean("heal-to-full-on-join", true);
        this.joinMessage = this.getConfig().getString("join-message", "&aYour health has been set to &c%health% &ahearts!");
        this.showJoinMessage = this.getConfig().getBoolean("show-join-message", true);
    }

    public void setPlayerDefaultHealth(Player player) {
        AttributeInstance maxHealthAttribute;
        if (this.affectMaxHealth && (maxHealthAttribute = player.getAttribute(Attribute.valueOf("GENERIC_MAX_HEALTH"))) != null) {
            maxHealthAttribute.setBaseValue(this.defaultHealth);
        }
        if (this.healToFullOnJoin) {
            maxHealthAttribute = player.getAttribute(Attribute.valueOf("GENERIC_MAX_HEALTH"));
            if (maxHealthAttribute != null) {
                player.setHealth(Math.min(this.defaultHealth, maxHealthAttribute.getValue()));
            } else {
                player.setHealth(Math.min(this.defaultHealth, 20.0));
            }
        }
        if (this.showJoinMessage && this.joinMessage != null && !this.joinMessage.isEmpty()) {
            String message = this.joinMessage.replace("%health%", String.valueOf(this.defaultHealth / 2.0));
            message = message.replace("&", "\u00a7");
            player.sendMessage(message);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> this.setPlayerDefaultHealth(player), 5L);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.setHealthOnRespawn) {
            Player player = event.getPlayer();
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> this.setPlayerDefaultHealth(player), 5L);
        }
    }

    public double getDefaultHealth() {
        return this.defaultHealth;
    }
}

