/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.deathchest;

import java.util.List;
import me.isaiah.deathchest.Config;
import me.isaiah.deathchest.IDropList;
import me.isaiah.deathchest.ILockableContainer;
import me.isaiah.fabricapi.entity.event.v0.ServerLivingEntityEvents_18;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathChestMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"DeathchestMod");

    public void onInitialize() {
        boolean is18;
        ModContainer mc = (ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get();
        Version ver = mc.getMetadata().getVersion();
        String mcver = ver.getFriendlyString();
        boolean bl = is18 = mcver.contains("1.18") || mcver.contains("1.17");
        if (is18) {
            ServerPlayerEvents.ALLOW_DEATH.register((entity, source, da) -> {
                if (entity instanceof class_3222) {
                    IDropList dlist = (IDropList)entity;
                    dlist.DC$set_check_drops(true);
                }
                return true;
            });
            ServerLivingEntityEvents_18.AFTER_DEATH.register((entity, source) -> this.after_death_evnt(entity, source));
        } else {
            ServerLivingEntityEvents.ALLOW_DEATH.register((entity, source, da) -> {
                if (entity instanceof class_3222) {
                    IDropList dlist = (IDropList)entity;
                    dlist.DC$set_check_drops(true);
                }
                return true;
            });
            ServerLivingEntityEvents.AFTER_DEATH.register((entity, source) -> this.after_death_evnt(entity, source));
        }
    }

    public class_3218 getWorldCompact(class_3222 player) {
        try {
            class_3218 world = (class_3218)player.method_5770();
            return world;
        }
        catch (NoSuchMethodError is1219) {
            return null;
        }
    }

    public void after_death_evnt(class_1309 entity, class_1282 source) {
        if (entity instanceof class_3222) {
            class_2586 eastBlockEntity;
            class_3222 plr = (class_3222)entity;
            IDropList dlist = (IDropList)plr;
            List<class_1542> list = dlist.DC$get_drops();
            if (list.size() == 0) {
                dlist.DC$get_drops().clear();
                dlist.DC$set_check_drops(false);
                return;
            }
            class_2338 pos = plr.method_24515();
            class_3218 world = plr.method_51469();
            world.method_8501(pos, class_2246.field_10034.method_9564());
            boolean doubleChest = dlist.DC$does_need_double_death_chest();
            class_2338 east = pos.method_10078();
            class_2680 state = class_2246.field_10034.method_9564();
            if (doubleChest) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12574));
                world.method_8501(east, (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12571));
            } else {
                world.method_8501(pos, Config.get_single_chest());
            }
            class_2586 blockEntity = world.method_8321(pos);
            class_2586 class_25862 = eastBlockEntity = doubleChest ? world.method_8321(east) : null;
            if (!(blockEntity instanceof class_2621) || doubleChest && !(eastBlockEntity instanceof class_2621)) {
                LOGGER.warn("Failed to place death chest at [{}] due to invalid block entity", (Object)pos);
                return;
            }
            class_2621 container = (class_2621)(doubleChest ? eastBlockEntity : blockEntity);
            for (int i = 0; i < list.size() && i < 27; ++i) {
                class_1799 stack = list.get(i).method_6983();
                container.method_5447(i, stack.method_7972());
            }
            if (doubleChest) {
                class_2621 west_container = (class_2621)blockEntity;
                for (int i = 27; i < list.size(); ++i) {
                    west_container.method_5447(i - 27, list.get(i).method_6983().method_7972());
                }
                this.set_chest_title(plr, west_container);
            }
            dlist.DC$get_drops().clear();
            dlist.DC$set_check_drops(false);
            this.set_chest_title(plr, container);
        }
    }

    public void set_chest_title(class_3222 plr, class_2621 container) {
        try {
            ILockableContainer con = (ILockableContainer)container;
            con.deathchest_mod$set_custom_name(class_2561.method_30163((String)Config.chest_title(plr)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

