/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.deathchest.mixin;

import java.util.List;
import java.util.Set;
import me.isaiah.deathchest.Config;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class DeathchestMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "me.isaiah.deathchest.mixin.";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"DCMixin");

    public String get_mc_ver() {
        ModContainer mc = (ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get();
        Version ver = mc.getMetadata().getVersion();
        String mcver = ver.getFriendlyString();
        return mcver;
    }

    public void onLoad(String mixinPackage) {
        LOGGER.info("Mixin Plugin Loaded. (MC: " + this.get_mc_ver() + ")");
    }

    public static void loadLibs() {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean is218_orHigher;
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        ModContainer mc = (ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get();
        Version ver = mc.getMetadata().getVersion();
        String mcver = ver.getFriendlyString();
        boolean is17 = mcver.contains("1.17");
        boolean is18 = mcver.contains("1.18");
        boolean is19 = mcver.contains("1.19");
        boolean is20 = mcver.contains("1.20");
        boolean is21or_lower = is17 || is18 || is19 || is20 || mcver.equalsIgnoreCase("1.21") || mcver.equalsIgnoreCase("1.21.1");
        boolean is214_orLower = is21or_lower || mcver.equalsIgnoreCase("1.21.3") || mcver.contains("1.21.4");
        boolean bl = is218_orHigher = !is214_orLower;
        if (mixin.contains("MixinPlayer") && !mixin.contains("MixinPlayer2")) {
            if (is218_orHigher) {
                if (mixin.contains("MixinPlayer_218")) {
                    return true;
                }
                if (mixin.contains("MixinPlayer")) {
                    return false;
                }
            } else if (mixin.contains("MixinPlayer_218")) {
                return false;
            }
            if (is214_orLower) {
                return mixin.contains("MixinPlayer_214");
            }
            if (mixin.contains("MixinPlayer_214")) {
                return false;
            }
        }
        if (mixin.contains("MixinEntityExplosionBehavior") || mixin.contains("MixinExplosionBehavior")) {
            if (is21or_lower) {
                return false;
            }
            boolean should = Config.protect_from_explosion();
            return should;
        }
        if (mixin.contains("MixinExplosion")) {
            if (!is21or_lower) {
                return false;
            }
            boolean should = Config.protect_from_explosion();
            return should;
        }
        if (mixin.contains("R1_18") || mixin.contains("MixinLivingEntity") || mixin.contains("MixinPlayer2")) {
            return is18;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String target, ClassNode targetClass, String mixinClass, IMixinInfo info) {
    }

    public void postApply(String targetClass, ClassNode target, String mixinClass, IMixinInfo info) {
    }
}

