/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.adastratoolsneo.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public abstract class OstrumItem
extends ArmorItem {
    public OstrumItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 15;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{4, 8, 9, 4})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 18;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of();
            }

            public String getName() {
                return "ostrum";
            }

            public float getToughness() {
                return 3.0f;
            }

            public float getKnockbackResistance() {
                return 0.5f;
            }
        }, type, properties);
    }

    public static class Boots
    extends OstrumItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/ostrum__layer_1.png";
        }
    }

    public static class Leggings
    extends OstrumItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/ostrum__layer_2.png";
        }
    }

    public static class Chestplate
    extends OstrumItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/ostrum__layer_1.png";
        }
    }

    public static class Helmet
    extends OstrumItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/ostrum__layer_1.png";
        }
    }
}

