/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.adastratoolsneo.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public abstract class DesheriteItem
extends ArmorItem {
    public DesheriteItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 15;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{4, 7, 9, 4})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 16;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of();
            }

            public String getName() {
                return "desherite";
            }

            public float getToughness() {
                return 3.5f;
            }

            public float getKnockbackResistance() {
                return 0.3f;
            }
        }, type, properties);
    }

    public static class Boots
    extends DesheriteItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/desherite__layer_1.png";
        }
    }

    public static class Leggings
    extends DesheriteItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/desherite__layer_2.png";
        }
    }

    public static class Chestplate
    extends DesheriteItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/desherite__layer_1.png";
        }
    }

    public static class Helmet
    extends DesheriteItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "ad_astra_tools_neo:textures/models/armor/desherite__layer_1.png";
        }
    }
}

