/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Commands;

import com.catadmirer.infuseSMP.Effects.Emerald;
import com.catadmirer.infuseSMP.Effects.Ender;
import com.catadmirer.infuseSMP.Effects.Feather;
import com.catadmirer.infuseSMP.Effects.Fire;
import com.catadmirer.infuseSMP.Effects.Frost;
import com.catadmirer.infuseSMP.Effects.Haste;
import com.catadmirer.infuseSMP.Effects.Heart;
import com.catadmirer.infuseSMP.Effects.Invisibility;
import com.catadmirer.infuseSMP.Effects.Ocean;
import com.catadmirer.infuseSMP.Effects.Regen;
import com.catadmirer.infuseSMP.Effects.Speed;
import com.catadmirer.infuseSMP.Effects.Strength;
import com.catadmirer.infuseSMP.Effects.Thunder;
import com.catadmirer.infuseSMP.ExtraEffects.Apophis;
import com.catadmirer.infuseSMP.ExtraEffects.Thief;
import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import com.catadmirer.infuseSMP.Managers.EffectMaps;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Abilities
implements CommandExecutor {
    private final Infuse plugin;
    private final Emerald emeraldAbility;
    private final Feather featherAbility;
    private final Fire fireAbility;
    private final Frost frostAbility;
    private final Haste hasteAbility;
    private final Heart heartAbility;
    private final Invisibility invisibilityAbility;
    private final Ocean oceanAbility;
    private final Regen regenAbility;
    private final Speed speedAbility;
    private final Strength strengthAbility;
    private final Thunder thunderAbility;
    private final Ender enderAbility;
    private final Apophis aphopis;
    private final Thief thiefAbility;
    private final CooldownManager cooldownManager = new CooldownManager();

    public Abilities(EffectManager trustManager, Infuse plugin) {
        this.plugin = plugin;
        this.emeraldAbility = new Emerald((Plugin)plugin);
        this.featherAbility = new Feather((Plugin)plugin, trustManager);
        this.fireAbility = new Fire((Plugin)plugin);
        this.frostAbility = new Frost(trustManager, plugin);
        this.hasteAbility = new Haste((Plugin)plugin);
        this.heartAbility = new Heart(plugin);
        this.invisibilityAbility = new Invisibility((Plugin)plugin, trustManager);
        this.oceanAbility = new Ocean((Plugin)plugin, trustManager);
        this.regenAbility = new Regen(plugin);
        this.speedAbility = new Speed((Plugin)plugin);
        this.strengthAbility = new Strength(plugin);
        this.thunderAbility = new Thunder(plugin, trustManager);
        this.enderAbility = new Ender(trustManager, plugin);
        this.aphopis = new Apophis(plugin);
        this.thiefAbility = new Thief(trustManager, plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String slot;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (label.contains("rspark")) {
            slot = "2";
        } else if (label.contains("lspark")) {
            slot = "1";
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid command.");
            return true;
        }
        String equippedHack = Infuse.getInstance().getEffectManager().getEffect(playerUUID, slot);
        if (equippedHack == null) {
            String msg = this.plugin.getMessages().getString("slot_empty", "&cYou don't have any effect equipped in slot %slot%.").replace("%slot%", slot);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
            return true;
        }
        String strippedHack = this.stripAllColors(equippedHack);
        Integer abilityId = EffectMaps.getEffectNumber(strippedHack = this.plugin.getEffectReversed(strippedHack));
        if (abilityId == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No valid ability found for the equipped effect.");
            return true;
        }
        switch (abilityId) {
            case 0: 
            case 1: {
                this.emeraldAbility.activateSpark(player);
                break;
            }
            case 2: 
            case 3: {
                this.featherAbility.activateSpark(player);
                break;
            }
            case 4: 
            case 5: {
                this.fireAbility.activateSpark(player);
                break;
            }
            case 6: 
            case 7: {
                this.frostAbility.activateSpark(player);
                break;
            }
            case 8: 
            case 9: {
                this.hasteAbility.activateSpark(player);
                break;
            }
            case 10: 
            case 11: {
                this.heartAbility.activateSpark(player);
                break;
            }
            case 12: 
            case 13: {
                this.invisibilityAbility.activateSpark(player);
                break;
            }
            case 14: 
            case 15: {
                this.oceanAbility.activateSpark(player);
                break;
            }
            case 16: 
            case 17: {
                this.regenAbility.activateSpark(player);
                break;
            }
            case 18: 
            case 19: {
                this.speedAbility.activateSpark(player);
                break;
            }
            case 20: 
            case 21: {
                this.strengthAbility.activateSpark(player);
                break;
            }
            case 22: 
            case 23: {
                this.thunderAbility.activateSpark(player);
                break;
            }
            case 24: {
                this.enderAbility.activateSpark(player);
                break;
            }
            case 25: {
                this.aphopis.activateSpark(player);
                break;
            }
            case 26: {
                this.enderAbility.activateSpark(player);
                break;
            }
            case 27: {
                this.aphopis.activateSpark(player);
                break;
            }
            case 28: {
                this.thiefAbility.activateSpark(player);
                break;
            }
            case 29: {
                this.thiefAbility.activateSpark(player);
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No valid ability found for the equipped effect.");
            }
        }
        return true;
    }

    public String stripAllColors(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\u00a7#[0-9a-fA-F]{6})|(\u00a7x(\u00a7[0-9a-fA-F]){6})|(\u00a7[0-9a-fk-orA-FK-OR])");
        return pattern.matcher(input).replaceAll("");
    }
}

