/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Commands;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.ApophisManager;
import com.catadmirer.infuseSMP.Managers.EffectMapping;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EquipEffect
implements Listener,
CommandExecutor {
    private ApophisManager aphopisCommand;

    public EquipEffect(ApophisManager aphopisCommand) {
        this.aphopisCommand = aphopisCommand;
    }

    @EventHandler
    public void onFIrstJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore() && ((Boolean)Infuse.getInstance().getCanfig("join_effects_enabled")).booleanValue()) {
            List effects = (List)Infuse.getInstance().getCanfig("join_effects");
            if (effects.isEmpty()) {
                return;
            }
            String chosenKey = (String)effects.get(new Random().nextInt(effects.size()));
            String effectName = Infuse.getInstance().getEffect(chosenKey);
            if (effectName == null) {
                return;
            }
            this.equipHack(player, effectName, "2");
        }
    }

    public void handleLegendaryHack(Player player, ItemStack item, String hackName) {
        if (!this.equipHack(player, hackName, "1") && !this.equipHack(player, hackName, "2")) {
            player.performCommand("rdrain");
            Bukkit.getScheduler().runTaskLater(Bukkit.getPluginManager().getPlugins()[0], () -> this.equipHack(player, hackName, "2"), 1L);
        }
    }

    private boolean equipHack(Player player, String hackName, String type) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), type);
        if (currentHack != null) {
            return false;
        }
        Infuse.getInstance().getEffectManager().setEffect(player.getUniqueId(), type, hackName);
        String var10001 = String.valueOf(ChatColor.GREEN);
        hackName = EquipEffect.applyHexColors(hackName);
        player.sendMessage(var10001 + "You have equipped " + hackName);
        this.consumeMainHandItem(player);
        return true;
    }

    public static String applyHexColors(String input) {
        String regex = "(#(?:[0-9a-fA-F]{6}))";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            String colorCode = net.md_5.bungee.api.ChatColor.of((String)hexCode).toString();
            matcher.appendReplacement(result, colorCode);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @EventHandler
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        EffectMapping hackMapping;
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        if (mainHandItem != null && mainHandItem.getType() != Material.AIR && (hackMapping = EffectMapping.fromItem(mainHandItem)) != null) {
            if (player.getInventory().firstEmpty() == -1) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your inventory is full! Make space before unequipping.");
            } else {
                this.handleLegendaryHack(player, mainHandItem, hackMapping.getHackName());
                this.consumeMainHandItem(player);
                String hackName = hackMapping.getHackName();
                if (hackName.equalsIgnoreCase(String.valueOf(ChatColor.DARK_PURPLE) + "Apohpis Effect") || hackName.equalsIgnoreCase(String.valueOf(ChatColor.DARK_PURPLE) + "Augmented Apohpis Effect")) {
                    this.aphopisCommand.disguiseAsAphopis(player);
                }
            }
        }
    }

    private void consumeMainHandItem(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)Infuse.getInstance(), () -> {
            ItemStack mainHandItem = player.getInventory().getItemInMainHand();
            if (mainHandItem != null && mainHandItem.getType() != Material.AIR) {
                if (mainHandItem.getAmount() > 1) {
                    mainHandItem.setAmount(mainHandItem.getAmount() - 1);
                } else {
                    player.getInventory().setItemInMainHand((ItemStack)null);
                }
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        File disguiseFile;
        Player player = event.getEntity();
        String hack1 = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), "1");
        String hack2 = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), "2");
        String dropMode = Infuse.getInstance().getConfig().getString("effect_drops", "Random");
        Random rand = new Random();
        switch (dropMode.toLowerCase()) {
            case "1": {
                if (hack1 == null) break;
                this.dropHackOnDeath(player, "1");
                break;
            }
            case "2": {
                if (hack2 == null) break;
                this.dropHackOnDeath(player, "2");
                break;
            }
            case "none": {
                break;
            }
            default: {
                if (hack1 != null && hack2 != null) {
                    String selectedHack = rand.nextBoolean() ? "1" : "2";
                    this.dropHackOnDeath(player, selectedHack);
                    break;
                }
                if (hack1 != null) {
                    this.dropHackOnDeath(player, "1");
                    break;
                }
                if (hack2 == null) break;
                this.dropHackOnDeath(player, "2");
            }
        }
        if ((disguiseFile = new File(Infuse.getInstance().getDataFolder(), "AphopisPlayers/" + String.valueOf(player.getUniqueId()) + ".yml")).exists()) {
            disguiseFile.delete();
            Infuse.getInstance().resetSkinWithoutKick(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        File disguiseFile = new File(Infuse.getInstance().getDataFolder(), "AphopisPlayers/" + String.valueOf(player.getUniqueId()) + ".yml");
        if (disguiseFile.exists()) {
            this.aphopisCommand.disguiseAsAphopis(player);
        }
    }

    private void dropHackOnDeath(Player player, String type) {
        String hackName = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), type);
        if (hackName != null) {
            Infuse.getInstance().getEffectManager().removeEffect(player.getUniqueId(), type);
            EffectMapping hackMapping = EffectMapping.fromHackName(hackName);
            if (hackMapping != null) {
                ItemStack item = hackMapping.createItem();
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        String hack1 = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), "1");
        String hack2 = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), "2");
        if (hack1 == null && hack2 == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have any effects equipped to swap.");
            return true;
        }
        Infuse.getInstance().getEffectManager().setEffect(player.getUniqueId(), "1", hack2);
        Infuse.getInstance().getEffectManager().setEffect(player.getUniqueId(), "2", hack1);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your Effects have been swapped.");
        return true;
    }
}

