/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Commands;

import com.catadmirer.infuseSMP.Effects.Augmented;
import com.catadmirer.infuseSMP.Effects.Ender;
import com.catadmirer.infuseSMP.Infuse;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Recipes
implements CommandExecutor,
Listener {
    private final Infuse plugin;
    private Map<String, Object[]> potionRecipes = new HashMap<String, Object[]>();

    public Recipes(Infuse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Recipes.openGUI(player);
            return true;
        }
        return false;
    }

    private static ItemStack createPotionWithModifiedLore(String potionName, int augmentedLimit, int regularLimit) {
        ItemMeta meta;
        Augmented augmented = new Augmented(Infuse.getInstance());
        ItemStack potionItem = null;
        switch (potionName) {
            case "emerald": {
                potionItem = augmented.createEME();
                break;
            }
            case "feather": {
                potionItem = augmented.createFEATHER();
                break;
            }
            case "fire": {
                potionItem = augmented.createFIRE();
                break;
            }
            case "end_first": {
                potionItem = Augmented.createENDER();
                break;
            }
            case "end_second": {
                potionItem = Ender.createEnderGem();
                break;
            }
            case "frost": {
                potionItem = augmented.createFROST();
                break;
            }
            case "haste": {
                potionItem = augmented.createHASTE();
                break;
            }
            case "heart": {
                potionItem = augmented.createHEART();
                break;
            }
            case "invis": {
                potionItem = augmented.createINVIS();
                break;
            }
            case "ocean": {
                potionItem = augmented.createOCEAN();
                break;
            }
            case "regen": {
                potionItem = augmented.createREGEN();
                break;
            }
            case "speed": {
                potionItem = augmented.createSPEED();
                break;
            }
            case "strength": {
                potionItem = augmented.createST();
                break;
            }
            case "thunder": {
                potionItem = augmented.createTHUNDER();
                break;
            }
            case "apophis": {
                potionItem = augmented.createAPH();
                break;
            }
            case "thief": {
                potionItem = augmented.createTHF();
            }
        }
        if (potionItem != null && (meta = potionItem.getItemMeta()) != null) {
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a77Augmented Limit: \u00a7b" + augmentedLimit)));
            lore.add((CallSite)((Object)("\u00a77Regular Limit: \u00a7b" + regularLimit)));
            meta.setLore(lore);
            potionItem.setItemMeta(meta);
        }
        return potionItem;
    }

    private ItemStack createPotion(String potionName) {
        Augmented augmented = new Augmented(this.plugin);
        ItemStack potionItem = null;
        switch (potionName) {
            case "emerald": {
                potionItem = augmented.createEME();
                break;
            }
            case "feather": {
                potionItem = augmented.createFEATHER();
                break;
            }
            case "fire": {
                potionItem = augmented.createFIRE();
                break;
            }
            case "end_first": {
                potionItem = Augmented.createENDER();
                break;
            }
            case "end_second": {
                potionItem = Ender.createEnderGem();
                break;
            }
            case "frost": {
                potionItem = augmented.createFROST();
                break;
            }
            case "haste": {
                potionItem = augmented.createHASTE();
                break;
            }
            case "heart": {
                potionItem = augmented.createHEART();
                break;
            }
            case "invis": {
                potionItem = augmented.createINVIS();
                break;
            }
            case "ocean": {
                potionItem = augmented.createOCEAN();
                break;
            }
            case "regen": {
                potionItem = augmented.createREGEN();
                break;
            }
            case "speed": {
                potionItem = augmented.createSPEED();
                break;
            }
            case "strength": {
                potionItem = augmented.createST();
                break;
            }
            case "thunder": {
                potionItem = augmented.createTHUNDER();
                break;
            }
            case "apophis": {
                potionItem = augmented.createAPH();
                break;
            }
            case "thief": {
                potionItem = augmented.createTHF();
            }
        }
        return potionItem;
    }

    public static void openGUI(Player player) {
        Map<String, Map<String, Integer>> craftLimits = Recipes.loadCraftLimitsFromConfig();
        Inventory gui = Bukkit.createInventory(null, (int)36, (String)"Potion Crafting");
        int[] customSlots = new int[]{1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33};
        int index = 0;
        for (String potionName : craftLimits.keySet()) {
            if (index >= customSlots.length) break;
            Map<String, Integer> limits = craftLimits.get(potionName);
            int augmentedLimit = limits.get("augmented_limit");
            int regularLimit = limits.get("regular_limit");
            ItemStack potion = Recipes.createPotionWithModifiedLore(potionName, augmentedLimit, regularLimit);
            gui.setItem(customSlots[index] - 1, potion);
            ++index;
        }
        Recipes.fillRemainingSlots(gui);
        player.openInventory(gui);
    }

    private static Map<String, Map<String, Integer>> loadCraftLimitsFromConfig() {
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
        for (String itemName : Arrays.asList("emerald", "feather", "fire", "end_first", "end_second", "frost", "haste", "heart", "invis", "ocean", "regen", "speed", "strength", "thunder", "apophis", "thief")) {
            HashMap<String, Integer> limits = new HashMap<String, Integer>();
            limits.put("augmented_limit", (Integer)Infuse.getInstance().getCanfig("craft_limits." + itemName + ".augmented_limit"));
            limits.put("regular_limit", (Integer)Infuse.getInstance().getCanfig("craft_limits." + itemName + ".regular_limit"));
            result.put(itemName, limits);
        }
        return result;
    }

    private static void fillRemainingSlots(Inventory inventory) {
        ItemStack stainedGlassPane = new ItemStack(Material.RED_STAINED_GLASS_PANE, 1);
        ItemMeta meta = stainedGlassPane.getItemMeta();
        meta.setDisplayName("\u00a77");
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, stainedGlassPane);
        }
    }

    @EventHandler
    public void onInventoryClick2(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Recipes")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Potion Crafting") && event.getCurrentItem() != null) {
            event.setCancelled(true);
            ItemStack clickedItem = event.getCurrentItem();
            Player player = (Player)event.getWhoClicked();
            if (clickedItem.getItemMeta() != null && clickedItem.getItemMeta().hasDisplayName()) {
                String clickedItemName = clickedItem.getItemMeta().getDisplayName().replace("\u00a76", "").toLowerCase().replace(" potion", "").replace(" ", "_");
                this.openRecipeGUI(player, clickedItem);
            }
        }
    }

    private void loadPotionRecipes() {
        File recipesFile = new File(this.plugin.getDataFolder(), "recipes.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipesFile);
        for (String potionName : config.getConfigurationSection("recipes").getKeys(false)) {
            if (!config.getBoolean("recipes." + potionName + ".enabled")) continue;
            List shape = config.getStringList("recipes." + potionName + ".shape");
            HashMap<Character, String> ingredients = new HashMap<Character, String>();
            for (String key : config.getConfigurationSection("recipes." + potionName + ".ingredients").getKeys(false)) {
                ingredients.put(Character.valueOf(key.charAt(0)), config.getString("recipes." + potionName + ".ingredients." + key));
            }
            this.potionRecipes.put(potionName, new Object[]{shape, ingredients});
        }
    }

    public void openRecipeGUI(Player player, ItemStack clickedItem) {
        String potionKey = this.getPotionKeyFromItem(clickedItem);
        if (potionKey == null) {
            player.sendMessage("\u00a7cNo recipe found for this potion.");
            return;
        }
        this.loadPotionRecipes();
        Object[] recipeData = this.potionRecipes.get(potionKey);
        if (recipeData == null) {
            player.sendMessage("Recipe is disabled/broken");
            return;
        }
        List shape = (List)recipeData[0];
        Map ingredients = (Map)recipeData[1];
        Inventory recipeGui = Bukkit.createInventory(null, (int)45, (String)"Recipes");
        int[] ingredientSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
        int slotIndex = 0;
        for (String row : shape) {
            for (char ch : row.toCharArray()) {
                Material material;
                String ingredientName = (String)ingredients.get(Character.valueOf(ch));
                if (ingredientName != null && (material = Material.getMaterial((String)ingredientName.toUpperCase())) != null) {
                    ItemStack ingredientItem = new ItemStack(material);
                    recipeGui.setItem(ingredientSlots[slotIndex], ingredientItem);
                }
                ++slotIndex;
            }
        }
        recipeGui.setItem(25, this.createPotion(potionKey));
        Recipes.fillRemainingSlots(recipeGui);
        player.closeInventory();
        player.openInventory(recipeGui);
    }

    private String getPotionKeyFromItem(ItemStack item) {
        Augmented augmented = new Augmented(this.plugin);
        if (augmented.ISST(item)) {
            return "strength";
        }
        if (Augmented.ISHEART(item)) {
            return "heart";
        }
        if (Augmented.ISREGEN(item)) {
            return "regen";
        }
        if (Augmented.ISINVIS(item)) {
            return "invis";
        }
        if (Augmented.ISEME(item)) {
            return "emerald";
        }
        if (Augmented.ISEND(item)) {
            return "end_first";
        }
        if (Ender.ISENDER(item)) {
            return "end_second";
        }
        if (augmented.ISSPEED(item)) {
            return "speed";
        }
        if (Augmented.ISHASTE(item)) {
            return "haste";
        }
        if (Augmented.ISFEATHER(item)) {
            return "feather";
        }
        if (Augmented.ISOCEAN(item)) {
            return "ocean";
        }
        if (Augmented.ISFROST(item)) {
            return "frost";
        }
        if (Augmented.ISFIRE(item)) {
            return "fire";
        }
        if (augmented.ISTHUNDER(item)) {
            return "thunder";
        }
        if (Augmented.ISAUGAPH(item)) {
            return "apophis";
        }
        if (Augmented.ISTHIEF(item)) {
            return "thief";
        }
        return null;
    }
}

