/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import com.catadmirer.infuseSMP.Particles.AlsoParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.WindCharge;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class Feather
implements Listener {
    private final Plugin plugin;
    private final Map<UUID, Integer> hitCounter = new HashMap<UUID, Integer>();
    private final Set<UUID> spark = new HashSet<UUID>();
    private final EffectManager trustManager;

    public Feather(Plugin plugin, EffectManager trustManager) {
        this.plugin = plugin;
        this.trustManager = trustManager;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void FeatherLand(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        double radius = 4.0;
        UUID playerUUID = player.getUniqueId();
        if (player.isOnGround() && CooldownManager.isEffectActive(playerUUID, "feathermace")) {
            CooldownManager.setDuration(playerUUID, "feathermace", 0L);
            Location loc = player.getLocation();
            World world = player.getWorld();
            Iterator var8 = player.getNearbyEntities(radius, radius, radius).iterator();
            while (true) {
                LivingEntity target;
                if (!var8.hasNext()) {
                    world.spawnParticle(Particle.CLOUD, loc, 50, 0.0, 0.0, 0.0, 2.0);
                    world.playSound(loc, Sound.ITEM_MACE_SMASH_GROUND_HEAVY, 1.5f, 1.0f);
                    Location anchor = player.getLocation();
                    Bukkit.getRegionScheduler().runDelayed((Plugin)Infuse.getInstance(), anchor, task -> {
                        if (player.isOnline()) {
                            Vector dashDirection = player.getEyeLocation().getDirection().normalize();
                            Vector launchVector = dashDirection.multiply(5);
                            player.setVelocity(launchVector);
                        }
                    }, 1L);
                    return;
                }
                Entity entity = (Entity)var8.next();
                if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).equals((Object)player) || target instanceof Player && this.isTeammate(player, (Player)target)) continue;
                int damage = 8;
                target.damage((double)damage);
                Vector knockback = new Vector(0, 1, 0);
                target.setVelocity(target.getVelocity().add(knockback));
                Location anchor = target.getLocation();
                LivingEntity finalTarget = target;
                Bukkit.getRegionScheduler().run((Plugin)Infuse.getInstance(), anchor, task -> finalTarget.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 80, 0, false, false, false)));
            }
        }
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(caster, player);
    }

    @EventHandler
    public void onPlayerHit(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event instanceof EntityDamageByEntityEvent) {
                EntityDamageByEntityEvent damageByEntityEvent = (EntityDamageByEntityEvent)event;
                if (!(damageByEntityEvent.getDamager() instanceof Player)) {
                    return;
                }
                Player target = (Player)damageByEntityEvent.getDamager();
                if (!this.hasImmortalHackEquipped(player, "1") && !this.hasImmortalHackEquipped(player, "2")) {
                    return;
                }
                if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                    return;
                }
                UUID uuid = player.getUniqueId();
                int count = this.hitCounter.getOrDefault(uuid, 0) + 1;
                this.hitCounter.put(uuid, count);
                if (count >= 10) {
                    this.hitCounter.put(uuid, 0);
                    target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 100, 2));
                    Location chargeLocation = player.getLocation().add(0.0, 1.0, 0.0);
                    WindCharge windCharge = (WindCharge)player.getWorld().spawn(chargeLocation, WindCharge.class);
                    Location targetLocation = player.getLocation().subtract(0.0, 1.0, 0.0);
                    Vector direction = targetLocation.toVector().subtract(chargeLocation.toVector()).normalize();
                    windCharge.setVelocity(direction.multiply(1));
                    windCharge.setShooter((ProjectileSource)player);
                    player.setVelocity(new Vector(0.0, 0.5, 0.0));
                }
            }
        }
    }

    @EventHandler
    public void onPlayerFallDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.FALL && (this.hasImmortalHackEquipped(player = (Player)event.getEntity(), "1") || this.hasImmortalHackEquipped(player, "2"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerRightClickWindcharge(PlayerInteractEvent event) {
        ItemStack item;
        Player player = event.getPlayer();
        if (!(!this.hasImmortalHackEquipped(player, "1") && !this.hasImmortalHackEquipped(player, "2") || (item = player.getInventory().getItemInMainHand()) == null || item.getType() != Material.WIND_CHARGE || player.hasCooldown(Material.WIND_CHARGE) || event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR)) {
            Location anchor = player.getLocation();
            Bukkit.getRegionScheduler().runDelayed(this.plugin, anchor, task -> player.setCooldown(Material.WIND_CHARGE, 5), 1L);
        }
    }

    @EventHandler
    public void onWindChargeLaunch(ProjectileLaunchEvent event) {
        WindCharge fireball;
        ProjectileSource var4;
        Projectile var3 = event.getEntity();
        if (var3 instanceof WindCharge && (var4 = (fireball = (WindCharge)var3).getShooter()) instanceof Player) {
            Player player = (Player)var4;
            Vector direction = player.getEyeLocation().getDirection().normalize().multiply(2);
            fireball.setVelocity(direction);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        double fallDistance;
        Player attacker;
        Entity var3 = event.getDamager();
        if (var3 instanceof Player && (this.hasImmortalHackEquipped(attacker = (Player)var3, "1") || this.hasImmortalHackEquipped(attacker, "2")) && (fallDistance = (double)attacker.getFallDistance()) >= 7.0) {
            attacker.getWorld().playSound(attacker.getLocation(), Sound.ITEM_MACE_SMASH_AIR, 1.0f, 1.0f);
            Location startLoc = attacker.getLocation();
            World world = startLoc.getWorld();
            Location particleLoc = event.getDamager().getLocation();
            world.spawnParticle(Particle.GUST_EMITTER_SMALL, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
            attacker.setVelocity(new Vector(0.0, 1.8, 0.0));
            double multiplier = 1.1;
            event.setDamage(event.getDamage() * multiplier);
        }
    }

    public static ItemStack createGlide() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getMessages().getString("feather.effect_name", "\u00a7#BEA3CAFeather Effect");
            gemName = Feather.applyHexColors(gemName);
            meta.setDisplayName(gemName);
            ArrayList<String> lore = new ArrayList<String>(Infuse.getInstance().getMessages().getStringList("feather.effect_lore"));
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, Feather.applyHexColors((String)lore.get(i)));
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setColor(Color.fromRGB((int)255, (int)255, (int)255));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(2));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    public static String applyHexColors(String input) {
        String regex = "(#(?:[0-9a-fA-F]{6}))";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            String colorCode = ChatColor.of((String)hexCode).toString();
            matcher.appendReplacement(result, colorCode);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private boolean hasImmortalHackEquipped(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName = Infuse.getInstance().getMessages().getString("feather.effect_name", "\u00a7fFeather Effect");
        String gemName2 = Infuse.getInstance().getMessages().getString("aug_feather.effect_name", "\u00a7fAugmented Feather Effect");
        return currentHack != null && (currentHack.equals(gemName) || currentHack.equals(gemName2));
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            boolean isLegendary = this.hasImmortalHackEquipped(player, "1");
            boolean isCommon = this.hasImmortalHackEquipped(player, "2");
            UUID playerUUID = player.getUniqueId();
            if (!CooldownManager.isOnCooldown(playerUUID, "feather") && (player.isSneaking() && isLegendary || !player.isSneaking() && isCommon)) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    public void activateSpark(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "feather")) {
            String gemName = Infuse.getInstance().getEffect("aug_feather");
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            AlsoParticles.spawnEffect(player, Color.fromRGB((int)190, (int)163, (int)202));
            Vector dashDirection = player.getEyeLocation().getDirection().normalize();
            Vector launchVector = dashDirection.multiply(0).setY(1);
            player.setVelocity(launchVector);
            player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 20, 10));
            boolean isAugmentedFeather = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && this.stripAllColors(Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(this.stripAllColors(gemName)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && this.stripAllColors(Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(this.stripAllColors(gemName));
            long featherDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("feather.cooldown.default")).longValue();
            long featherAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("feather.cooldown.augmented")).longValue();
            long featherCooldown = isAugmentedFeather ? featherAugmentedCooldown : featherDefaultCooldown;
            long featherDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("feather.duration.default")).longValue();
            long featherAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("feather.duration.augmented")).longValue();
            long featherDuration = isAugmentedFeather ? featherAugmentedDuration : featherDefaultDuration;
            CooldownManager.setDuration(playerUUID, "feather", featherDuration);
            CooldownManager.setCooldown(playerUUID, "feather", featherCooldown);
            Location anchor = player.getLocation();
            Bukkit.getRegionScheduler().runDelayed(this.plugin, anchor, task -> {
                if (player.isOnline()) {
                    CooldownManager.setDuration(playerUUID, "feathermace", 5L);
                }
            }, 10L);
            this.spark.add(playerUUID);
        }
    }

    public static boolean isInvincibilityGem(ItemStack item) {
        return item != null && item.getType() == Material.POTION && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 2;
    }

    public String stripAllColors(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\u00a7#[0-9a-fA-F]{6})|(\u00a7x(\u00a7[0-9a-fA-F]){6})|(\u00a7[0-9a-fk-orA-FK-OR])");
        return pattern.matcher(input).replaceAll("");
    }
}

