/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Frost
implements Listener {
    private final Set<UUID> frozenAttackers = new HashSet<UUID>();
    private final Map<UUID, Integer> meleeHitCounter = new HashMap<UUID, Integer>();
    private static final Set<Material> ICE_BLOCKS = EnumSet.of(Material.ICE, Material.PACKED_ICE, Material.BLUE_ICE);
    private EffectManager trustManager;
    private final Infuse plugin;

    public Frost(EffectManager trustManager, Infuse plugin) {
        this.plugin = plugin;
        this.trustManager = trustManager;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        new BukkitRunnable(){

            public void run() {
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (Frost.this.hasImmortalHackEquipped2((Player)player, "2") && !(player.getVelocity().lengthSquared() < 0.01) || Frost.this.hasImmortalHackEquipped2((Player)player, "1") && !(player.getVelocity().lengthSquared() < 0.01)) {
                        Frost.this.handleSwim((Player)player);
                        Material blockType = player.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType();
                        if (ICE_BLOCKS.contains(blockType)) {
                            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 30, 2, false, false));
                        }
                    }
                });
            }
        }.runTaskTimer((Plugin)plugin, 0L, 10L);
    }

    public static ItemStack createFrost() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("frost");
            meta.setDisplayName(gemName);
            List<String> lore = Infuse.getInstance().getEffectLore("frost");
            meta.setColor(Color.fromRGB((int)0, (int)255, (int)255));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(4));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    public void handleSwim(Player player) {
        boolean inFrost;
        boolean bl = inFrost = player.getLocation().getBlock().getType() == Material.POWDER_SNOW;
        if (inFrost) {
            player.setGliding(true);
        }
    }

    @EventHandler
    public void onCancelSwim(EntityToggleGlideEvent event) {
        boolean inFrost;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = inFrost = player.getLocation().getBlock().getType() == Material.POWDER_SNOW;
        if (!event.isGliding() && (inFrost && this.hasImmortalHackEquipped2(player, "1") || inFrost && this.hasImmortalHackEquipped2(player, "2"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        boolean inFrost = player.getLocation().getBlock().getType() == Material.POWDER_SNOW;
        Vector direction = player.getLocation().getDirection().normalize();
        if (inFrost && this.hasImmortalHackEquipped2(player, "1") || inFrost && this.hasImmortalHackEquipped2(player, "2")) {
            if (event.getFrom().distanceSquared(event.getTo()) < 0.01) {
                return;
            }
            double boostStrength = 0.6;
            Vector newVelocity = direction.multiply(boostStrength);
            player.setVelocity(newVelocity);
        }
    }

    public static boolean isStealthGem(ItemStack item) {
        if (item != null && item.getType() == Material.POTION && item.getItemMeta() != null) {
            return item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 4;
        }
        return false;
    }

    @EventHandler
    public void onPlayerInteractWithWindCharge(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && item.getType() == Material.WIND_CHARGE && player.getFreezeTicks() > 1) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMeleeHit(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player) {
            Player attacker = (Player)event.getDamager();
            final Player target = (Player)event.getEntity();
            if (this.hasImmortalHackEquipped2(attacker, "1") || this.hasImmortalHackEquipped2(attacker, "2")) {
                int count = this.meleeHitCounter.getOrDefault(attacker.getUniqueId(), 0) + 1;
                this.meleeHitCounter.put(attacker.getUniqueId(), count);
                if (count >= 20) {
                    this.meleeHitCounter.put(attacker.getUniqueId(), 0);
                    new BukkitRunnable(this){
                        int ticksElapsed = 0;
                        final int freezeDuration = 200;

                        public void run() {
                            if (this.ticksElapsed >= 200) {
                                target.setFreezeTicks(0);
                                this.cancel();
                            } else {
                                int currentFreezeTicks = target.getFreezeTicks();
                                target.setFreezeTicks(currentFreezeTicks + 2);
                                this.ticksElapsed += 2;
                            }
                        }
                    }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
                }
            }
        }
    }

    @EventHandler
    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            UUID playerUUID;
            boolean isCommon;
            boolean isLegendary = player.isSneaking() && this.hasImmortalHackEquipped2(player, "1");
            boolean bl = isCommon = !player.isSneaking() && this.hasImmortalHackEquipped2(player, "2");
            if ((isLegendary || isCommon) && !CooldownManager.isOnCooldown(playerUUID = player.getUniqueId(), "frost")) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    private boolean hasImmortalHackEquipped2(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName = Infuse.getInstance().getEffect("frost");
        String gemName2 = Infuse.getInstance().getEffect("aug_frost");
        return currentHack != null && currentHack.equals(gemName) || currentHack != null && currentHack.equals(gemName2);
    }

    public void activateSpark(final Player caster) {
        UUID playerUUID = caster.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "frost")) {
            String gemName = Infuse.getInstance().getEffect("aug_frost");
            caster.getWorld().playSound(caster.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            caster.addPotionEffect(new PotionEffect(PotionEffectType.UNLUCK, 300, 0));
            boolean isAugmentedFrost = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName));
            long frostDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("frost.cooldown.default")).longValue();
            long frostAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("frost.cooldown.augmented")).longValue();
            long frostCooldown = isAugmentedFrost ? frostAugmentedCooldown : frostDefaultCooldown;
            long frostDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("frost.duration.default")).longValue();
            long frostAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("frost.duration.augmented")).longValue();
            long frostDuration = isAugmentedFrost ? frostAugmentedDuration : frostDefaultDuration;
            CooldownManager.setDuration(playerUUID, "frost", frostDuration);
            CooldownManager.setCooldown(playerUUID, "frost", frostCooldown);
            Location center = caster.getLocation();
            double radius = 5.0;
            World world = caster.getWorld();
            final HashSet<Player> affectedPlayers = new HashSet<Player>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.equals((Object)caster) || this.isTeammate(player, caster) || !player.getWorld().equals((Object)world) || !(player.getLocation().distance(center) <= radius)) continue;
                affectedPlayers.add(player);
                AttributeInstance jumpAttribute = player.getAttribute(Attribute.GENERIC_JUMP_STRENGTH);
                if (jumpAttribute == null) continue;
                jumpAttribute.setBaseValue(0.1);
            }
            this.frozenAttackers.add(caster.getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    for (Player player : affectedPlayers) {
                        AttributeInstance jumpAttribute = player.getAttribute(Attribute.GENERIC_JUMP_STRENGTH);
                        if (jumpAttribute == null) continue;
                        jumpAttribute.setBaseValue(0.42);
                    }
                    Frost.this.frozenAttackers.remove(caster.getUniqueId());
                }
            }.runTaskLater((Plugin)this.plugin, frostDuration * 20L);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        AttributeInstance jumpAttribute = player.getAttribute(Attribute.GENERIC_JUMP_STRENGTH);
        if (jumpAttribute != null && jumpAttribute.getBaseValue() == 0.1) {
            jumpAttribute.setBaseValue(0.42);
        }
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        PotionEffect effect;
        Player attacker;
        if (event.getDamager() instanceof Player && (attacker = (Player)event.getDamager()).hasPotionEffect(PotionEffectType.UNLUCK) && (effect = attacker.getPotionEffect(PotionEffectType.UNLUCK)) != null && effect.getAmplifier() >= 0 && this.frozenAttackers.contains(attacker.getUniqueId()) && event.getEntity() instanceof Player) {
            Player target = (Player)event.getEntity();
            target.setFreezeTicks(200);
        }
    }
}

