/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Regen
implements Listener {
    private final Infuse plugin;

    public Regen(Infuse plugin) {
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public static boolean isInvincibilityGem(ItemStack item) {
        if (item != null && item.getType() == Material.POTION && item.getItemMeta() != null) {
            return item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 9;
        }
        return false;
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getDamager() instanceof Player && (this.hasRegenEquipped(player = (Player)event.getDamager(), "1") || this.hasRegenEquipped(player, "2"))) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 20, 1, false, false));
        }
    }

    @EventHandler
    public void onEntityDamageByEntityHeal(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (this.hasRegenEquipped(player = (Player)event.getEntity(), "1") || this.hasRegenEquipped(player, "2")) && event.getFinalDamage() <= 0.0) {
            player.setSaturation(Math.min(player.getSaturation() + 6.0f, 20.0f));
        }
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            UUID playerUUID;
            boolean isCommon;
            boolean isLegendary = player.isSneaking() && this.hasRegenEquipped(player, "1");
            boolean bl = isCommon = !player.isSneaking() && this.hasRegenEquipped(player, "2");
            if ((isLegendary || isCommon) && !CooldownManager.isOnCooldown(playerUUID = player.getUniqueId(), "regen")) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    private boolean hasRegenEquipped(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName = Infuse.getInstance().getEffect("regen");
        String gemName2 = this.plugin.getEffect("aug_regen");
        return currentHack != null && (currentHack.equals(gemName) || currentHack.equals(gemName2));
    }

    @EventHandler
    public void onEntityDamageByPlayer(EntityDamageByEntityEvent event) {
        Player damager;
        if (event.getDamager() instanceof Player && CooldownManager.isEffectActive((damager = (Player)event.getDamager()).getUniqueId(), "regen")) {
            double damage = event.getFinalDamage();
            damager.setHealth(Math.min(damager.getHealth() + damage / 2.0, damager.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
        }
    }

    public void activateSpark(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "regen")) {
            String gemName2 = this.plugin.getEffect("aug_regen");
            boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
            long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("regen.cooldown.default")).longValue();
            long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("regen.cooldown.augmented")).longValue();
            long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
            long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("regen.duration.default")).longValue();
            long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("regen.duration.augmented")).longValue();
            long duration = isAugmented ? augmentedDuration : defaultDuration;
            CooldownManager.setCooldown(playerUUID, "regen", cooldown);
            CooldownManager.setDuration(playerUUID, "regen", duration);
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        }
    }

    public static ItemStack createFake() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("regen");
            meta.setDisplayName(gemName);
            meta.setColor(Color.fromRGB((int)255, (int)0, (int)0));
            List<String> lore = Infuse.getInstance().getEffectLore("regen");
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(9));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }
}

