/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Particles.AlsoParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Speed
implements Listener {
    private final Plugin plugin;
    private final Map<UUID, Integer> speedLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastHitTime = new HashMap<UUID, Long>();
    private final Map<UUID, Long> bowPullStartTime = new HashMap<UUID, Long>();

    public Speed(Plugin plugin) {
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        new BukkitRunnable(){

            public void run() {
                Iterator var1 = Bukkit.getOnlinePlayers().iterator();
                while (var1.hasNext()) {
                    Player p = (Player)var1.next();
                    if (!Speed.this.hasSpeed(p, "1") && !Speed.this.hasSpeed(p, "2")) continue;
                    UUID uuid = p.getUniqueId();
                    long lastHit = Speed.this.lastHitTime.getOrDefault(uuid, 0L);
                    if (System.currentTimeMillis() - lastHit > 1000L) {
                        Speed.this.speedLevels.put(uuid, 1);
                    }
                    int currentLevel = Speed.this.speedLevels.getOrDefault(uuid, 1);
                    p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, Math.max(0, currentLevel - 1), false, false, false));
                }
                return;
            }
        }.runTaskTimer(plugin, 0L, 20L);
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        Player player;
        LivingEntity var3 = event.getEntity();
        if (var3 instanceof Player && (this.hasSpeed(player = (Player)var3, "1") || this.hasSpeed(player, "2"))) {
            long startTime = this.bowPullStartTime.getOrDefault(player.getUniqueId(), 0L);
            long pullTimeMs = System.currentTimeMillis() - startTime;
            double adjustedPullTimeMs = (double)pullTimeMs * 1.8;
            float pullFraction = (float)Math.min(adjustedPullTimeMs / 1000.0, 1.0);
            event.getProjectile().setVelocity(event.getProjectile().getVelocity().multiply(pullFraction));
            this.bowPullStartTime.remove(player.getUniqueId());
        }
    }

    public String stripAllColors(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\u00a7#[0-9a-fA-F]{6})|(\u00a7x(\u00a7[0-9a-fA-F]){6})|(\u00a7[0-9a-fk-orA-FK-OR])");
        return pattern.matcher(input).replaceAll("");
    }

    @EventHandler
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        Player player;
        Entity var3 = event.getDamager();
        if (var3 instanceof Player && (this.hasSpeed(player = (Player)var3, "1") || this.hasSpeed(player, "2"))) {
            long lastHit;
            UUID uuid = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastHit = this.lastHitTime.getOrDefault(uuid, 0L).longValue()) >= 50L) {
                this.lastHitTime.put(uuid, currentTime);
                this.speedLevels.put(uuid, this.speedLevels.getOrDefault(uuid, 1) + 1);
                Entity var9 = event.getEntity();
                if (var9 instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)var9;
                    int currentNoDamageTicks = target.getNoDamageTicks();
                    target.setNoDamageTicks(currentNoDamageTicks / 2);
                }
            }
        }
    }

    public static ItemStack createSPEED() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("speed");
            gemName = Speed.applyHexColors(gemName);
            meta.setDisplayName(gemName);
            meta.setColor(Color.AQUA);
            ArrayList<String> lore = new ArrayList<String>(Infuse.getInstance().getEffectLore("speed"));
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, Speed.applyHexColors((String)lore.get(i)));
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(10));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    public static String applyHexColors(String input) {
        String regex = "(#(?:[0-9a-fA-F]{6}))";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            String colorCode = ChatColor.of((String)hexCode).toString();
            matcher.appendReplacement(result, colorCode);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private boolean hasSpeed(Player player, String tier) {
        String gemName = Infuse.getInstance().getEffect("speed");
        String gemName2 = Infuse.getInstance().getEffect("aug_speed");
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        return currentHack != null && (currentHack.equals(gemName) || currentHack.equals(gemName2));
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            UUID playerUUID;
            boolean isCommon;
            boolean isLegendary = player.isSneaking() && this.hasImmortalHackEquipped2(player, "1");
            boolean bl = isCommon = !player.isSneaking() && this.hasImmortalHackEquipped2(player, "2");
            if ((isLegendary || isCommon) && !CooldownManager.isOnCooldown(playerUUID = player.getUniqueId(), "speed")) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    private boolean hasImmortalHackEquipped2(Player player, String tier) {
        String gemName = Infuse.getInstance().getEffect("speed");
        String gemName2 = Infuse.getInstance().getEffect("aug_speed");
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        return currentHack != null && (currentHack.equals(gemName) || currentHack.equals(gemName2));
    }

    public void activateSpark(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "speed")) {
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            AlsoParticles.spawnEffect(player, Color.fromRGB((int)209, (int)164, (int)75));
            Vector direction = player.getEyeLocation().getDirection().normalize();
            double dashMultiplier = (Double)Infuse.getInstance().getCanfig("speed.dashMultiplier");
            double playerVelocityMultiplier = (Double)Infuse.getInstance().getCanfig("speed.playerVelocityMultiplier");
            Vector dashVector = direction.clone().multiply(dashMultiplier);
            player.setVelocity(direction.clone().multiply(playerVelocityMultiplier));
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)230, (int)220, (int)170), 1.5f);
            Location[] previousLocation = new Location[]{player.getLocation().clone()};
            int[] ticksPassed = new int[]{0};
            Location anchor = player.getLocation();
            Bukkit.getRegionScheduler().runAtFixedRate(this.plugin, anchor, task -> {
                if (!player.isOnline()) {
                    task.cancel();
                    return;
                }
                Location currentLocation = player.getLocation();
                double distance = previousLocation[0].distance(currentLocation);
                if (distance > 0.1) {
                    Vector step = currentLocation.toVector().subtract(previousLocation[0].toVector()).normalize().multiply(0.3);
                    Location particleLocation = previousLocation[0].clone();
                    for (double d = 0.0; d <= distance; d += step.length()) {
                        particleLocation.add(step);
                        player.getWorld().spawnParticle(Particle.DUST, particleLocation, 5, 0.1, 0.05, 0.1, 0.05, (Object)dustOptions);
                    }
                    previousLocation[0] = currentLocation.clone();
                }
                if (ticksPassed[0] >= 3 && player.isOnGround()) {
                    task.cancel();
                }
                ticksPassed[0] = ticksPassed[0] + 1;
            }, 1L, 1L);
            long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("speed.duration.default")).longValue();
            CooldownManager.setDuration(playerUUID, "speed", defaultDuration);
            String gemName2 = Infuse.getInstance().getEffect("aug_speed");
            boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && this.stripAllColors(Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(this.stripAllColors(gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && this.stripAllColors(Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(this.stripAllColors(gemName2));
            long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("speed.cooldown.default")).longValue();
            long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("speed.cooldown.augmented")).longValue();
            long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
            CooldownManager.setCooldown(playerUUID, "speed", cooldown);
        }
    }

    public static boolean isInvincibilityGem(ItemStack item) {
        return item != null && item.getType() == Material.POTION && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 10;
    }
}

