/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;

public class Strength
implements Listener {
    private final Infuse plugin;

    public Strength(Infuse plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            UUID playerUUID;
            boolean isCommon;
            boolean isLegendary = player.isSneaking() && this.hasStrengthEquipped(player, "1");
            boolean bl = isCommon = !player.isSneaking() && this.hasStrengthEquipped(player, "2");
            if ((isLegendary || isCommon) && !CooldownManager.isOnCooldown(playerUUID = player.getUniqueId(), "strength")) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    private boolean hasStrengthEquipped(Player player, String tier) {
        String gemName = this.plugin.getEffect("strength");
        String gemName2 = this.plugin.getEffect("aug_strength");
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        return currentHack != null && currentHack.equals(gemName) || currentHack != null && currentHack.equals(gemName2);
    }

    public void activateSpark(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "strength")) {
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            String gemName2 = this.plugin.getEffect("aug_strength");
            boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2))) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2)));
            long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("strength.duration.default")).longValue();
            long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("strength.duration.augmented")).longValue();
            long duration = isAugmented ? augmentedDuration : defaultDuration;
            long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("strength.cooldown.default")).longValue();
            long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("strength.cooldown.augmented")).longValue();
            long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
            CooldownManager.setDuration(playerUUID, "strength", duration);
            CooldownManager.setCooldown(playerUUID, "strength", cooldown);
        }
    }

    @EventHandler
    public void extraDamage(EntityDamageByEntityEvent event) {
        Player attacker;
        Entity damager = event.getDamager();
        if (damager instanceof Player && (this.hasStrengthEquipped(attacker = (Player)damager, "1") || this.hasStrengthEquipped(attacker, "2"))) {
            double damage = event.getDamage();
            double health = attacker.getHealth();
            if (health < 2.0) {
                event.setDamage(damage + 3.0);
            } else if (health < 4.0) {
                event.setDamage(damage + 2.0);
            } else if (health < 6.0) {
                event.setDamage(damage + 1.0);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        Entity var3 = event.getDamager();
        if (var3 instanceof Player && CooldownManager.isEffectActive((player = (Player)var3).getUniqueId(), "strength") && !event.isCritical()) {
            double originalDamage = event.getDamage();
            double critDamage = originalDamage * 1.35;
            event.setDamage(critDamage);
            Entity hitEntity = event.getEntity();
            hitEntity.getWorld().playSound(hitEntity.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 1.0f);
            hitEntity.getWorld().spawnParticle(Particle.CRIT, hitEntity.getLocation().add(0.0, hitEntity.getHeight() / 2.0, 0.0), 10);
        }
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        LivingEntity var3 = event.getEntity();
        if (var3 instanceof Player) {
            Entity var4;
            Player player = (Player)var3;
            if ((event.getBow() != null && event.getBow().getType() == Material.BOW && this.hasStrengthEquipped(player, "1") || event.getBow() != null && event.getBow().getType() == Material.BOW && this.hasStrengthEquipped(player, "2")) && (var4 = event.getProjectile()) instanceof Arrow) {
                Arrow arrow = (Arrow)var4;
                arrow.setPierceLevel(100);
            }
        }
    }

    public static ItemStack createStealthGem() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("strength");
            meta.setDisplayName(gemName);
            meta.setColor(Color.fromRGB((int)139, (int)0, (int)0));
            List<String> lore = Infuse.getInstance().getEffectLore("strength");
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(11));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    @EventHandler
    public void onEntityDamageMob(EntityDamageByEntityEvent event) {
        Entity var3 = event.getDamager();
        if (var3 instanceof Player) {
            LivingEntity entity;
            Player attacker = (Player)var3;
            Entity var4 = event.getEntity();
            if (var4 instanceof LivingEntity && (!((entity = (LivingEntity)var4) instanceof Player) && this.hasStrengthEquipped(attacker, "1") || !(entity instanceof Player) && this.hasStrengthEquipped(attacker, "2"))) {
                double originalDamage = event.getDamage();
                event.setDamage(originalDamage * 2.0);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity2(EntityDamageByEntityEvent event) {
        Player attacker;
        Entity var5;
        Player player;
        ItemStack offHand;
        Entity var3 = event.getEntity();
        if (var3 instanceof Player && (offHand = (player = (Player)var3).getInventory().getItemInOffHand()).getType() == Material.SHIELD && player.isBlocking() && (var5 = event.getDamager()) instanceof Player && ((attacker = (Player)var5).getInventory().getItemInMainHand().getType().toString().endsWith("_AXE") && this.hasStrengthEquipped(attacker, "1") || attacker.getInventory().getItemInMainHand().getType().toString().endsWith("_AXE") && this.hasStrengthEquipped(attacker, "2"))) {
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_SHIELD_BREAK, 1.0f, 1.0f);
            Bukkit.getScheduler().runTaskLater((Plugin)Infuse.getInstance(), () -> this.stunShield(player), 20L);
        }
    }

    public static boolean isStealthGem(ItemStack item) {
        if (item != null && item.getType() == Material.POTION && item.getItemMeta() != null) {
            return item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 11;
        }
        return false;
    }

    private void stunShield(Player player) {
        player.setCooldown(Material.SHIELD, 200);
    }
}

