/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP;

import com.catadmirer.infuseSMP.Commands.Abilities;
import com.catadmirer.infuseSMP.Commands.ClearEffect;
import com.catadmirer.infuseSMP.Commands.DrainCommand;
import com.catadmirer.infuseSMP.Commands.EquipEffect;
import com.catadmirer.infuseSMP.Commands.GUI;
import com.catadmirer.infuseSMP.Commands.InfuseCommand;
import com.catadmirer.infuseSMP.Commands.Recipes;
import com.catadmirer.infuseSMP.Effects.Emerald;
import com.catadmirer.infuseSMP.Effects.Ender;
import com.catadmirer.infuseSMP.Effects.Feather;
import com.catadmirer.infuseSMP.Effects.Fire;
import com.catadmirer.infuseSMP.Effects.Frost;
import com.catadmirer.infuseSMP.Effects.Haste;
import com.catadmirer.infuseSMP.Effects.Heart;
import com.catadmirer.infuseSMP.Effects.Invisibility;
import com.catadmirer.infuseSMP.Effects.Ocean;
import com.catadmirer.infuseSMP.Effects.Regen;
import com.catadmirer.infuseSMP.Effects.Speed;
import com.catadmirer.infuseSMP.Effects.Strength;
import com.catadmirer.infuseSMP.Effects.Thunder;
import com.catadmirer.infuseSMP.ExtraEffects.Apophis;
import com.catadmirer.infuseSMP.ExtraEffects.Thief;
import com.catadmirer.infuseSMP.Managers.ActionBarUpdater;
import com.catadmirer.infuseSMP.Managers.ApophisManager;
import com.catadmirer.infuseSMP.Managers.Drop;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import com.catadmirer.infuseSMP.Managers.InfuseRecipeManager;
import com.catadmirer.infuseSMP.Particles.Particles;
import com.catadmirer.infuseSMP.Placeholders.InfusePlaceholders;
import com.catadmirer.infuseSMP.Trust.TrustCommand;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Infuse
extends JavaPlugin
implements Listener {
    private static Infuse instance;
    private final ConcurrentMap<UUID, String> hackManager = new ConcurrentHashMap<UUID, String>();
    private EffectManager hackManager2;
    private Abilities abilitiesHandler;
    private Particles particles;
    private final Map<UUID, PlayerProfile> originalProfiles = new HashMap<UUID, PlayerProfile>();
    private final Map<UUID, Integer> activeSkinModifiers = new HashMap<UUID, Integer>();
    private final Map<String, ItemStack> standardResults = new HashMap<String, ItemStack>();
    private final Map<String, ItemStack> firstTimeRewards = new HashMap<String, ItemStack>();
    private File aphopis;
    private EffectManager trustManager;
    private ApophisManager aphopisCommand;
    private FileConfiguration messages;
    private final Map<String, String> effects = new HashMap<String, String>();
    private final Map<String, List<String>> effectsLore = new HashMap<String, List<String>>();
    private final Map<String, Object> settings = new HashMap<String, Object>();
    private File messagesFile;

    public static Infuse getInstance() {
        return instance;
    }

    public void onEnable() {
        if (instance != null) {
            throw new IllegalStateException("Plugin already initialized!");
        }
        instance = this;
        this.saveDefaultConfig();
        this.loadMessages();
        this.settings.clear();
        this.settings.put("allow_infinite_effects", this.getConfig().getBoolean("allow_infinite_effects", false));
        this.settings.put("ritual_duration", this.getConfig().getInt("ritual_duration", 600));
        this.settings.put("ritual_duration_ender", this.getConfig().getInt("ritual_duration_ender", 3600));
        this.settings.put("brewing_particles", this.getConfig().getBoolean("brewing_particles", true));
        this.settings.put("empty_effect_icon", this.getConfig().getBoolean("empty_effect_icon", true));
        this.settings.put("player_head_drops", this.getConfig().getBoolean("player_head_drops", true));
        this.settings.put("enable_discord_broadcasts", this.getConfig().getBoolean("enable_discord_broadcasts", false));
        this.settings.put("discord_webhook_url", this.getConfig().getString("discord_webhook_url", ""));
        this.settings.put("invis_deaths", this.getConfig().getBoolean("invis_deaths", false));
        this.settings.put("brewing_gui", this.getConfig().getBoolean("brewing_gui", true));
        this.settings.put("join_effects_enabled", this.getConfig().getBoolean("join_effects_enabled", false));
        this.settings.put("join_effects", this.getConfig().getStringList("join_effects"));
        for (String key : this.getConfig().getConfigurationSection("craft_limits").getKeys(false)) {
            this.settings.put("craft_limits." + key + ".augmented_limit", this.getConfig().getInt("craft_limits." + key + ".augmented_limit", 0));
            this.settings.put("craft_limits." + key + ".regular_limit", this.getConfig().getInt("craft_limits." + key + ".regular_limit", 0));
        }
        for (String effect : new String[]{"invisibility", "apophis", "emerald", "ender", "feather", "fire", "frost", "haste", "heart", "ocean", "regen", "speed", "strength", "thunder", "thief"}) {
            if (!this.getConfig().isConfigurationSection(effect)) continue;
            if (this.getConfig().isConfigurationSection(effect + ".cooldown")) {
                this.settings.put(effect + ".cooldown.default", this.getConfig().getInt(effect + ".cooldown.default", 0));
                this.settings.put(effect + ".cooldown.augmented", this.getConfig().getInt(effect + ".cooldown.augmented", 0));
            }
            if (this.getConfig().isConfigurationSection(effect + ".duration")) {
                this.settings.put(effect + ".duration.default", this.getConfig().getInt(effect + ".duration.default", 0));
                this.settings.put(effect + ".duration.augmented", this.getConfig().getInt(effect + ".duration.augmented", 0));
            }
            if (!effect.equals("speed")) continue;
            this.settings.put("speed.dashMultiplier", this.getConfig().getDouble("speed.dashMultiplier", 20.0));
            this.settings.put("speed.playerVelocityMultiplier", this.getConfig().getDouble("speed.playerVelocityMultiplier", 2.0));
        }
        this.settings.put("ocean_pulling.pull.interval", this.getConfig().getInt("ocean_pulling.pull.interval", 20));
        this.settings.put("ocean_pulling.pull.radius", this.getConfig().getDouble("ocean_pulling.pull.radius", 5.0));
        this.settings.put("ocean_pulling.pull.strength", this.getConfig().getDouble("ocean_pulling.pull.strength", 0.3));
        this.settings.put("extra_effects.Apophis", this.getConfig().getBoolean("extra_effects.Apophis", false));
        this.settings.put("extra_effects.Thief", this.getConfig().getBoolean("extra_effects.Thief", false));
        this.settings.put("invis.kill_invis", this.getMessages().getString("invis.kill_invis"));
        this.settings.put("invis.death_invis", this.getMessages().getString("invis.death_invis"));
        this.effects.clear();
        this.effects.put("strength", this.getMessages().getString("strength.effect_name", "\u00a74Strength Effect"));
        this.effects.put("aug_strength", this.getMessages().getString("aug_strength.effect_name", "\u00a74Augmented Strength Effect"));
        this.effects.put("thunder", this.getMessages().getString("thunder.effect_name", "\u00a7eThunder Effect"));
        this.effects.put("aug_thunder", this.getMessages().getString("aug_thunder.effect_name", "\u00a7eAugmented Thunder Effect"));
        this.effects.put("speed", this.getMessages().getString("speed.effect_name", "\u00a7#E8BD74Speed Effect"));
        this.effects.put("aug_speed", this.getMessages().getString("aug_speed.effect_name", "\u00a7#E8BD74Augmented Speed Effect"));
        this.effects.put("regen", this.getMessages().getString("regen.effect_name", "\u00a7cRegeneration Effect"));
        this.effects.put("aug_regen", this.getMessages().getString("aug_regen.effect_name", "\u00a7cAugmented Regeneration Effect"));
        this.effects.put("ocean", this.getMessages().getString("ocean.effect_name", "\u00a79Ocean Effect"));
        this.effects.put("aug_ocean", this.getMessages().getString("aug_ocean.effect_name", "\u00a79Augmented Ocean Effect"));
        this.effects.put("invis", this.getMessages().getString("invisibility.effect_name", "\u00a75Invisibility Effect"));
        this.effects.put("aug_invis", this.getMessages().getString("aug_invisibility.effect_name", "\u00a75Augmented Invisibility Effect"));
        this.effects.put("heart", this.getMessages().getString("heart.effect_name", "\u00a7cHeart Effect"));
        this.effects.put("aug_heart", this.getMessages().getString("aug_heart.effect_name", "\u00a7cAugmented Heart Effect"));
        this.effects.put("haste", this.getMessages().getString("haste.effect_name", "\u00a76Haste Effect"));
        this.effects.put("aug_haste", this.getMessages().getString("aug_haste.effect_name", "\u00a76Augmented Haste Effect"));
        this.effects.put("frost", this.getMessages().getString("frost.effect_name", "\u00a7bFrost Effect"));
        this.effects.put("aug_frost", this.getMessages().getString("aug_frost.effect_name", "\u00a7bAugmented Frost Effect"));
        this.effects.put("fire", this.getMessages().getString("fire.effect_name", "\u00a7#E85720Fire Effect"));
        this.effects.put("aug_fire", this.getMessages().getString("aug_fire.effect_name", "\u00a7#E85720Augmented Fire Effect"));
        this.effects.put("feather", this.getMessages().getString("feather.effect_name", "\u00a7#BEA3CAFeather Effect"));
        this.effects.put("aug_feather", this.getMessages().getString("aug_feather.effect_name", "\u00a7#BEA3CAAugmented Feather Effect"));
        this.effects.put("ender", this.getMessages().getString("ender.effect_name", "\u00a75Ender Effect"));
        this.effects.put("aug_ender", this.getMessages().getString("aug_ender.effect_name", "\u00a75Augmented Ender Effect"));
        this.effects.put("emerald", this.getMessages().getString("emerald.effect_name", "\u00a7aEmerald Effect"));
        this.effects.put("aug_emerald", this.getMessages().getString("aug_emerald.effect_name", "\u00a7aAugmented Emerald Effect"));
        this.effects.put("apophis", this.getMessages().getString("apophis.effect_name", "\u00a75Apophis Effect"));
        this.effects.put("aug_apophis", this.getMessages().getString("aug_apophis.effect_name", "\u00a75Augmented Apophis Effect"));
        this.effects.put("thief", this.getMessages().getString("thief.effect_name", "\u00a74Thief Effect"));
        this.effects.put("aug_thief", this.getMessages().getString("aug_thief.effect_name", "\u00a74Augmented Thief Effect"));
        this.effectsLore.clear();
        this.effectsLore.put("strength", this.getMessages().getStringList("strength.effect_lore"));
        this.effectsLore.put("aug_strength", this.getMessages().getStringList("aug_strength.effect_lore"));
        this.effectsLore.put("thunder", this.getMessages().getStringList("thunder.effect_lore"));
        this.effectsLore.put("aug_thunder", this.getMessages().getStringList("aug_thunder.effect_lore"));
        this.effectsLore.put("speed", this.getMessages().getStringList("speed.effect_lore"));
        this.effectsLore.put("aug_speed", this.getMessages().getStringList("aug_speed.effect_lore"));
        this.effectsLore.put("regen", this.getMessages().getStringList("regen.effect_lore"));
        this.effectsLore.put("aug_regen", this.getMessages().getStringList("aug_regen.effect_lore"));
        this.effectsLore.put("ocean", this.getMessages().getStringList("ocean.effect_lore"));
        this.effectsLore.put("aug_ocean", this.getMessages().getStringList("aug_ocean.effect_lore"));
        this.effectsLore.put("invis", this.getMessages().getStringList("invisibility.effect_lore"));
        this.effectsLore.put("aug_invis", this.getMessages().getStringList("aug_invisibility.effect_lore"));
        this.effectsLore.put("heart", this.getMessages().getStringList("heart.effect_lore"));
        this.effectsLore.put("aug_heart", this.getMessages().getStringList("aug_heart.effect_lore"));
        this.effectsLore.put("haste", this.getMessages().getStringList("haste.effect_lore"));
        this.effectsLore.put("aug_haste", this.getMessages().getStringList("aug_haste.effect_lore"));
        this.effectsLore.put("frost", this.getMessages().getStringList("frost.effect_lore"));
        this.effectsLore.put("aug_frost", this.getMessages().getStringList("aug_frost.effect_lore"));
        this.effectsLore.put("fire", this.getMessages().getStringList("fire.effect_lore"));
        this.effectsLore.put("aug_fire", this.getMessages().getStringList("aug_fire.effect_lore"));
        this.effectsLore.put("feather", this.getMessages().getStringList("feather.effect_lore"));
        this.effectsLore.put("aug_feather", this.getMessages().getStringList("aug_feather.effect_lore"));
        this.effectsLore.put("ender", this.getMessages().getStringList("ender.effect_lore"));
        this.effectsLore.put("aug_ender", this.getMessages().getStringList("aug_ender.effect_lore"));
        this.effectsLore.put("emerald", this.getMessages().getStringList("emerald.effect_lore"));
        this.effectsLore.put("aug_emerald", this.getMessages().getStringList("aug_emerald.effect_lore"));
        this.effectsLore.put("apophis", this.getMessages().getStringList("apophis.effect_lore"));
        this.effectsLore.put("aug_apophis", this.getMessages().getStringList("aug_apophis.effect_lore"));
        this.effectsLore.put("thief", this.getMessages().getStringList("thief.effect_lore"));
        this.effectsLore.put("aug_thief", this.getMessages().getStringList("aug_thief.effect_lore"));
        PacketEvents.getAPI().init();
        this.aphopis = new ApophisManager(this, "AphopisPlayers/").getAphopisFile();
        this.aphopisCommand = new ApophisManager(this, "AphopisPlayers/");
        new InfuseRecipeManager(this);
        this.hackManager2 = new EffectManager(this.getDataFolder());
        this.trustManager = new EffectManager(this.getDataFolder());
        this.abilitiesHandler = new Abilities(this.trustManager, this);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new Invisibility((Plugin)this, this.trustManager), PacketListenerPriority.HIGHEST);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new Thief(this.trustManager, this), PacketListenerPriority.HIGHEST);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new Fire((Plugin)this), PacketListenerPriority.HIGHEST);
        this.registerCommands();
        this.checkForUpdate();
        this.registerEvents();
        new ActionBarUpdater(this).runTaskTimer((Plugin)this, 0L, 20L);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new InfusePlaceholders(this).register();
            this.getLogger().info("Placeholders Enabled!");
        } else {
            this.getLogger().warning("PlaceholderAPI is not installed, so custom placeholders won't work.");
        }
        this.getLogger().info("Infuse Plugin has been enabled!");
    }

    public <T> T getCanfig(String key) {
        return (T)this.settings.get(key);
    }

    public String getEffect(String key) {
        return this.effects.getOrDefault(key, "\u00a7cUnknown Effect");
    }

    public List<String> getEffectLore(String key) {
        return this.effectsLore.getOrDefault(key, Collections.singletonList("\u00a7cUnknown Effect"));
    }

    public void loadMessages() {
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadDaConfig(Player player) {
        this.reloadConfig();
        long start = System.nanoTime();
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.settings.clear();
        this.settings.put("allow_infinite_effects", this.getConfig().getBoolean("allow_infinite_effects", false));
        this.settings.put("ritual_duration", this.getConfig().getInt("ritual_duration", 600));
        this.settings.put("ritual_duration_ender", this.getConfig().getInt("ritual_duration_ender", 3600));
        this.settings.put("brewing_particles", this.getConfig().getBoolean("brewing_particles", true));
        this.settings.put("empty_effect_icon", this.getConfig().getBoolean("empty_effect_icon", true));
        this.settings.put("player_head_drops", this.getConfig().getBoolean("player_head_drops", true));
        this.settings.put("enable_discord_broadcasts", this.getConfig().getBoolean("enable_discord_broadcasts", false));
        this.settings.put("discord_webhook_url", this.getConfig().getString("discord_webhook_url", ""));
        this.settings.put("invis_deaths", this.getConfig().getBoolean("invis_deaths", false));
        this.settings.put("brewing_gui", this.getConfig().getBoolean("brewing_gui", true));
        this.settings.put("join_effects_enabled", this.getConfig().getBoolean("join_effects_enabled", false));
        this.settings.put("join_effects", this.getConfig().getStringList("join_effects"));
        for (String key : this.getConfig().getConfigurationSection("craft_limits").getKeys(false)) {
            this.settings.put("craft_limits." + key + ".augmented_limit", this.getConfig().getInt("craft_limits." + key + ".augmented_limit", 0));
            this.settings.put("craft_limits." + key + ".regular_limit", this.getConfig().getInt("craft_limits." + key + ".regular_limit", 0));
        }
        for (String effect : new String[]{"invisibility", "apophis", "emerald", "ender", "feather", "fire", "frost", "haste", "heart", "ocean", "regen", "speed", "strength", "thunder", "thief"}) {
            if (!this.getConfig().isConfigurationSection(effect)) continue;
            if (this.getConfig().isConfigurationSection(effect + ".cooldown")) {
                this.settings.put(effect + ".cooldown.default", this.getConfig().getInt(effect + ".cooldown.default", 0));
                this.settings.put(effect + ".cooldown.augmented", this.getConfig().getInt(effect + ".cooldown.augmented", 0));
            }
            if (this.getConfig().isConfigurationSection(effect + ".duration")) {
                this.settings.put(effect + ".duration.default", this.getConfig().getInt(effect + ".duration.default", 0));
                this.settings.put(effect + ".duration.augmented", this.getConfig().getInt(effect + ".duration.augmented", 0));
            }
            if (!effect.equals("speed")) continue;
            this.settings.put("speed.dashMultiplier", this.getConfig().getDouble("speed.dashMultiplier", 20.0));
            this.settings.put("speed.playerVelocityMultiplier", this.getConfig().getDouble("speed.playerVelocityMultiplier", 2.0));
        }
        this.settings.put("ocean_pulling.pull.interval", this.getConfig().getInt("ocean_pulling.pull.interval", 20));
        this.settings.put("ocean_pulling.pull.radius", this.getConfig().getDouble("ocean_pulling.pull.radius", 5.0));
        this.settings.put("ocean_pulling.pull.strength", this.getConfig().getDouble("ocean_pulling.pull.strength", 0.3));
        this.settings.put("extra_effects.Apophis", this.getConfig().getBoolean("extra_effects.Apophis", false));
        this.settings.put("extra_effects.Thief", this.getConfig().getBoolean("extra_effects.Thief", false));
        this.settings.put("invis.kill_invis", this.getMessages().getString("invis.kill_invis"));
        this.settings.put("invis.death_invis", this.getMessages().getString("invis.death_invis"));
        this.effects.clear();
        this.effects.put("strength", this.getMessages().getString("strength.effect_name", "\u00a74Strength Effect"));
        this.effects.put("aug_strength", this.getMessages().getString("aug_strength.effect_name", "\u00a74Augmented Strength Effect"));
        this.effects.put("thunder", this.getMessages().getString("thunder.effect_name", "\u00a7eThunder Effect"));
        this.effects.put("aug_thunder", this.getMessages().getString("aug_thunder.effect_name", "\u00a7eAugmented Thunder Effect"));
        this.effects.put("speed", this.getMessages().getString("speed.effect_name", "\u00a7#E8BD74Speed Effect"));
        this.effects.put("aug_speed", this.getMessages().getString("aug_speed.effect_name", "\u00a7#E8BD74Augmented Speed Effect"));
        this.effects.put("regen", this.getMessages().getString("regen.effect_name", "\u00a7cRegeneration Effect"));
        this.effects.put("aug_regen", this.getMessages().getString("aug_regen.effect_name", "\u00a7cAugmented Regeneration Effect"));
        this.effects.put("ocean", this.getMessages().getString("ocean.effect_name", "\u00a79Ocean Effect"));
        this.effects.put("aug_ocean", this.getMessages().getString("aug_ocean.effect_name", "\u00a79Augmented Ocean Effect"));
        this.effects.put("invis", this.getMessages().getString("invisibility.effect_name", "\u00a75Invisibility Effect"));
        this.effects.put("aug_invis", this.getMessages().getString("aug_invisibility.effect_name", "\u00a75Augmented Invisibility Effect"));
        this.effects.put("heart", this.getMessages().getString("heart.effect_name", "\u00a7cHeart Effect"));
        this.effects.put("aug_heart", this.getMessages().getString("aug_heart.effect_name", "\u00a7cAugmented Heart Effect"));
        this.effects.put("haste", this.getMessages().getString("haste.effect_name", "\u00a76Haste Effect"));
        this.effects.put("aug_haste", this.getMessages().getString("aug_haste.effect_name", "\u00a76Augmented Haste Effect"));
        this.effects.put("frost", this.getMessages().getString("frost.effect_name", "\u00a7bFrost Effect"));
        this.effects.put("aug_frost", this.getMessages().getString("aug_frost.effect_name", "\u00a7bAugmented Frost Effect"));
        this.effects.put("fire", this.getMessages().getString("fire.effect_name", "\u00a7#E85720Fire Effect"));
        this.effects.put("aug_fire", this.getMessages().getString("aug_fire.effect_name", "\u00a7#E85720Augmented Fire Effect"));
        this.effects.put("feather", this.getMessages().getString("feather.effect_name", "\u00a7#BEA3CAFeather Effect"));
        this.effects.put("aug_feather", this.getMessages().getString("aug_feather.effect_name", "\u00a7#BEA3CAAugmented Feather Effect"));
        this.effects.put("ender", this.getMessages().getString("ender.effect_name", "\u00a75Ender Effect"));
        this.effects.put("aug_ender", this.getMessages().getString("aug_ender.effect_name", "\u00a75Augmented Ender Effect"));
        this.effects.put("emerald", this.getMessages().getString("emerald.effect_name", "\u00a7aEmerald Effect"));
        this.effects.put("aug_emerald", this.getMessages().getString("aug_emerald.effect_name", "\u00a7aAugmented Emerald Effect"));
        this.effects.put("apophis", this.getMessages().getString("apophis.effect_name", "\u00a75Apophis Effect"));
        this.effects.put("aug_apophis", this.getMessages().getString("aug_apophis.effect_name", "\u00a75Augmented Apophis Effect"));
        this.effects.put("thief", this.getMessages().getString("thief.effect_name", "\u00a74Thief Effect"));
        this.effects.put("aug_thief", this.getMessages().getString("aug_thief.effect_name", "\u00a74Augmented Thief Effect"));
        this.effectsLore.clear();
        this.effectsLore.put("strength", this.getMessages().getStringList("strength.effect_lore"));
        this.effectsLore.put("aug_strength", this.getMessages().getStringList("aug_strength.effect_lore"));
        this.effectsLore.put("thunder", this.getMessages().getStringList("thunder.effect_lore"));
        this.effectsLore.put("aug_thunder", this.getMessages().getStringList("aug_thunder.effect_lore"));
        this.effectsLore.put("speed", this.getMessages().getStringList("speed.effect_lore"));
        this.effectsLore.put("aug_speed", this.getMessages().getStringList("aug_speed.effect_lore"));
        this.effectsLore.put("regen", this.getMessages().getStringList("regen.effect_lore"));
        this.effectsLore.put("aug_regen", this.getMessages().getStringList("aug_regen.effect_lore"));
        this.effectsLore.put("ocean", this.getMessages().getStringList("ocean.effect_lore"));
        this.effectsLore.put("aug_ocean", this.getMessages().getStringList("aug_ocean.effect_lore"));
        this.effectsLore.put("invis", this.getMessages().getStringList("invisibility.effect_lore"));
        this.effectsLore.put("aug_invis", this.getMessages().getStringList("aug_invisibility.effect_lore"));
        this.effectsLore.put("heart", this.getMessages().getStringList("heart.effect_lore"));
        this.effectsLore.put("aug_heart", this.getMessages().getStringList("aug_heart.effect_lore"));
        this.effectsLore.put("haste", this.getMessages().getStringList("haste.effect_lore"));
        this.effectsLore.put("aug_haste", this.getMessages().getStringList("aug_haste.effect_lore"));
        this.effectsLore.put("frost", this.getMessages().getStringList("frost.effect_lore"));
        this.effectsLore.put("aug_frost", this.getMessages().getStringList("aug_frost.effect_lore"));
        this.effectsLore.put("fire", this.getMessages().getStringList("fire.effect_lore"));
        this.effectsLore.put("aug_fire", this.getMessages().getStringList("aug_fire.effect_lore"));
        this.effectsLore.put("feather", this.getMessages().getStringList("feather.effect_lore"));
        this.effectsLore.put("aug_feather", this.getMessages().getStringList("aug_feather.effect_lore"));
        this.effectsLore.put("ender", this.getMessages().getStringList("ender.effect_lore"));
        this.effectsLore.put("aug_ender", this.getMessages().getStringList("aug_ender.effect_lore"));
        this.effectsLore.put("emerald", this.getMessages().getStringList("emerald.effect_lore"));
        this.effectsLore.put("aug_emerald", this.getMessages().getStringList("aug_emerald.effect_lore"));
        this.effectsLore.put("apophis", this.getMessages().getStringList("apophis.effect_lore"));
        this.effectsLore.put("aug_apophis", this.getMessages().getStringList("aug_apophis.effect_lore"));
        this.effectsLore.put("thief", this.getMessages().getStringList("thief.effect_lore"));
        this.effectsLore.put("aug_thief", this.getMessages().getStringList("aug_thief.effect_lore"));
        long duration = (System.nanoTime() - start) / 1000000L;
        player.sendMessage("\u00a7aInfuse reloaded in " + duration + "ms!");
    }

    public String getEffectReversed(String displayName) {
        String strippedName = this.stripAllColors(displayName);
        for (Map.Entry<String, String> entry : this.effects.entrySet()) {
            if (!this.stripAllColors(entry.getValue()).equalsIgnoreCase(strippedName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String stripAllColors(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\u00a7#[0-9a-fA-F]{6})|(\u00a7x(\u00a7[0-9a-fA-F]){6})|(\u00a7[0-9a-fk-orA-FK-OR])|(\ufffdx(\ufffd[0-9a-fA-F]){6})\ufffd");
        return pattern.matcher(input).replaceAll("");
    }

    private void registerCommands() {
        this.getCommand("trust").setExecutor((CommandExecutor)new TrustCommand(this, this.trustManager));
        this.getCommand("untrust").setExecutor((CommandExecutor)new TrustCommand(this, this.trustManager));
        this.getCommand("recipes").setExecutor((CommandExecutor)new Recipes(this));
        this.getCommand("swap").setExecutor((CommandExecutor)new EquipEffect(this.aphopisCommand));
        this.getCommand("infuse").setExecutor((CommandExecutor)new InfuseCommand());
        this.getCommand("infuse").setTabCompleter((TabCompleter)new InfuseCommand());
        this.getCommand("ldrain").setExecutor((CommandExecutor)new DrainCommand(this, this.aphopisCommand));
        this.getCommand("rdrain").setExecutor((CommandExecutor)new DrainCommand(this, this.aphopisCommand));
        this.getCommand("rspark").setExecutor((CommandExecutor)this.abilitiesHandler);
        this.getCommand("lspark").setExecutor((CommandExecutor)this.abilitiesHandler);
        this.getCommand("controls").setExecutor(new CommandExecutor(this){

            public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
                    return true;
                }
                Player player = (Player)sender;
                if (args.length != 1) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /controls <Offhand|Command>");
                    return true;
                }
                String choice = args[0];
                if (!choice.equals("Offhand") && !choice.equals("Command")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid option. Use 'Offhand' or 'Command'.");
                    return true;
                }
                EffectManager dataManager = Infuse.getInstance().getEffectManager();
                dataManager.setControlDefault(player.getUniqueId(), choice);
                boolean offhandEnabled = choice.equals("Offhand");
                player.addAttachment((Plugin)Infuse.getInstance(), "ability.use", !offhandEnabled);
                return true;
            }
        });
        this.getCommand("controls").setTabCompleter((sender, command, alias, args) -> {
            if (args.length == 1) {
                return Arrays.asList("Offhand", "Command").stream().filter(opt -> opt.startsWith(args[0])).collect(Collectors.toList());
            }
            return List.of();
        });
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        final Player player = event.getPlayer();
        new BukkitRunnable(this){

            public void run() {
                player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(20.0);
                player.setHealth(20.0);
            }
        }.runTaskLater((Plugin)this, 10L);
    }

    public void onDisable() {
        instance = null;
        this.getLogger().info("Infuse Plugin is disabling...");
        PacketEvents.getAPI().terminate();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntitiesByClass(EnderCrystal.class)) {
                entity.remove();
            }
        }
        this.hackManager.clear();
        this.getLogger().info("Infuse Plugin has been disabled!");
    }

    public EffectManager getEffectManager() {
        return this.hackManager2;
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new Strength(this), (Plugin)this);
        this.particles = new Particles();
        this.particles.startTask();
        Bukkit.getPluginManager().registerEvents((Listener)new GUI(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Drop(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Frost(this.trustManager, this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Invisibility((Plugin)this, this.trustManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Heart(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Recipes(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Emerald((Plugin)this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new EquipEffect(this.aphopisCommand), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Ocean((Plugin)this, this.trustManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getConfig().getBoolean("extra_effects.Apophis")) {
            this.getServer().getPluginManager().registerEvents((Listener)new Apophis(this), (Plugin)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new Regen(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Feather((Plugin)this, this.trustManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Thunder(this, this.trustManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Haste((Plugin)this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Speed((Plugin)this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Fire((Plugin)this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Ender(this.trustManager, this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ClearEffect(this, new EquipEffect(this.aphopisCommand)), (Plugin)this);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        boolean dropHead = this.getConfig().getBoolean("player_head_drops", true);
        if (dropHead) {
            ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
            player.getWorld().dropItem(player.getLocation(), playerHead);
        }
    }

    public void saveOriginalSkin(Player player) {
        UUID uuid = player.getUniqueId();
        if (!this.originalProfiles.containsKey(uuid)) {
            this.originalProfiles.put(uuid, player.getPlayerProfile());
        }
        this.activeSkinModifiers.put(uuid, this.activeSkinModifiers.getOrDefault(uuid, 0) + 1);
    }

    public void resetSkinWithoutKick(Player player) {
        UUID uuid = player.getUniqueId();
        int count = this.activeSkinModifiers.getOrDefault(uuid, 0) - 1;
        if (count <= 0) {
            PlayerProfile originalProfile = this.originalProfiles.get(uuid);
            if (originalProfile != null) {
                player.setPlayerProfile(originalProfile);
            }
            this.originalProfiles.remove(uuid);
            this.activeSkinModifiers.remove(uuid);
        } else {
            this.activeSkinModifiers.put(uuid, count);
        }
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Craft Limits")) {
            event.setCancelled(true);
        }
    }

    private void checkForUpdate() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String currentVersion = this.getDescription().getVersion();
                URL url = new URL("https://api.modrinth.com/v2/project/infusesmp/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "Infuse/" + currentVersion);
                connection.connect();
                if (connection.getResponseCode() != 200) {
                    this.getLogger().warning("Could not check for updates: HTTP " + connection.getResponseCode());
                    return;
                }
                JSONParser parser = new JSONParser();
                JSONArray versions = (JSONArray)parser.parse((Reader)new InputStreamReader(connection.getInputStream()));
                if (versions.isEmpty()) {
                    return;
                }
                JSONObject latest = (JSONObject)versions.get(0);
                String latestVersion = (String)latest.get((Object)"version_number");
                if (!latestVersion.equalsIgnoreCase(currentVersion)) {
                    String updateMessage = "A new version (" + latestVersion + ") is available! You are on " + currentVersion + " https://modrinth.com/plugin/infusesmp";
                    this.getLogger().info(ChatColor.stripColor((String)updateMessage));
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Failed to check for Infuse updates", e);
            }
        });
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        EffectManager dataManager = Infuse.getInstance().getEffectManager();
        String controlMode = dataManager.getControlDefault(player.getUniqueId());
        if (controlMode == null) {
            controlMode = "Offhand";
        }
        boolean offhandEnabled = controlMode.equalsIgnoreCase("Offhand");
        player.addAttachment((Plugin)Infuse.getInstance(), "ability.use", !offhandEnabled);
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Your ability mode is set to: " + controlMode);
        try {
            String currentVersion = this.getDescription().getVersion();
            URL url = new URL("https://api.modrinth.com/v2/project/infusesmp/version");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Infuse/" + currentVersion);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                player.sendMessage("Could not check for updates: HTTP " + connection.getResponseCode());
                return;
            }
            JSONParser parser = new JSONParser();
            JSONArray versions = (JSONArray)parser.parse((Reader)new InputStreamReader(connection.getInputStream()));
            if (versions.isEmpty()) {
                return;
            }
            JSONObject latest = (JSONObject)versions.get(0);
            String latestVersion = (String)latest.get((Object)"version_number");
            if (!latestVersion.equalsIgnoreCase(currentVersion)) {
                String updateMessage = String.valueOf(ChatColor.LIGHT_PURPLE) + "[Infuse] " + String.valueOf(ChatColor.GREEN) + "A new version (" + latestVersion + ") is available! " + String.valueOf(ChatColor.GRAY) + "You are on " + currentVersion + " " + String.valueOf(ChatColor.AQUA) + "https://modrinth.com/plugin/infusesmp";
                if (player.isOp()) {
                    player.sendMessage(updateMessage);
                }
            }
        }
        catch (Exception e) {
            player.sendMessage("Failed to check for Infuse updates" + String.valueOf(e));
        }
    }
}

