/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Managers;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectMaps;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBarUpdater
extends BukkitRunnable {
    private final Set<UUID> playersWithActiveEffects = new HashSet<UUID>();
    private Infuse plugin;

    public ActionBarUpdater(Infuse plugin) {
        this.plugin = plugin;
    }

    public String removeAug(String key) {
        if (key.startsWith("aug_")) {
            return key.substring(4);
        }
        return key;
    }

    public String stripAllColors(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\u00a7#[0-9a-fA-F]{6})|(\u00a7x(\u00a7[0-9a-fA-F]){6})|(\u00a7[0-9a-fk-orA-FK-OR])");
        return pattern.matcher(input).replaceAll("");
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String finalMessage;
            String stripped;
            String key;
            String legendaryHack;
            String stripped2;
            String key2;
            String commonHack;
            UUID uuid = player.getUniqueId();
            if (this.playersWithActiveEffects.contains(uuid)) continue;
            String firstTime = "";
            boolean emptyEffectIcon = (Boolean)Infuse.getInstance().getCanfig("empty_effect_icon");
            String firstEmoji = "";
            if (emptyEffectIcon) {
                firstEmoji = "\ue058";
            }
            if ((commonHack = Infuse.getInstance().getEffectManager().getEffect(uuid, "1")) != null && (key2 = this.removeAug(stripped2 = Infuse.getInstance().getEffectReversed(this.stripAllColors(commonHack)))) != null) {
                ChatColor color = EffectMaps.getColorEffect(stripped2);
                if (CooldownManager.isEffectActive(uuid, key2)) {
                    long timeLeft = CooldownManager.getEffectTimeLeft(uuid, key2) / 1000L;
                    firstTime = this.formatTime(timeLeft, color);
                    firstEmoji = EffectMaps.getActiveEffect(stripped2);
                } else if (CooldownManager.isOnCooldown(uuid, key2)) {
                    long timeLeft = CooldownManager.getCooldownTimeLeft(uuid, key2) / 1000L;
                    firstTime = this.formatTime(timeLeft, ChatColor.WHITE);
                    firstEmoji = EffectMaps.getCooldownEffect(stripped2);
                } else {
                    firstEmoji = EffectMaps.getCooldownEffect(stripped2);
                }
            }
            String secondTime = "";
            String secondEmoji = "";
            if (emptyEffectIcon) {
                secondEmoji = "\ue058";
            }
            if ((legendaryHack = Infuse.getInstance().getEffectManager().getEffect(uuid, "2")) != null && (key = this.removeAug(stripped = Infuse.getInstance().getEffectReversed(this.stripAllColors(legendaryHack)))) != null) {
                ChatColor color = EffectMaps.getColorEffect(stripped);
                if (CooldownManager.isEffectActive(uuid, key)) {
                    timeLeft = CooldownManager.getEffectTimeLeft(uuid, key) / 1000L;
                    secondTime = this.formatTime(timeLeft, color);
                    secondEmoji = EffectMaps.getActiveEffect(stripped);
                } else if (CooldownManager.isOnCooldown(uuid, key)) {
                    timeLeft = CooldownManager.getCooldownTimeLeft(uuid, key) / 1000L;
                    secondTime = this.formatTime(timeLeft, ChatColor.WHITE);
                    secondEmoji = EffectMaps.getCooldownEffect(stripped);
                } else {
                    secondEmoji = EffectMaps.getCooldownEffect(stripped);
                }
            }
            StringBuilder actionBar = new StringBuilder();
            if (!firstTime.isEmpty()) {
                actionBar.append(firstTime).append("  ");
            }
            if (!firstEmoji.isEmpty()) {
                actionBar.append(firstEmoji).append(" ");
            }
            if (!secondEmoji.isEmpty()) {
                actionBar.append(secondEmoji).append("  ");
            }
            if (!secondTime.isEmpty()) {
                actionBar.append(secondTime).append(" ");
            }
            if ((finalMessage = actionBar.toString().trim()).isEmpty()) continue;
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)finalMessage));
        }
    }

    private String formatTime(long totalSeconds, ChatColor color) {
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        String timeString = minutes + ":" + String.format("%02d", seconds);
        String var10000 = String.valueOf(color);
        return var10000 + String.valueOf(ChatColor.BOLD) + timeString + String.valueOf(ChatColor.RESET);
    }
}

