/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Managers;

import com.catadmirer.infuseSMP.Infuse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class EffectManager {
    private final File dataFile;
    private FileConfiguration config;
    private final Map<UUID, Set<UUID>> trustMap = new HashMap<UUID, Set<UUID>>();

    public EffectManager(File dataFolder) {
        boolean success;
        File oldFile = new File(dataFolder, "player_hacks.yml");
        this.dataFile = new File(dataFolder, "playerdata.yml");
        if (oldFile.exists() && !this.dataFile.exists() && !(success = oldFile.renameTo(this.dataFile))) {
            Infuse.getInstance().getLogger().warning("Failed to rename the file");
        }
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadTrustData();
    }

    public void addTrust(Player caster, Player trusted) {
        if (caster == null || trusted == null || caster.getUniqueId().equals(trusted.getUniqueId())) {
            return;
        }
        this.trustMap.computeIfAbsent(caster.getUniqueId(), k -> new HashSet()).add(trusted.getUniqueId());
        this.saveTrustData(caster.getUniqueId());
    }

    public void removeTrust(Player caster, Player trusted) {
        if (caster == null || trusted == null) {
            return;
        }
        Set<UUID> trustedSet = this.trustMap.get(caster.getUniqueId());
        if (trustedSet != null) {
            trustedSet.remove(trusted.getUniqueId());
            this.saveTrustData(caster.getUniqueId());
        }
    }

    public boolean isTrusted(Player personwhostrusted, Player person) {
        if (personwhostrusted == null || person == null) {
            return false;
        }
        if (personwhostrusted.getUniqueId().equals(person.getUniqueId())) {
            return true;
        }
        Set<UUID> trustedSet = this.trustMap.get(person.getUniqueId());
        return trustedSet != null && trustedSet.contains(personwhostrusted.getUniqueId());
    }

    private void loadTrustData() {
        this.trustMap.clear();
        for (String uuidStr : this.config.getKeys(false)) {
            List trustedUUIDStrings = this.config.getStringList(uuidStr + ".trust");
            HashSet<UUID> trustedSet = new HashSet<UUID>();
            for (String trustedUUIDStr : trustedUUIDStrings) {
                try {
                    trustedSet.add(UUID.fromString(trustedUUIDStr));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (trustedSet.isEmpty()) continue;
            try {
                this.trustMap.put(UUID.fromString(uuidStr), trustedSet);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void saveTrustData(UUID playerUUID) {
        Set trustedSet = this.trustMap.getOrDefault(playerUUID, new HashSet());
        List trustedList = trustedSet.stream().map(UUID::toString).collect(Collectors.toList());
        this.config.set(playerUUID.toString() + ".trust", trustedList);
        this.saveConfig();
    }

    public void setEffect(UUID playerUUID, String type, String value) {
        this.config.set(playerUUID.toString() + "." + type, (Object)value);
        this.saveConfig();
    }

    public String getEffect(UUID playerUUID, String type) {
        return this.config.getString(playerUUID.toString() + "." + type, null);
    }

    public void removeEffect(UUID playerUUID, String type) {
        this.config.set(playerUUID.toString() + "." + type, null);
        this.saveConfig();
    }

    public void setControlDefault(UUID playerUUID, String defaultMode) {
        this.config.set(playerUUID.toString() + ".Controls", (Object)defaultMode);
        this.saveConfig();
    }

    public String getControlDefault(UUID playerUUID) {
        return this.config.getString(playerUUID.toString() + ".Controls", "Offhand");
    }

    private void saveConfig() {
        try {
            this.config.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadTrustData();
    }
}

