/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Managers;

import com.catadmirer.infuseSMP.Effects.Augmented;
import com.catadmirer.infuseSMP.Effects.Emerald;
import com.catadmirer.infuseSMP.Effects.Ender;
import com.catadmirer.infuseSMP.Effects.Feather;
import com.catadmirer.infuseSMP.Effects.Fire;
import com.catadmirer.infuseSMP.Effects.Frost;
import com.catadmirer.infuseSMP.Effects.Haste;
import com.catadmirer.infuseSMP.Effects.Heart;
import com.catadmirer.infuseSMP.Effects.Invisibility;
import com.catadmirer.infuseSMP.Effects.Ocean;
import com.catadmirer.infuseSMP.Effects.Regen;
import com.catadmirer.infuseSMP.Effects.Speed;
import com.catadmirer.infuseSMP.Effects.Strength;
import com.catadmirer.infuseSMP.Effects.Thunder;
import com.catadmirer.infuseSMP.ExtraEffects.Apophis;
import com.catadmirer.infuseSMP.ExtraEffects.Thief;
import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BrewingStand;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InfuseRecipeManager
implements Listener {
    private final Infuse plugin;
    private final Map<String, ItemStack> firstTimeRewards;
    private final Map<String, ItemStack> standardResults;
    private BossBar activeBossBar;
    FileConfiguration recipesConfig;
    private boolean isRitualActive = false;
    private final Map<UUID, BrewingStand> brewingStandCache = new HashMap<UUID, BrewingStand>();

    public InfuseRecipeManager(Infuse plugin) {
        this.plugin = plugin;
        this.firstTimeRewards = new HashMap<String, ItemStack>();
        this.standardResults = new HashMap<String, ItemStack>();
        try {
            File recipesFile = new File(plugin.getDataFolder(), "recipes.yml");
            if (!recipesFile.exists()) {
                plugin.saveResource("recipes.yml", false);
            }
            this.recipesConfig = YamlConfiguration.loadConfiguration((File)recipesFile);
        }
        catch (Exception e) {
            plugin.getLogger().severe("Could not load recipes.yml!");
            e.printStackTrace();
            this.recipesConfig = null;
        }
        if (this.recipesConfig != null) {
            this.loadRecipes();
        } else {
            plugin.getLogger().warning("Recipes config is null.");
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadRecipes() {
        ConfigurationSection recipesSection = this.recipesConfig.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return;
        }
        block36: for (String recipeKey : recipesSection.getKeys(false)) {
            boolean enabled = recipesSection.getBoolean(recipeKey + ".enabled", false);
            if (!enabled) {
                this.plugin.getLogger().info("Recipe " + recipeKey + " is disabled in config, skipping.");
                continue;
            }
            switch (recipeKey.toLowerCase()) {
                case "emerald": {
                    this.Emerald();
                    continue block36;
                }
                case "feather": {
                    this.Feather();
                    continue block36;
                }
                case "fire": {
                    this.Fire();
                    continue block36;
                }
                case "frost": {
                    this.Frost();
                    continue block36;
                }
                case "haste": {
                    this.Haste();
                    continue block36;
                }
                case "heart": {
                    this.Heart();
                    continue block36;
                }
                case "invis": {
                    this.Invis();
                    continue block36;
                }
                case "ocean": {
                    this.Ocean();
                    continue block36;
                }
                case "regen": {
                    this.Regen();
                    continue block36;
                }
                case "speed": {
                    this.Speed();
                    continue block36;
                }
                case "strength": {
                    this.Strength();
                    continue block36;
                }
                case "thunder": {
                    this.Thunder();
                    continue block36;
                }
                case "end_first": {
                    this.Ender();
                    continue block36;
                }
                case "end_second": {
                    continue block36;
                }
                case "apophis": {
                    this.Aphopis();
                    continue block36;
                }
                case "thief": {
                    this.Thief();
                    continue block36;
                }
            }
            this.plugin.getLogger().warning("Unknown recipe key: " + recipeKey);
        }
    }

    private void spawnCustomBeam(Location brewingStandLocation, String recipeKey) {
        if (((Boolean)Infuse.getInstance().getCanfig("brewing_particles")).booleanValue()) {
            World world = brewingStandLocation.getWorld();
            Location crystalLoc = new Location(world, brewingStandLocation.getX(), -5000.0, brewingStandLocation.getZ());
            final EnderCrystal crystal = (EnderCrystal)world.spawnEntity(crystalLoc, EntityType.END_CRYSTAL);
            crystal.setShowingBottom(false);
            crystal.setInvulnerable(true);
            crystal.setInvisible(true);
            Location targetLoc = brewingStandLocation.clone().add(0.0, 600.0 - brewingStandLocation.getY(), 0.0);
            final ArmorStand marker = (ArmorStand)world.spawnEntity(targetLoc, EntityType.ARMOR_STAND);
            marker.setMarker(true);
            marker.setInvisible(true);
            marker.setInvulnerable(true);
            marker.setSilent(true);
            marker.setCustomNameVisible(false);
            crystal.setBeamTarget(marker.getLocation().toBlockLocation());
            int ritualDuration = recipeKey.equalsIgnoreCase("end_first") ? ((Integer)Infuse.getInstance().getCanfig("ritual_duration_ender")).intValue() : ((Integer)Infuse.getInstance().getCanfig("ritual_duration")).intValue();
            new BukkitRunnable(this){

                public void run() {
                    if (!crystal.isDead()) {
                        crystal.remove();
                    }
                    if (!marker.isDead()) {
                        marker.remove();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)ritualDuration * 20L);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.activeBossBar != null) {
            this.activeBossBar.addPlayer(event.getPlayer());
        }
    }

    private void startRitual(Player player, String recipeKey, Location playerLocation, final ItemStack craftedItem) {
        String webhookUrl;
        if (this.isRitualActive) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "A ritual is already in progress!");
            return;
        }
        final Location brewingStandLocation = this.findNearestBrewingStand(playerLocation);
        if (brewingStandLocation == null) {
            String invalidMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessages().getString("effect_nobrewing", "&cYou need to craft this in a brewing stand!"));
            player.sendMessage(invalidMessage);
            return;
        }
        this.isRitualActive = true;
        final String itemName = craftedItem.getItemMeta().getDisplayName();
        String updatedItemName = itemName.replace("Effect", "");
        BarColor barColor = this.getColorFromItemName(recipeKey);
        String lastColors = ChatColor.getLastColors((String)itemName);
        ChatColor itemColor = lastColors.isEmpty() ? ChatColor.WHITE : ChatColor.getByChar((char)lastColors.charAt(1));
        String formattedItemName = String.valueOf(itemColor) + "\ud83e\uddea " + String.valueOf(ChatColor.BOLD) + itemName + " \ud83e\uddea";
        this.activeBossBar = Bukkit.createBossBar((String)formattedItemName, (BarColor)barColor, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.activeBossBar.addPlayer(p);
        }
        String worldName = brewingStandLocation.getWorld().getName();
        String dimensionMessage = worldName.equalsIgnoreCase("world") ? String.valueOf(ChatColor.GREEN) + "Overworld" : (worldName.equalsIgnoreCase("world_end") || worldName.equalsIgnoreCase("world_the_end") ? String.valueOf(ChatColor.DARK_PURPLE) + "End" : (worldName.equalsIgnoreCase("world_nether") || worldName.equalsIgnoreCase("world_the_nether") ? String.valueOf(ChatColor.DARK_RED) + "Nether" : String.valueOf(ChatColor.GRAY) + worldName));
        String messageTemplate = this.plugin.getMessages().getString("effect_broadcast");
        String discordTemplate = this.plugin.getMessages().getString("discord_broadcast");
        String x = String.valueOf(brewingStandLocation.getBlockX());
        String y = String.valueOf(brewingStandLocation.getBlockY());
        String z = String.valueOf(brewingStandLocation.getBlockZ());
        String formattedMessage = messageTemplate.replace("%player%", player.getName()).replace("%item%", itemName).replace("%x%", x).replace("%y%", y).replace("%z%", z).replace("%dimension%", dimensionMessage);
        String formattedDiscordMessage = discordTemplate.replace("%player%", player.getName()).replace("%item%", ChatColor.stripColor((String)itemName)).replace("%x%", x).replace("%y%", y).replace("%z%", z).replace("%dimension%", ChatColor.stripColor((String)dimensionMessage));
        Bukkit.broadcastMessage((String)formattedMessage);
        if (((Boolean)Infuse.getInstance().getCanfig("enable_discord_broadcasts")).booleanValue()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("discord bcast " + formattedDiscordMessage));
        }
        if ((webhookUrl = (String)Infuse.getInstance().getCanfig("discord_webhook_url")) != null && !webhookUrl.isEmpty()) {
            this.sendToDiscord(webhookUrl, formattedDiscordMessage);
        }
        this.spawnCustomBeam(brewingStandLocation, recipeKey);
        final int ritualDuration = recipeKey.equalsIgnoreCase("end_first") ? ((Integer)Infuse.getInstance().getCanfig("ritual_duration_ender")).intValue() : ((Integer)Infuse.getInstance().getCanfig("ritual_duration")).intValue();
        new BukkitRunnable(){
            double progress = 1.0;
            final double progressDecrement = 1.0 / (double)(ritualDuration * 20);

            public void run() {
                if (this.progress <= 0.0) {
                    InfuseRecipeManager.this.activeBossBar.removeAll();
                    String finishedTemplate = InfuseRecipeManager.this.plugin.getMessages().getString("effect_finished", "%item% has been brewed!");
                    String finishedMessage = finishedTemplate.replace("%item%", itemName);
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.WHITE) + finishedMessage));
                    brewingStandLocation.getWorld().dropItemNaturally(brewingStandLocation, craftedItem);
                    InfuseRecipeManager.this.isRitualActive = false;
                    this.cancel();
                } else {
                    this.progress -= this.progressDecrement;
                    InfuseRecipeManager.this.activeBossBar.setProgress(this.progress);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void sendToDiscord(String webhookUrl, String message) {
        try {
            String payload = "{\"content\": \"" + message + "\"}";
            URL url = new URL(webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = payload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                this.plugin.getLogger().info("Message sent to Discord!");
            } else {
                this.plugin.getLogger().info("Error sending message to Discord: " + responseCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Location findNearestBrewingStand(Location playerLocation) {
        World world = playerLocation.getWorld();
        Object nearestLocation = null;
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    Location checkLocation = playerLocation.clone().add((double)x, (double)y, (double)z);
                    if (world.getBlockAt(checkLocation).getType() != Material.BREWING_STAND) continue;
                    return checkLocation;
                }
            }
        }
        return null;
    }

    private BarColor getColorFromItemName(String itemName) {
        switch (itemName.toLowerCase()) {
            case "emerald": 
            case "aug_emerald": {
                return BarColor.GREEN;
            }
            case "haste": 
            case "aug_haste": {
                return BarColor.YELLOW;
            }
            case "heart": 
            case "aug_heart": {
                return BarColor.RED;
            }
            case "invis": 
            case "aug_invis": 
            case "end_first": 
            case "end_second": 
            case "apophis": 
            case "aug_apophis": {
                return BarColor.PURPLE;
            }
            case "frost": 
            case "aug_frost": {
                return BarColor.BLUE;
            }
            case "feather": 
            case "aug_feather": {
                return BarColor.WHITE;
            }
            case "thunder": 
            case "aug_thunder": {
                return BarColor.YELLOW;
            }
            case "speed": 
            case "aug_speed": {
                return BarColor.BLUE;
            }
            case "regen": 
            case "aug_regen": {
                return BarColor.RED;
            }
            case "ocean": 
            case "aug_ocean": {
                return BarColor.BLUE;
            }
            case "fire": 
            case "aug_fire": {
                return BarColor.RED;
            }
            case "strength": 
            case "aug_strength": 
            case "thief": 
            case "aug_thief": {
                return BarColor.RED;
            }
        }
        return BarColor.WHITE;
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        int endFirstAugLimit;
        if (!(event.getRecipe() instanceof ShapedRecipe)) {
            return;
        }
        ShapedRecipe shaped = (ShapedRecipe)event.getRecipe();
        String recipeKey = shaped.getKey().getKey();
        if (!this.firstTimeRewards.containsKey(recipeKey) && !this.standardResults.containsKey(recipeKey)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (recipeKey.equals("end_second") && (endFirstAugLimit = ((Integer)Infuse.getInstance().getCanfig("craft_limits.end_first.augmented_limit")).intValue()) > 0) {
            event.setCancelled(true);
            return;
        }
        if (event.isShiftClick()) {
            event.setCancelled(true);
            return;
        }
        Inventory topInv = event.getView().getTopInventory();
        if (topInv.getType() != InventoryType.WORKBENCH) {
            event.setCancelled(true);
            return;
        }
        if (!this.isNearBrewingStand(player.getLocation())) {
            event.setCancelled(true);
            return;
        }
        Number augmentedLimitNumber = (Number)this.plugin.getCanfig("craft_limits." + recipeKey + ".augmented_limit");
        Number regularLimitNumber = (Number)this.plugin.getCanfig("craft_limits." + recipeKey + ".regular_limit");
        if (augmentedLimitNumber == null || regularLimitNumber == null) {
            event.setCancelled(true);
            return;
        }
        int augmentedLimit = augmentedLimitNumber.intValue();
        int regularLimit = regularLimitNumber.intValue();
        boolean allowInfinite = (Boolean)Infuse.getInstance().getCanfig("allow_infinite_effects");
        ItemStack result = event.getCurrentItem();
        if (result == null) {
            event.setCancelled(true);
            return;
        }
        ItemStack augmentedItem = this.firstTimeRewards.get(recipeKey);
        ItemStack regularItem = this.standardResults.get(recipeKey);
        boolean isAugmented = result.isSimilar(augmentedItem);
        if (isAugmented) {
            if (this.isRitualActive) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "A ritual is already in progress!");
                event.setCancelled(true);
                return;
            }
            if (augmentedLimit <= 0 && !allowInfinite) {
                event.setCancelled(true);
                return;
            }
            CraftingInventory inv = event.getInventory();
            ItemStack[] matrix = inv.getMatrix();
            for (int i = 0; i < matrix.length; ++i) {
                if (matrix[i] == null || matrix[i].getType() == Material.AIR) continue;
                int newAmt = matrix[i].getAmount() - 1;
                matrix[i] = newAmt > 0 ? new ItemStack(matrix[i].getType(), newAmt) : null;
            }
            inv.setMatrix(matrix);
            player.updateInventory();
            player.closeInventory();
            if (!allowInfinite) {
                this.plugin.getConfig().set("craft_limits." + recipeKey + ".augmented_limit", (Object)(augmentedLimit - 1));
                this.plugin.saveConfig();
            }
            this.startRitual(player, recipeKey, player.getLocation(), augmentedItem);
            event.setCancelled(true);
        } else {
            if (regularLimit <= 0 && !allowInfinite) {
                event.setCancelled(true);
                return;
            }
            if (!allowInfinite) {
                this.plugin.getConfig().set("craft_limits." + recipeKey + ".regular_limit", (Object)(regularLimit - 1));
                this.plugin.saveConfig();
            }
        }
    }

    private void registerRecipeFromConfig(String recipeKey, ItemStack result) {
        FileConfiguration config = this.recipesConfig;
        String basePath = "recipes." + recipeKey;
        if (!config.getBoolean(basePath + ".enabled", false)) {
            this.plugin.getLogger().info("Recipe " + recipeKey + " is disabled in config, skipping.");
            return;
        }
        List shape = config.getStringList(basePath + ".shape");
        if (shape.isEmpty()) {
            this.plugin.getLogger().warning("Recipe shape is missing for " + recipeKey);
            return;
        }
        ConfigurationSection ingredientsSection = config.getConfigurationSection(basePath + ".ingredients");
        if (ingredientsSection == null) {
            this.plugin.getLogger().warning("Ingredients section missing for recipe " + recipeKey);
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, recipeKey);
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(shape.toArray(new String[0]));
        for (String charKey : ingredientsSection.getKeys(false)) {
            String matName = ingredientsSection.getString(charKey);
            try {
                Material mat = Material.valueOf((String)matName);
                recipe.setIngredient(charKey.charAt(0), mat);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material '" + matName + "' for recipe '" + recipeKey + "'");
                return;
            }
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.plugin.getLogger().info("Registered recipe: " + recipeKey);
    }

    @EventHandler
    public void onCrafter(CrafterCraftEvent event) {
        ItemStack result = event.getResult();
        if (result != null && result.getType() == Material.POTION) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        if (!(event.getRecipe() instanceof ShapedRecipe)) {
            return;
        }
        ShapedRecipe shaped = (ShapedRecipe)event.getRecipe();
        String recipeKey = shaped.getKey().getKey();
        if (!this.firstTimeRewards.containsKey(recipeKey) || !this.standardResults.containsKey(recipeKey)) {
            return;
        }
        Inventory topInv = event.getView().getTopInventory();
        Player player = (Player)event.getView().getPlayer();
        if (topInv.getType() != InventoryType.WORKBENCH) {
            event.getInventory().setResult(null);
            return;
        }
        if (!this.isNearBrewingStand(player.getLocation())) {
            event.getInventory().setResult(null);
            return;
        }
        boolean allowInfinite = (Boolean)Infuse.getInstance().getCanfig("allow_infinite_effects");
        Number augmentedLimitNumber = (Number)this.plugin.getCanfig("craft_limits." + recipeKey + ".augmented_limit");
        Number regularLimitNumber = (Number)this.plugin.getCanfig("craft_limits." + recipeKey + ".regular_limit");
        if (augmentedLimitNumber == null || regularLimitNumber == null) {
            event.getInventory().setResult(null);
            return;
        }
        int augmentedLimit = augmentedLimitNumber.intValue();
        int regularLimit = regularLimitNumber.intValue();
        if (allowInfinite || augmentedLimit > 0) {
            event.getInventory().setResult(this.firstTimeRewards.get(recipeKey));
        } else if (regularLimit > 0) {
            event.getInventory().setResult(this.standardResults.get(recipeKey));
        } else {
            event.getInventory().setResult(null);
        }
    }

    private boolean isNearBrewingStand(Location loc) {
        World world = loc.getWorld();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    if (world.getBlockAt(loc.clone().add((double)x, (double)y, (double)z)).getType() != Material.BREWING_STAND) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @EventHandler
    public void onBrewingStandInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.BREWING_STAND) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            if (((Boolean)this.plugin.getCanfig("brewing_gui")).booleanValue()) {
                Block block = event.getClickedBlock();
                BrewingStand stand = (BrewingStand)block.getState();
                this.brewingStandCache.put(player.getUniqueId(), stand);
                Inventory gui = Bukkit.createInventory(null, (int)27, (String)"Choose GUI");
                ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                ItemMeta fillerMeta = filler.getItemMeta();
                fillerMeta.setDisplayName(" ");
                filler.setItemMeta(fillerMeta);
                for (int i = 0; i < gui.getSize(); ++i) {
                    gui.setItem(i, filler);
                }
                ItemStack craftingItem = new ItemStack(Material.CRAFTING_TABLE);
                ItemMeta craftingMeta = craftingItem.getItemMeta();
                craftingMeta.setDisplayName("\u00a74Open Crafting");
                craftingItem.setItemMeta(craftingMeta);
                ItemStack brewingItem = new ItemStack(Material.BREWING_STAND);
                ItemMeta brewingMeta = brewingItem.getItemMeta();
                brewingMeta.setDisplayName("\u00a74Open Brewing");
                brewingItem.setItemMeta(brewingMeta);
                gui.setItem(11, craftingItem);
                gui.setItem(15, brewingItem);
                player.openInventory(gui);
            } else {
                player.openWorkbench(null, true);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Choose GUI")) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ItemStack clicked = event.getCurrentItem();
            if (clicked == null || !clicked.hasItemMeta()) {
                return;
            }
            String name = clicked.getItemMeta().getDisplayName();
            if (name.contains("Crafting")) {
                player.closeInventory();
                player.openWorkbench(null, true);
            } else if (name.contains("Brewing")) {
                player.closeInventory();
                BrewingStand stand = this.brewingStandCache.get(player.getUniqueId());
                if (stand != null) {
                    player.openInventory((Inventory)stand.getInventory());
                }
            }
        }
    }

    private void Emerald() {
        ItemStack firstTime = Augmented.createEME();
        ItemStack standard = Emerald.createInvincibilityGem();
        this.firstTimeRewards.put("emerald", firstTime);
        this.standardResults.put("emerald", standard);
        this.registerRecipeFromConfig("emerald", standard);
    }

    private void Feather() {
        ItemStack firstTime = Augmented.createFEATHER();
        ItemStack standard = Feather.createGlide();
        this.firstTimeRewards.put("feather", firstTime);
        this.standardResults.put("feather", standard);
        this.registerRecipeFromConfig("feather", standard);
    }

    private void Fire() {
        ItemStack firstTime = Augmented.createFIRE();
        ItemStack standard = Fire.createFIRE();
        this.firstTimeRewards.put("fire", firstTime);
        this.standardResults.put("fire", standard);
        this.registerRecipeFromConfig("fire", standard);
    }

    private void Ender() {
        ItemStack firstTime = Augmented.createENDER();
        ItemStack standard = Ender.createEnderGem();
        this.firstTimeRewards.put("end_first", firstTime);
        this.standardResults.put("end_second", standard);
        this.registerRecipeFromConfig("end_first", firstTime);
        this.registerRecipeFromConfig("end_second", standard);
    }

    private void Frost() {
        ItemStack firstTime = Augmented.createFROST();
        ItemStack standard = Frost.createFrost();
        this.firstTimeRewards.put("frost", firstTime);
        this.standardResults.put("frost", standard);
        this.registerRecipeFromConfig("frost", standard);
    }

    private void Haste() {
        ItemStack firstTime = Augmented.createHASTE();
        ItemStack standard = Haste.createFake();
        this.firstTimeRewards.put("haste", firstTime);
        this.standardResults.put("haste", standard);
        this.registerRecipeFromConfig("haste", standard);
    }

    private void Heart() {
        ItemStack firstTime = Augmented.createHEART();
        ItemStack standard = Heart.createHeart();
        this.firstTimeRewards.put("heart", firstTime);
        this.standardResults.put("heart", standard);
        this.registerRecipeFromConfig("heart", standard);
    }

    private void Invis() {
        ItemStack firstTime = Augmented.createINVIS();
        ItemStack standard = Invisibility.createStealthGem();
        this.firstTimeRewards.put("invis", firstTime);
        this.standardResults.put("invis", standard);
        this.registerRecipeFromConfig("invis", standard);
    }

    private void Ocean() {
        ItemStack firstTime = Augmented.createOCEAN();
        ItemStack standard = Ocean.createOcean();
        this.firstTimeRewards.put("ocean", firstTime);
        this.standardResults.put("ocean", standard);
        this.registerRecipeFromConfig("ocean", standard);
    }

    private void Regen() {
        ItemStack firstTime = Augmented.createREGEN();
        ItemStack standard = Regen.createFake();
        this.firstTimeRewards.put("regen", firstTime);
        this.standardResults.put("regen", standard);
        this.registerRecipeFromConfig("regen", standard);
    }

    private void Speed() {
        Augmented augmented = new Augmented(Infuse.getInstance());
        Speed speed = new Speed((Plugin)Infuse.getInstance());
        ItemStack firstTime = augmented.createSPEED();
        ItemStack standard = speed.createSPEED();
        this.firstTimeRewards.put("speed", firstTime);
        this.standardResults.put("speed", standard);
        this.registerRecipeFromConfig("speed", standard);
    }

    private void Strength() {
        Augmented augmented = new Augmented(Infuse.getInstance());
        Strength strength = new Strength(Infuse.getInstance());
        ItemStack firstTime = augmented.createST();
        ItemStack standard = strength.createStealthGem();
        this.firstTimeRewards.put("strength", firstTime);
        this.standardResults.put("strength", standard);
        this.registerRecipeFromConfig("strength", standard);
    }

    private void Thunder() {
        Augmented augmented = new Augmented(Infuse.getInstance());
        Thunder thunder = new Thunder(Infuse.getInstance(), new EffectManager(Infuse.getInstance().getDataFolder()));
        ItemStack firstTime = augmented.createTHUNDER();
        ItemStack standard = thunder.createTHUNDER();
        this.firstTimeRewards.put("thunder", firstTime);
        this.standardResults.put("thunder", standard);
        this.registerRecipeFromConfig("thunder", standard);
    }

    private void Aphopis() {
        ItemStack firstTime = Augmented.createAPH();
        ItemStack standard = Apophis.createAPH();
        this.firstTimeRewards.put("apophis", firstTime);
        this.standardResults.put("apophis", standard);
        this.registerRecipeFromConfig("apophis", standard);
    }

    private void Thief() {
        ItemStack firstTime = Augmented.createTHF();
        ItemStack standard = Thief.createTHF();
        this.firstTimeRewards.put("thief", firstTime);
        this.standardResults.put("thief", standard);
        this.registerRecipeFromConfig("thief", standard);
    }
}

