/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticframes.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticframes.item.ModItemGroups;
import net.alminoris.aestheticframes.item.ModItems;
import net.alminoris.aestheticframes.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aestheticframes");
    public static final RegistryObject<Block> WHITENED_WHITE_TERRACOTTA = ModBlocks.registerBlock("whitened_white_terracotta", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50287_)));
    public static final Dictionary<String, RegistryObject<Block>> FRAMES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                for (String name : BlockSetsHelper.getWoods()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "frame_" + name, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50287_))));
                }
                for (String name : BlockSetsHelper.getStones()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "frame_" + name, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50287_))));
                }
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> SCALED_FRAMES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                for (String name : BlockSetsHelper.getWoods()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "scaled_frame_" + name, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50287_))));
                }
                for (String name : BlockSetsHelper.getStones()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "scaled_frame_" + name, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50287_))));
                }
            }
        }
    };

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(ModItemGroups.AFS_TAB)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

