/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticframes.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticframes.item.ModItemGroups;
import net.alminoris.aestheticframes.item.ModItems;
import net.alminoris.aestheticframes.util.helper.BlockSetsHelper;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aestheticframes");
    public static final RegistryObject<Block> WHITENED_WHITE_TERRACOTTA = ModBlocks.registerBlock("whitened_white_terracotta", () -> new Block(Block.Properties.func_200950_a((Block)Blocks.field_196777_fo)));
    public static final Dictionary<String, RegistryObject<Block>> FRAMES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                for (String name : BlockSetsHelper.getWoods()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "frame_" + name, () -> new Block(Block.Properties.func_200950_a((Block)Blocks.field_196777_fo))));
                }
                for (String name : BlockSetsHelper.getStones()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "frame_" + name, () -> new Block(Block.Properties.func_200950_a((Block)Blocks.field_196777_fo))));
                }
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> SCALED_FRAMES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                for (String name : BlockSetsHelper.getWoods()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "scaled_frame_" + name, () -> new Block(Block.Properties.func_200950_a((Block)Blocks.field_196777_fo))));
                }
                for (String name : BlockSetsHelper.getStones()) {
                    this.put(frameName + name, ModBlocks.registerBlock(frameName + "scaled_frame_" + name, () -> new Block(Block.Properties.func_200950_a((Block)Blocks.field_196777_fo))));
                }
            }
        }
    };

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(ModItemGroups.AFS_TAB)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

