/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticframes.datagen;

import net.alminoris.aestheticframes.block.ModBlocks;
import net.alminoris.aestheticframes.util.helper.BlockSetsHelper;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator output, ExistingFileHelper exFileHelper) {
        super(output, "aestheticframes", exFileHelper);
    }

    protected void registerStatesAndModels() {
        Block block;
        this.simpleBlock((Block)ModBlocks.WHITENED_WHITE_TERRACOTTA.get());
        this.blockItem(ModBlocks.WHITENED_WHITE_TERRACOTTA, "block/whitened_white_terracotta");
        for (String name : BlockSetsHelper.getWoods()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                block = (Block)ModBlocks.FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                block = (Block)ModBlocks.SCALED_FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
        }
        for (String name : BlockSetsHelper.getStones()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                block = (Block)ModBlocks.FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                block = (Block)ModBlocks.SCALED_FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
        }
    }

    private void registerSimpleStateAndItem(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        if (id == null) {
            return;
        }
        ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(new ResourceLocation("aestheticframes", "block/" + id.func_110623_a()));
        this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)this.itemModels().getBuilder(id.func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("aestheticframes", "block/" + id.func_110623_a())));
    }

    private void blockItem(RegistryObject<? extends Block> blockRegistryObject, String name) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("aestheticframes:" + name));
    }
}

