/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticframes.datagen;

import java.util.Set;
import net.alminoris.aestheticframes.block.ModBlocks;
import net.alminoris.aestheticframes.util.helper.BlockSetsHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockLootTableProvider
extends BlockLootSubProvider {
    protected ModBlockLootTableProvider(HolderLookup.Provider pRegistries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), pRegistries);
    }

    protected void generate() {
        this.dropSelf((Block)ModBlocks.WHITENED_WHITE_TERRACOTTA.get());
        for (String name : BlockSetsHelper.getWoods()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                this.dropSelf((Block)ModBlocks.FRAMES.get(frameName + name).get());
            }
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                this.dropSelf((Block)ModBlocks.SCALED_FRAMES.get(frameName + name).get());
            }
        }
        for (String name : BlockSetsHelper.getStones()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                this.dropSelf((Block)ModBlocks.FRAMES.get(frameName + name).get());
            }
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                this.dropSelf((Block)ModBlocks.SCALED_FRAMES.get(frameName + name).get());
            }
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
    }
}

