/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticframes.datagen;

import java.util.concurrent.CompletableFuture;
import net.alminoris.aestheticframes.block.ModBlocks;
import net.alminoris.aestheticframes.util.helper.BlockSetsHelper;
import net.alminoris.aestheticframes.util.helper.ModJsonHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeExporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.WHITENED_WHITE_TERRACOTTA.get()), (int)1).pattern("#/").define(Character.valueOf('#'), (ItemLike)Blocks.WHITE_TERRACOTTA).define(Character.valueOf('/'), (ItemLike)Items.WHITE_DYE).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Blocks.WHITE_TERRACOTTA), ModRecipeProvider.has((ItemLike)Blocks.WHITE_TERRACOTTA)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.WHITE_DYE), ModRecipeProvider.has((ItemLike)Items.WHITE_DYE)).save(recipeExporter);
        for (String name : BlockSetsHelper.STONES) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.withDefaultNamespace((String)(name.equals("basalt_side") ? "basalt" : (name.equals("quartz_block_bottom") ? "quartz_block" : name))));
            this.registerFrame(recipeExporter, (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerVerticalFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("vertical_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerHorizontalFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("horizontal_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerPerpendicularFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("perpendicular_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerHorizontalCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("horizontal_crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerVerticalCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("vertical_crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerPerpendicularCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("perpendicular_crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerScaledCrestFrame(recipeExporter, (Block)ModBlocks.SCALED_FRAMES.get("crest_" + name).get(), (Block)ModBlocks.FRAMES.get("crest_" + name).get(), block);
        }
        for (String name : BlockSetsHelper.WOODS) {
            String blockName = name.equals("crimson") || name.equals("warped") ? "stem" : (name.equals("bamboo") ? "block" : "log");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.withDefaultNamespace((String)("stripped_" + name + "_" + blockName)));
            this.registerFrame(recipeExporter, (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerVerticalFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("vertical_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerHorizontalFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("horizontal_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerPerpendicularFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("perpendicular_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerHorizontalCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("horizontal_crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerVerticalCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("vertical_crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerPerpendicularCrestFrame(recipeExporter, (Block)ModBlocks.FRAMES.get("perpendicular_crest_" + name).get(), (Block)ModBlocks.FRAMES.get(name).get(), block);
            this.registerScaledCrestFrame(recipeExporter, (Block)ModBlocks.SCALED_FRAMES.get("crest_" + name).get(), (Block)ModBlocks.FRAMES.get("crest_" + name).get(), block);
        }
        this.registerExtraFrames(BlockSetsHelper.EXTRA_WOODS_AN, "arborealnature");
        this.registerExtraFrames(BlockSetsHelper.EXTRA_WOODS_WF, "wildfields");
        this.registerExtraFrames(BlockSetsHelper.EXTRA_STONES_WF, "wildfields");
        this.registerExtraFrames(BlockSetsHelper.MT_WOOD_NAMES, "missingtrees");
        this.registerExtraFrames(BlockSetsHelper.WT_WOOD_NAMES, "whisperleaftrees");
        this.registerExtraFrames(BlockSetsHelper.ST_WOOD_NAMES, "silverwoodtrees");
        this.registerExtraFrames(BlockSetsHelper.NSS_WOOD_NAMES, "natures_spirit", "_nss");
    }

    private void registerExtraFrames(String[] list, String modId) {
        for (String name : list) {
            ModJsonHelper.createShapedRecipe("frame_" + name, "4", modId + ":stripped_" + name + "_log", "aestheticframes:whitened_white_terracotta", "\"///\",", "\"/#/\",", "\"///\"");
            ModJsonHelper.createShapedRecipe("crest_frame_" + name, "2", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"/ /\",", "\" # \",", "\"/ /\"");
            ModJsonHelper.createShapedRecipe("vertical_frame_" + name, "1", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"/\",", "\"#\",", "\"/\"");
            ModJsonHelper.createShapedRecipe("horizontal_frame_" + name, "1", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("perpendicular_frame_" + name, "2", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\" / \",", "\"/#/\",", "\" / \"");
            ModJsonHelper.createShapedRecipe("horizontal_crest_frame_" + name, "3", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"/ /\",", "\"/#/\",", "\"/ /\"");
            ModJsonHelper.createShapedRecipe("vertical_crest_frame_" + name, "3", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"///\",", "\" # \",", "\"///\"");
            ModJsonHelper.createShapedRecipe("perpendicular_crest_frame_" + name, "4", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"///\",", "\"/#/\",", "\"///\"");
            ModJsonHelper.createShapedRecipe("crest_scaled_frame_" + name, "4", modId + ":stripped_" + name + "_log", "aestheticframes:crest_frame_" + name, "\"///\",", "\"/#/\",", "\"///\"");
        }
    }

    private void registerExtraFrames(String[] list, String modId, String toRemove) {
        for (String nameL : list) {
            String name = nameL.contains(toRemove) ? nameL.replaceFirst(toRemove, "") : nameL;
            ModJsonHelper.createShapedRecipe("frame_" + name, "4", modId + ":stripped_" + name + "_log", "aestheticframes:whitened_white_terracotta", "\"///\",", "\"/#/\",", "\"///\"");
            ModJsonHelper.createShapedRecipe("crest_frame_" + name, "2", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"/ /\",", "\" # \",", "\"/ /\"");
            ModJsonHelper.createShapedRecipe("vertical_frame_" + name, "1", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"/\",", "\"#\",", "\"/\"");
            ModJsonHelper.createShapedRecipe("horizontal_frame_" + name, "1", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "", "\"/#/\"", "");
            ModJsonHelper.createShapedRecipe("perpendicular_frame_" + name, "2", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\" / \",", "\"/#/\",", "\" / \"");
            ModJsonHelper.createShapedRecipe("horizontal_crest_frame_" + name, "3", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"/ /\",", "\"/#/\",", "\"/ /\"");
            ModJsonHelper.createShapedRecipe("vertical_crest_frame_" + name, "3", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"///\",", "\" # \",", "\"///\"");
            ModJsonHelper.createShapedRecipe("perpendicular_crest_frame_" + name, "4", modId + ":stripped_" + name + "_log", "aestheticframes:frame_" + name, "\"///\",", "\"/#/\",", "\"///\"");
            ModJsonHelper.createShapedRecipe("crest_scaled_frame_" + name, "4", modId + ":stripped_" + name + "_log", "aestheticframes:crest_frame_" + name, "\"///\",", "\"/#/\",", "\"///\"");
        }
    }

    private void registerFrame(RecipeOutput recipeExporter, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)frame, (int)4).pattern("///").pattern("/#/").pattern("///").define(Character.valueOf('#'), (ItemLike)ModBlocks.WHITENED_WHITE_TERRACOTTA.get()).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModBlocks.WHITENED_WHITE_TERRACOTTA.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WHITENED_WHITE_TERRACOTTA.get()))).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerCrestFrame(RecipeOutput recipeExporter, Block crestFrame, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crestFrame, (int)2).pattern("/ /").pattern(" # ").pattern("/ /").define(Character.valueOf('#'), (ItemLike)frame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)frame), ModRecipeProvider.has((ItemLike)frame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerHorizontalFrame(RecipeOutput recipeExporter, Block horizontalFrame, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)horizontalFrame, (int)1).pattern("/#/").define(Character.valueOf('#'), (ItemLike)frame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)frame), ModRecipeProvider.has((ItemLike)frame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerVerticalFrame(RecipeOutput recipeExporter, Block verticalFrame, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)verticalFrame, (int)1).pattern("/").pattern("#").pattern("/").define(Character.valueOf('#'), (ItemLike)frame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)frame), ModRecipeProvider.has((ItemLike)frame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerPerpendicularFrame(RecipeOutput recipeExporter, Block perpendicularFrame, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)perpendicularFrame, (int)2).pattern(" / ").pattern("/#/").pattern(" / ").define(Character.valueOf('#'), (ItemLike)frame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)frame), ModRecipeProvider.has((ItemLike)frame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerPerpendicularCrestFrame(RecipeOutput recipeExporter, Block perpendicularCrestFrame, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)perpendicularCrestFrame, (int)4).pattern("///").pattern("/#/").pattern("///").define(Character.valueOf('#'), (ItemLike)frame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)frame), ModRecipeProvider.has((ItemLike)frame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerHorizontalCrestFrame(RecipeOutput recipeExporter, Block horizontalCrestFrame, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)horizontalCrestFrame, (int)3).pattern("/ /").pattern("/#/").pattern("/ /").define(Character.valueOf('#'), (ItemLike)frame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)frame), ModRecipeProvider.has((ItemLike)frame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerVerticalCrestFrame(RecipeOutput recipeExporter, Block verticalCrestFrame, Block frame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)verticalCrestFrame, (int)3).pattern("///").pattern(" # ").pattern("///").define(Character.valueOf('#'), (ItemLike)frame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)frame), ModRecipeProvider.has((ItemLike)frame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }

    private void registerScaledCrestFrame(RecipeOutput recipeExporter, Block scaledCrestFrame, Block crestFrame, Block strippedOak) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)scaledCrestFrame, (int)4).pattern("///").pattern("/#/").pattern("///").define(Character.valueOf('#'), (ItemLike)crestFrame).define(Character.valueOf('/'), (ItemLike)strippedOak).unlockedBy(ModRecipeProvider.getHasName((ItemLike)crestFrame), ModRecipeProvider.has((ItemLike)crestFrame)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)strippedOak), ModRecipeProvider.has((ItemLike)strippedOak)).save(recipeExporter);
    }
}

