/*
 * Decompiled with CFR 0.152.
 */
package net.bitzero.unnamed_monster;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModBlocks;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModEnchantments;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModEntities;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModItems;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModMenus;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModMobEffects;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModParticleTypes;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModSounds;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModTabs;
import net.bitzero.unnamed_monster.init.UnnamedMonsterModVillagerProfessions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="unnamed_monster")
public class UnnamedMonsterMod {
    public static final Logger LOGGER = LogManager.getLogger(UnnamedMonsterMod.class);
    public static final String MODID = "unnamed_monster";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("unnamed_monster", "unnamed_monster"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public UnnamedMonsterMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        UnnamedMonsterModSounds.REGISTRY.register(bus);
        UnnamedMonsterModBlocks.REGISTRY.register(bus);
        UnnamedMonsterModItems.REGISTRY.register(bus);
        UnnamedMonsterModEntities.REGISTRY.register(bus);
        UnnamedMonsterModEnchantments.REGISTRY.register(bus);
        UnnamedMonsterModTabs.REGISTRY.register(bus);
        UnnamedMonsterModMobEffects.REGISTRY.register(bus);
        UnnamedMonsterModParticleTypes.REGISTRY.register(bus);
        UnnamedMonsterModVillagerProfessions.PROFESSIONS.register(bus);
        UnnamedMonsterModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

