/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.blockentity.AbyssPortalBlockEntity;
import wardentools.network.payloads.ShowWinScreen;
import wardentools.particle.ParticleRegistry;
import wardentools.worldgen.dimension.ModDimensions;
import wardentools.worldgen.portal.ModTeleporter;
import wardentools.worldgen.structure.ModStructures;
import wardentools.worldgen.structure.StructureUtils;

public class AbyssPortalBlock
extends Block
implements EntityBlock {
    public static final MapCodec<AbyssPortalBlock> CODEC = AbyssPortalBlock.simpleCodec(AbyssPortalBlock::new);

    public AbyssPortalBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AbyssPortalBlockEntity(pos, state);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return ItemStack.EMPTY;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, RandomSource random) {
        if (random.nextInt(100) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            int j = random.nextInt(2) * 2 - 1;
            if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                d3 = random.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                d5 = random.nextFloat() * 2.0f * (float)j;
            }
            level.addParticle((ParticleOptions)ParticleRegistry.ABYSS_PORTAL.get(), d0, d1, d2, d3, d4, d5);
        }
    }

    public void entityInside(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbyssPortalBlockEntity) {
                AbyssPortalBlockEntity abyssPortalBlockEntity = (AbyssPortalBlockEntity)blockEntity;
                if (abyssPortalBlockEntity.shouldShowWinScreen()) {
                    this.showWinScreen(player, pos);
                } else {
                    if (player.isPassenger()) {
                        player.stopRiding();
                    }
                    this.teleport((ServerLevel)level, pos, (Entity)player);
                }
            }
        } else if (!level.isClientSide) {
            for (Entity passengers : entity.getPassengers()) {
                this.teleport((ServerLevel)level, pos, passengers);
            }
            this.teleport((ServerLevel)level, pos, entity);
        }
    }

    private void teleport(ServerLevel level, BlockPos pos, Entity entity) {
        ServerLevel overworldLevel;
        if (level.dimension() == Level.OVERWORLD) {
            ServerLevel abyssLevel = level.getServer().getLevel(ModDimensions.ABYSS_LEVEL_KEY);
            if (abyssLevel != null) {
                BlockPos ancientCityPos = this.findNearestStructure(abyssLevel, ModStructures.SURFACE_ANCIENT_CITY, pos);
                this.teleportToAncientCity(entity, ModDimensions.ABYSS_LEVEL_KEY, ancientCityPos);
            }
        } else if (level.dimension() == ModDimensions.ABYSS_LEVEL_KEY && (overworldLevel = level.getServer().getLevel(Level.OVERWORLD)) != null) {
            BlockPos ancientCityPos = this.findNearestStructure(overworldLevel, (ResourceKey<Structure>)BuiltinStructures.ANCIENT_CITY, pos);
            this.teleportToAncientCity(entity, (ResourceKey<Level>)Level.OVERWORLD, ancientCityPos);
        }
    }

    private BlockPos findNearestStructure(ServerLevel level, ResourceKey<Structure> structureKey, BlockPos pos) {
        BlockPos nearestStructurePos = StructureUtils.findNearestStructure(level, structureKey, pos);
        return nearestStructurePos != null ? this.findSpawnOnPortalFrame((Level)level, nearestStructurePos) : new BlockPos(0, 0, 0);
    }

    private BlockPos findSpawnOnPortalFrame(Level level, BlockPos pos) {
        int i;
        for (i = level.getMinBuildHeight(); i < level.getMaxBuildHeight() && !level.getBlockState(pos.offset(0, i, 0)).is(Blocks.REINFORCED_DEEPSLATE); ++i) {
        }
        return pos.offset(level.random.nextBoolean() ? -2 : 2, i, level.random.nextBoolean() ? -2 : 2);
    }

    private void teleportToAncientCity(Entity entity, ResourceKey<Level> targetDimension, BlockPos targetPos) {
        ServerLevel targetLevel;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ServerLevel targetLevel2 = Objects.requireNonNull(entity.getServer()).getLevel(targetDimension);
            serverPlayer.changeDimension(ModTeleporter.diveToAncientCity(targetLevel2, targetPos, serverPlayer));
        } else if (!entity.level().isClientSide && (targetLevel = Objects.requireNonNull(entity.getServer()).getLevel(targetDimension)) != null) {
            entity.changeDimension(ModTeleporter.diveToAncientCity(targetLevel, targetPos, entity));
        }
    }

    protected void neighborChanged(@NotNull BlockState myState, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(myState, level, pos, neighborBlock, neighborPos, movedByPiston);
        BlockState newState = level.getBlockState(neighborPos);
        if (!this.isValidState(newState) && this.isValidState(neighborBlock.defaultBlockState())) {
            level.removeBlock(pos, false);
        }
    }

    public boolean isValidState(BlockState state) {
        return state.is(Blocks.REINFORCED_DEEPSLATE) || state.is((Block)BlockRegistry.ABYSS_PORTAL_BLOCK.get());
    }

    private void showWinScreen(Player player, BlockPos pos) {
        ServerLevel overworldLevel;
        if (player == null || player.level().isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        if (level.dimension() == Level.OVERWORLD) {
            ServerLevel abyssLevel = level.getServer().getLevel(ModDimensions.ABYSS_LEVEL_KEY);
            if (abyssLevel != null) {
                BlockPos ancientCityPos = this.findNearestStructure(abyssLevel, ModStructures.SURFACE_ANCIENT_CITY, pos);
                this.sendScreenPacket(player, ancientCityPos);
            }
        } else if (level.dimension() == ModDimensions.ABYSS_LEVEL_KEY && (overworldLevel = level.getServer().getLevel(Level.OVERWORLD)) != null) {
            BlockPos ancientCityPos = this.findNearestStructure(overworldLevel, (ResourceKey<Structure>)BuiltinStructures.ANCIENT_CITY, pos);
            this.sendScreenPacket(player, ancientCityPos);
        }
    }

    private void sendScreenPacket(Player player, BlockPos pos) {
        ((ServerLevel)player.level()).removePlayerImmediately((ServerPlayer)player, Entity.RemovalReason.CHANGED_DIMENSION);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ShowWinScreen(pos.getCenter().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull Fluid fluid) {
        return false;
    }
}

