/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import wardentools.misc.Crystal;
import wardentools.particle.ModParticleUtils;
import wardentools.particle.options.ShineParticleOptions;

public class CrystalBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<CrystalBlock> CODEC = RecordCodecBuilder.mapCodec(blockInstance -> blockInstance.group((App)Codec.FLOAT.fieldOf("height").forGetter(block -> Float.valueOf(block.height)), (App)Codec.FLOAT.fieldOf("aabb_offset").forGetter(block -> Float.valueOf(block.aabbOffset)), (App)Codec.INT.fieldOf("base_light_level").forGetter(block -> block.baseLightLevel), (App)Codec.STRING.fieldOf("crystal_type").forGetter(block -> block.crystalType.getSerializedName()), (App)CrystalBlock.propertiesCodec()).apply((Applicative)blockInstance, CrystalBlock::new));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty OVERCHARGED = BooleanProperty.create((String)"overcharged");
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;
    private final float height;
    private final float aabbOffset;
    private final int baseLightLevel;
    public final Crystal crystalType;

    public CrystalBlock(float height, float length, int baseLightLevel, String crystal, BlockBehaviour.Properties properties) {
        this(height, length, baseLightLevel, Crystal.fromName(crystal), properties);
    }

    public CrystalBlock(float height, float length, int baseLightLevel, Crystal crystal, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)OVERCHARGED, (Comparable)Boolean.valueOf(false)));
        this.upAabb = Block.box((double)length, (double)0.0, (double)length, (double)(16.0f - length), (double)height, (double)(16.0f - length));
        this.downAabb = Block.box((double)length, (double)(16.0f - height), (double)length, (double)(16.0f - length), (double)16.0, (double)(16.0f - length));
        this.northAabb = Block.box((double)length, (double)length, (double)(16.0f - height), (double)(16.0f - length), (double)(16.0f - length), (double)16.0);
        this.southAabb = Block.box((double)length, (double)length, (double)0.0, (double)(16.0f - length), (double)(16.0f - length), (double)height);
        this.eastAabb = Block.box((double)0.0, (double)length, (double)length, (double)height, (double)(16.0f - length), (double)(16.0f - length));
        this.westAabb = Block.box((double)(16.0f - height), (double)length, (double)length, (double)16.0, (double)(16.0f - length), (double)(16.0f - length));
        this.height = height;
        this.aabbOffset = length;
        this.baseLightLevel = baseLightLevel;
        this.crystalType = crystal;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (direction) {
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            default -> this.upAabb;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        return level.getBlockState(blockpos).isFaceSturdy((BlockGetter)level, blockpos, direction);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState state1, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos pos1) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction == ((Direction)state.getValue((Property)FACING)).getOpposite() && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state1, level, pos, pos1);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level levelaccessor = ctx.getLevel();
        BlockPos blockpos = ctx.getClickedPos();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)ctx.getClickedFace())).setValue((Property)OVERCHARGED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public static int getLightLevel(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)OVERCHARGED) != false ? 15 : 0;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.getBlock() instanceof CrystalBlock) {
            return (Boolean)state.getValue((Property)OVERCHARGED) != false ? 15 : this.baseLightLevel;
        }
        return super.getLightEmission(state, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{WATERLOGGED, FACING, OVERCHARGED});
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (random.nextInt(4) == 0) {
            ModParticleUtils.addStaticClientParticle(level, new ShineParticleOptions(Vec3.ZERO, this.crystalType.getColor()), pos.getCenter().offsetRandom(random, 1.0f));
        }
        super.animateTick(state, level, pos, random);
    }

    @NotNull
    protected MapCodec<CrystalBlock> codec() {
        return CODEC;
    }
}

