/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import wardentools.entity.custom.CrystalGolemEntity;

public class LightCandleGoal
extends Goal {
    private final CrystalGolemEntity golem;
    public Phase phase = Phase.TRAVEL;
    private static final int LIGHT_PHASE_DURATION = 40;
    private static final int TIME_TO_LIGHT = 30;
    private static final double SPEED = 1.0;
    private static final int POS_ACCURACY = 0;
    private int lightTick = 0;
    private static final int TIMEOUT = 2000;
    private int timeoutTick = 0;
    private int turnAroundTick = 0;
    private static final int SAME_CANDLE_CHECK_EVERY_X_TICK = 40;

    public LightCandleGoal(CrystalGolemEntity golem) {
        this.golem = golem;
    }

    public void start() {
        this.timeoutTick = 0;
        if (this.surroundingGolemHasSameTarget()) {
            this.stop();
            return;
        }
        this.changePhaseTo(Phase.TRAVEL);
        BlockPos targetPos = this.golem.peekUnlitCandle();
        Vec3 target = targetPos.getCenter();
        if (!this.golem.getNavigation().moveTo(target.x, target.y, target.z, 0, 1.0)) {
            this.golem.pollUnlitCandle();
            this.stop();
        }
    }

    public static boolean wouldLikeToStart(CrystalGolemEntity golem) {
        return !golem.getUnlitCandles().isEmpty();
    }

    public boolean canUse() {
        return LightCandleGoal.wouldLikeToStart(this.golem) && this.golem.isActive() && !this.golem.hasGrief();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() || this.phase == Phase.COMEBACK || this.phase == Phase.TURN_AROUND;
    }

    public void tick() {
        ++this.timeoutTick;
        if (this.timeoutTick > 2000) {
            this.stop();
        }
        if (this.timeoutTick % 40 == 0) {
            this.surroundingGolemHasSameTarget();
        }
        if (this.phase == Phase.TRAVEL) {
            if (this.golem.getUnlitCandles().isEmpty()) {
                this.goBack();
            } else if (this.golem.getNavigation().isDone()) {
                BlockPos targetPos = this.golem.peekUnlitCandle();
                if (targetPos != BlockPos.ZERO) {
                    BlockState state = this.golem.level().getBlockState(targetPos);
                    if (state.is(BlockTags.CANDLES) && state.hasProperty((Property)CandleBlock.LIT) && !((Boolean)state.getValue((Property)CandleBlock.LIT)).booleanValue()) {
                        this.changePhaseTo(Phase.LIGHT);
                    } else {
                        this.golem.pollUnlitCandle();
                        if (this.golem.getUnlitCandles().isEmpty()) {
                            this.changePhaseTo(Phase.COMEBACK);
                            Vec3 target = this.golem.getGolemStonePos().getCenter();
                            this.golem.getNavigation().moveTo(target.x, target.y, target.z, 0, 1.0);
                        }
                    }
                } else {
                    this.goBack();
                }
            }
        }
        if (this.phase == Phase.LIGHT) {
            ++this.lightTick;
            if (this.lightTick == 30) {
                this.golem.lightCandleAtPos();
            }
            if (this.lightTick > 40) {
                this.golem.pollUnlitCandle();
                this.lightTick = 0;
                if (!this.golem.getUnlitCandles().isEmpty()) {
                    this.changePhaseTo(Phase.TRAVEL);
                    BlockPos next = this.golem.peekUnlitCandle();
                    Vec3 target = next.getCenter();
                    this.golem.getNavigation().moveTo(target.x, target.y, target.z, 0, 1.0);
                } else {
                    this.goBack();
                }
            }
        }
        if (this.phase == Phase.COMEBACK && this.golem.getNavigation().isDone()) {
            this.turnAroundTick = this.golem.finalizeReturnToStone();
            this.changePhaseTo(Phase.TURN_AROUND);
        }
        if (this.phase == Phase.TURN_AROUND) {
            --this.turnAroundTick;
            if (this.turnAroundTick <= 0) {
                this.stop();
            }
        }
    }

    public void goBack() {
        this.changePhaseTo(Phase.COMEBACK);
        Vec3 target = this.golem.getGolemStonePos().getCenter();
        this.golem.getNavigation().moveTo(target.x, target.y, target.z, 0, 1.0);
    }

    public boolean surroundingGolemHasSameTarget() {
        return LightCandleGoal.surroundingGolemHasSameTarget(this.golem);
    }

    public static boolean surroundingGolemHasSameTarget(CrystalGolemEntity golem) {
        BlockPos targetPos = golem.peekUnlitCandle();
        if (targetPos != BlockPos.ZERO) {
            for (CrystalGolemEntity otherGolem : golem.getNearbyGolems()) {
                if (otherGolem == golem || otherGolem.getUnlitCandles().isEmpty() || !otherGolem.peekUnlitCandle().equals((Object)targetPos) || !(golem.distanceToTarget() > otherGolem.distanceToTarget())) continue;
                golem.pollUnlitCandle();
                return true;
            }
        }
        return false;
    }

    public void stop() {
        this.lightTick = 0;
        this.timeoutTick = 0;
        this.turnAroundTick = 0;
        this.phase = Phase.TRAVEL;
        this.golem.getUnlitCandles().clear();
        this.golem.setState(this.golem.level().getRandom().nextBoolean() ? CrystalGolemEntity.GolemState.DEACTIVATED_1 : CrystalGolemEntity.GolemState.DEACTIVATED_2);
    }

    private void changePhaseTo(Phase phase) {
        this.phase = phase;
        this.phase.setAssociatedGolemState(this.golem);
    }

    public static enum Phase {
        TRAVEL(CrystalGolemEntity.GolemState.TRAVELING),
        LIGHT(CrystalGolemEntity.GolemState.LIGHT),
        COMEBACK(CrystalGolemEntity.GolemState.TRAVELING),
        TURN_AROUND(null);

        private final CrystalGolemEntity.GolemState state;

        private Phase(CrystalGolemEntity.GolemState associatedState) {
            this.state = associatedState;
        }

        public void setAssociatedGolemState(CrystalGolemEntity golem) {
            if (this.state != null) {
                golem.setState(this.state);
            }
        }
    }
}

